<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trade_change_holder_name', function (Blueprint $table) {
            $table->boolean('is_payment_paid')->default(0)->after('is_aapale_sarkar_payment_paid');
            $table->date('payment_date')->nullable()->after('is_payment_paid');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trade_change_holder_name', function (Blueprint $table) {
            $table->dropColumn(['is_payment_paid', 'payment_date']);
        });
    }
};
