<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trade_licenses', function (Blueprint $table) {
            $table->boolean('is_payment_paid')->default(0)->after('prescribed_doc');
            $table->date('payment_date')->nullable()->after('is_payment_paid');
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trade_licenses', function (Blueprint $table) {
             $table->dropColumn(['is_payment_paid', 'payment_date']);
        });
    }
};
