<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('construction_road_cutting_road_details', function (Blueprint $table) {
            // Change defect_factor column type to FLOAT for flexible decimal display
            $table->float('defect_factor', 8, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('construction_road_cutting_road_details', function (Blueprint $table) {
            // Rollback to INT if needed
            $table->integer('defect_factor')->nullable()->change();
        });
    }
};
