<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('registration_sequences', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('service_id'); // service reference
            $table->year('year'); // year for sequence
            $table->unsignedInteger('sequence')->default(0); // sequence number
            $table->timestamps();

            $table->unique(['service_id', 'year']); // one row per service per year
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('registration_sequences');
    }
};
