<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vrukshtypes', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // मुख्य प्रकार
            $table->string('name'); // नाव
            $table->string('sub_name')->nullable(); // उपप्रकार (optional)
            $table->decimal('rate', 10, 2)->nullable(); // दर
            $table->decimal('amount', 10, 2)->nullable(); // एकूण रक्कम
            $table->string('question1')->nullable(); // प्रश्न 1
            $table->string('question2')->nullable(); // प्रश्न 2
            $table->decimal('yes_amount', 10, 2)->nullable(); // हो असल्यास रक्कम
            $table->decimal('no_amount', 10, 2)->nullable();  // नाही असल्यास रक्कम
            $table->timestamps(); // created_at, updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vrukshtypes');
    }
};
