<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tree_protections', function (Blueprint $table) {
            $table->string('new_plant')->nullable()->after('id');
            $table->string('space_available')->nullable()->after('new_plant');
            $table->string('new_replant')->nullable()->after('space_available');
            $table->string('space_replant')->nullable()->after('new_replant');
        });
    }

    public function down(): void
    {
        Schema::table('tree_protections', function (Blueprint $table) {
            $table->dropColumn(['new_plant', 'space_available', 'new_replant', 'space_replant']);
        });
    }
};
