<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('demand_safai', function (Blueprint $table) {

            $table->string('applicant_name')->nullable();
            $table->string('applicant_mobile', 13)->nullable();
            $table->string('pin_code', 6)->nullable();
            $table->string('email')->nullable();
            $table->text('applicant_address')->nullable();
            $table->string('aadhar', 12)->nullable();

            $table->string('ward')->nullable();
            $table->string('election_ward')->nullable();
            $table->string('usage_type')->nullable();

            $table->enum('cleaning_type', ['dry', 'wet'])->nullable();
            $table->string('expected_waste')->nullable();
            $table->enum('requirement', ['daily', 'weekly', 'monthly'])->nullable();
            $table->enum('toilet_cleaning', ['yes', 'no'])->nullable();
            $table->unsignedInteger('toilet_qty')->default(0);
            $table->enum('include_exclude', ['include', 'exclude'])->nullable();
            $table->enum('within_mbmc', ['yes', 'no'])->nullable();
            $table->date('cleaning_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demand_safai');
    }
};
