<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::table('granting_telecoms', function (Blueprint $table) {

        // 0 or 1 store hoga (boolean = tinyint in MySQL)
        $table->boolean('is_startdate_enddate')
              ->default(0)
              ->after('updated_at');

        // 0 or 1 store hoga
        $table->boolean('is_generated')
              ->default(0)
              ->after('is_startdate_enddate');

        // Certificate generated time
        $table->timestamp('certificate_generated_at')
              ->nullable()
              ->after('is_generated');
    });
}

public function down(): void
{
    Schema::table('granting_telecoms', function (Blueprint $table) {
        $table->dropColumn([
            'is_startdate_enddate',
            'is_generated',
            'certificate_generated_at'
        ]);
    });
}
};
