<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sewerage_properties', function (Blueprint $table) {
            $table->string('property_no', 3000)->change();
            $table->string('applicant_name', 1000)->change();
        });
    }

    public function down(): void
    {
        Schema::table('sewerage_properties', function (Blueprint $table) {
            // down() मध्ये जुने datatype टाक (उदा. 255 असेल तर)
            $table->string('property_no', 255)->change();
            $table->string('applicant_name', 255)->change();
        });
    }
};
