<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class AdvertisementTypes extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       $data = [
            ['id' => 2, 'item' => 'होडिंग(आकाशचिन्हे / कमानी/कॅन्टीलीवर पोल/ब) खाजगी जागा/इमारती इ. ठिकाणावरील', 'rate' => '40'],
        ];

        foreach ($data as $datas) {
            DB::table('advertisement_types')->updateOrInsert(
                ['id' => $datas['id']],
                [
                    'item' => $datas['item'],
                    'rate' => $datas['rate'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
