<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;


class DefaultLoginUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Super Admin Seeder ##
        $superAdminRole = Role::updateOrCreate(['name' => 'Super Admin']);
        $permissions = Permission::pluck('id', 'id')->all();
        $superAdminRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'superadmin@gmail.com'
        ], [
            'name' => 'Super Admin',
            'email' => 'superadmin@gmail.com',
            'mobile' => '9999999991',
            'password' => Hash::make('12345678'),
        ]);
        $user->assignRole([$superAdminRole->id]);



        // User Seeder ##
        $userRole = Role::updateOrCreate(['name' => 'User']);
        $permissions = Permission::pluck('id', 'id')->all();
        $userRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'mbmc@gmail.com'
        ], [
            'name' => 'MBMC',
            'email' => 'mbmc@gmail.com',
            'mobile' => '9999999992',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$userRole->id]);

        // Admin Seeder ##
        $AdminRole = Role::updateOrCreate(['name' => 'Admin']);
        $permissions = Permission::pluck('id', 'id')->all();
        $AdminRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'admin@gmail.com'
        ], [
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'mobile' => '9999999993',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$AdminRole->id]);

        // ExecutiveEngineer Seeder ##
        $ExecutiveEngineerRole = Role::updateOrCreate(['name' => 'ExecutiveEngineer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $ExecutiveEngineerRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'executiveengineer@gmail.com'
        ], [
            'name' => 'ExecutiveEngineer',
            'email' => 'executiveengineer@gmail.com',
            'mobile' => '9999999994',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$ExecutiveEngineerRole->id]);

        // HOD Seeder ##
        $CityEngineerRole = Role::updateOrCreate(['name' => 'CityEngineer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $CityEngineerRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'cityengineer@gmail.com'
        ], [
            'name' => 'CityEngineer',
            'email' => 'cityengineer@gmail.com',
            'mobile' => '9999999995',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$CityEngineerRole->id]);

        // Clerk Seeder ##
        $ClerkRole = Role::updateOrCreate(['name' => 'Clerk']);
        $permissions = Permission::pluck('id', 'id')->all();
        $ClerkRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'clerk@gmail.com'
        ], [
            'name' => 'Clerk',
            'email' => 'clerk@gmail.com',
            'mobile' => '9999999996',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$ClerkRole->id]);

        // JE Seeder ##
        $JuniorEngineerRole = Role::updateOrCreate(['name' => 'JuniorEngineer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $JuniorEngineerRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'juniorengineer@gmail.com'
        ], [
            'name' => 'JuniorEngineer',
            'email' => 'juniorengineer@gmail.com',
            'mobile' => '9999999997',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$JuniorEngineerRole->id]);

        // DeputyEngineer Seeder ##
        $DeputyEngineerRole = Role::updateOrCreate(['name' => 'DeputyEngineer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $DeputyEngineerRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'deputyengineer@gmail.com'
        ], [
            'name' => 'DeputyEngineer',
            'email' => 'deputyengineer@gmail.com',
            'mobile' => '9999999997',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$DeputyEngineerRole->id]);

        // City Engineer  Seeder ##
        $CityEngineerRole = Role::updateOrCreate(['name' => 'CityEngineer']);
        $permissions = Permission::pluck('id', 'id')->all();
        $CityEngineerRole->syncPermissions($permissions);

        $user = User::updateOrCreate([
            'email' => 'cityengineer@gmail.com'
        ], [
            'name' => 'CityEngineer',
            'email' => 'cityengineer@gmail.com',
            'mobile' => '9999999999',
            'password' => Hash::make('12345678')
        ]);
        $user->assignRole([$CityEngineerRole->id]);
    }
}
