<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Department;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            'जन्म मृत्यु',
            'नगररचना विभाग',
            'विवाह नोंदणी',
            'मालमत्ता कर विभाग',
            'पाणी विभाग',
            'व्यापार परवाना',
            'अग्निशमन विभाग',
            'आरोग्य विभाग',
            'वृक्ष विभाग',
            'PWD',
            'इस्टेट विभाग',
            'ड्रेनेज आणि सांडपाणी',
            'जाहिरात विभाग',
            'घनकचरा विभाग',
            'शिक्षण विभाग',
            'मंडप परवानगी',
            'विद्युत'

        ];

        foreach ($departments as $name) {
            Department::updateOrCreate(['name' => $name]);
        }
    }
}
