<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class MultifactorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $multifactor = [
            ['id' => 1, 'item' => 'Excavation during first year of Defect Liability Period', 'year' => '4.0'],
            ['id' => 2, 'item' => 'Excavation during second year of Defect Liability Period', 'year' => '3'],
            ['id' => 3, 'item' => 'Excavation during third year of Defect Liability Period', 'year' => '2'],
            ['id' => 4, 'item' => 'Excavation during fourth year of Defect Liability Period', 'year' => '1.7'],
            ['id' => 5, 'item' => 'Excavation during fifth year of Defect Liability Period', 'year' => '1.4'],
            ['id' => 6, 'item' => 'Excavation beyond Defect Liability Period', 'year' => '1.0'],



        ];

        foreach ($multifactor as $multifactors) {
            DB::table('multifactor_defect')->updateOrInsert(
                ['id' => $multifactors['id']],
                [
                    'item' => $multifactors['item'],
                    'year' => $multifactors['year'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
