<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PartmapSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run(): void
    {
        $records = [
            [
                'type' => 'Photocopy',
                'rate' => 1100,
            ],
            [
                'type' => 'Print Copy',
                'rate' => 100,
            ],
        ];

        foreach ($records as $record) {
            DB::table('partmapstypes')->updateOrInsert(
                ['type' => $record['type']], // condition to check existing
                [
                    'rate' => $record['rate'],
                ]
            );
        }
    }
}
