<?php

namespace Database\Seeders;

use Illuminate\Support\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PrabhagWardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $prabhagward = [
            ['id' => 1, 'prabhag_id' => '1', 'ward_name' => 'B07'],
            ['id' => 2, 'prabhag_id' => '1', 'ward_name' => 'B08'],
            ['id' => 3, 'prabhag_id' => '1', 'ward_name' => 'B09'],
            ['id' => 4, 'prabhag_id' => '1', 'ward_name' => 'B04'],
            ['id' => 5, 'prabhag_id' => '1', 'ward_name' => 'B06'],
            ['id' => 6, 'prabhag_id' => '1', 'ward_name' => 'C01'],
            ['id' => 7, 'prabhag_id' => '1', 'ward_name' => 'D03'],
            ['id' => 8, 'prabhag_id' => '1', 'ward_name' => 'D04'],
            ['id' => 9, 'prabhag_id' => '1', 'ward_name' => 'P01'],
            ['id' => 10, 'prabhag_id' => '1', 'ward_name' => 'P02'],
            ['id' => 11, 'prabhag_id' => '1', 'ward_name' => 'S01'],
            ['id' => 12, 'prabhag_id' => '1', 'ward_name' => 'S02'],
            ['id' => 13, 'prabhag_id' => '1', 'ward_name' => 'T01'],
            ['id' => 14, 'prabhag_id' => '1', 'ward_name' => 'R01'],
            ['id' => 15, 'prabhag_id' => '1', 'ward_name' => 'R02'],
            ['id' => 16, 'prabhag_id' => '1', 'ward_name' => 'R03'],

            ['id' => 17, 'prabhag_id' => '2', 'ward_name' => 'A01'],
            ['id' => 18, 'prabhag_id' => '2', 'ward_name' => 'A02'],
            ['id' => 19, 'prabhag_id' => '2', 'ward_name' => 'A03'],
            ['id' => 20, 'prabhag_id' => '2', 'ward_name' => 'B05'],
            ['id' => 21, 'prabhag_id' => '2', 'ward_name' => 'B01'],
            ['id' => 22, 'prabhag_id' => '2', 'ward_name' => 'B02'],
            ['id' => 23, 'prabhag_id' => '2', 'ward_name' => 'D01'],
            ['id' => 24, 'prabhag_id' => '2', 'ward_name' => 'D02'],
            ['id' => 25, 'prabhag_id' => '2', 'ward_name' => 'B03'],

            ['id' => 26, 'prabhag_id' => '3', 'ward_name' => 'G01'],
            ['id' => 27, 'prabhag_id' => '3', 'ward_name' => 'G02'],
            ['id' => 28, 'prabhag_id' => '3', 'ward_name' => 'G03'],
            ['id' => 29, 'prabhag_id' => '3', 'ward_name' => 'H01'],
            ['id' => 30, 'prabhag_id' => '3', 'ward_name' => 'H02'],
            ['id' => 31, 'prabhag_id' => '3', 'ward_name' => 'H03'],
            ['id' => 32, 'prabhag_id' => '3', 'ward_name' => 'H04'],
            ['id' => 33, 'prabhag_id' => '3', 'ward_name' => 'Z01'],
            ['id' => 34, 'prabhag_id' => '3', 'ward_name' => 'H05'],
            ['id' => 35, 'prabhag_id' => '3', 'ward_name' => 'J01'],
            ['id' => 36, 'prabhag_id' => '3', 'ward_name' => 'J02'],
            ['id' => 37, 'prabhag_id' => '3', 'ward_name' => 'J03'],
            ['id' => 38, 'prabhag_id' => '3', 'ward_name' => 'F01'],
            ['id' => 39, 'prabhag_id' => '3', 'ward_name' => 'G04'],
            ['id' => 40, 'prabhag_id' => '3', 'ward_name' => 'G05'],
            ['id' => 41, 'prabhag_id' => '3', 'ward_name' => 'G06'],
            ['id' => 42, 'prabhag_id' => '3', 'ward_name' => 'G07'],
            ['id' => 43, 'prabhag_id' => '3', 'ward_name' => 'G08'],
            ['id' => 44, 'prabhag_id' => '3', 'ward_name' => 'I01'],
            ['id' => 45, 'prabhag_id' => '3', 'ward_name' => 'I02'],
            ['id' => 46, 'prabhag_id' => '3', 'ward_name' => 'I03'],
            ['id' => 47, 'prabhag_id' => '3', 'ward_name' => 'I04'],

            ['id' => 48, 'prabhag_id' => '4', 'ward_name' => 'F02'],
            ['id' => 49, 'prabhag_id' => '4', 'ward_name' => 'F03'],
            ['id' => 50, 'prabhag_id' => '4', 'ward_name' => 'F04'],
            ['id' => 51, 'prabhag_id' => '4', 'ward_name' => 'F05'],
            ['id' => 52, 'prabhag_id' => '4', 'ward_name' => 'F06'],
            ['id' => 53, 'prabhag_id' => '4', 'ward_name' => 'O01'],
            ['id' => 54, 'prabhag_id' => '4', 'ward_name' => 'O02'],
            ['id' => 55, 'prabhag_id' => '4', 'ward_name' => 'E10'],
            ['id' => 56, 'prabhag_id' => '4', 'ward_name' => 'E11'],
            ['id' => 57, 'prabhag_id' => '4', 'ward_name' => 'E01'],
            ['id' => 58, 'prabhag_id' => '4', 'ward_name' => 'E09'],

            ['id' => 59, 'prabhag_id' => '5', 'ward_name' => 'E02'],
            ['id' => 60, 'prabhag_id' => '5', 'ward_name' => 'E03'],
            ['id' => 61, 'prabhag_id' => '5', 'ward_name' => 'E04'],
            ['id' => 62, 'prabhag_id' => '5', 'ward_name' => 'E05'],
            ['id' => 63, 'prabhag_id' => '5', 'ward_name' => 'E06'],
            ['id' => 64, 'prabhag_id' => '5', 'ward_name' => 'E07'],
            ['id' => 65, 'prabhag_id' => '5', 'ward_name' => 'E12'],
            ['id' => 66, 'prabhag_id' => '5', 'ward_name' => 'E13'],
            ['id' => 67, 'prabhag_id' => '5', 'ward_name' => 'E14'],
            ['id' => 68, 'prabhag_id' => '5', 'ward_name' => 'E15'],

            ['id' => 70, 'prabhag_id' => '6', 'ward_name' => 'L03'],
            ['id' => 71, 'prabhag_id' => '6', 'ward_name' => 'L04'],
            ['id' => 72, 'prabhag_id' => '6', 'ward_name' => 'L01'],
            ['id' => 73, 'prabhag_id' => '6', 'ward_name' => 'L02'],
            ['id' => 74, 'prabhag_id' => '6', 'ward_name' => 'K03'],
            ['id' => 75, 'prabhag_id' => '6', 'ward_name' => 'K04'],
            ['id' => 76, 'prabhag_id' => '6', 'ward_name' => 'Q01'],
            ['id' => 77, 'prabhag_id' => '6', 'ward_name' => 'Q02'],
            ['id' => 78, 'prabhag_id' => '6', 'ward_name' => 'K01'],
            ['id' => 79, 'prabhag_id' => '6', 'ward_name' => 'K02'],
            ['id' => 80, 'prabhag_id' => '6', 'ward_name' => 'M01'],
            ['id' => 81, 'prabhag_id' => '6', 'ward_name' => 'M02'],
            ['id' => 82, 'prabhag_id' => '6', 'ward_name' => 'M03'],
            ['id' => 83, 'prabhag_id' => '6', 'ward_name' => 'N01'],
            ['id' => 84, 'prabhag_id' => '6', 'ward_name' => 'E08'],
            ['id' => 85, 'prabhag_id' => '6', 'ward_name' => 'E18'],
            ['id' => 86, 'prabhag_id' => '6', 'ward_name' => 'E16'],
            ['id' => 87, 'prabhag_id' => '6', 'ward_name' => 'E17'],
            ['id' => 88, 'prabhag_id' => '6', 'ward_name' => 'E19'],
            ['id' => 89, 'prabhag_id' => '6', 'ward_name' => 'E20']
        ];

        foreach ($prabhagward as $multifactors) {
            DB::table('prabhag_wards')->updateOrInsert(
                ['id' => $multifactors['id']],
                [
                    'prabhag_id' => $multifactors['prabhag_id'],
                    'ward_name' => $multifactors['ward_name'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
