<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class RoadTypeRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roadTypes = [
            ['id' => 1, 'road_type' => 'रस्त्याखालून भुयारी मार्गाने ड्रिलिंग करणे', 'rate' => '2200'],
            ['id' => 2, 'road_type' => 'ग्रॉउंटींग केलेला रस्ता', 'rate' => '4953'],
            ['id' => 3, 'road_type' => 'कच्चा रस्ता', 'rate' => '2891'],
            ['id' => 4, 'road_type' => 'डब्लू बी एम रस्ता', 'rate' => '3919'],
            ['id' => 5, 'road_type' => 'काँक्रीट रस्ता सी सी पॅलेस', 'rate' => '12024'],
            ['id' => 6, 'road_type' => 'काँक्रेट रस्ता सी. सी साईड पट्टी', 'rate' => '12292'],
            ['id' => 7, 'road_type' => 'काँक्रीट रस्ता यु.टी.डब्लू.टी', 'rate' => '15069'],
            ['id' => 8, 'road_type' => 'डांबरी रस्ता', 'rate' => '9600'],
            ['id' => 9, 'road_type' => 'काँक्रीट पदपथ', 'rate' => '5500'],
            ['id' => 10, 'road_type' => 'फ्लायओव्हर', 'rate' => '130000'],
            ['id' => 11, 'road_type' => 'सब-वे', 'rate' => '780000'],
            ['id' => 12, 'road_type' => 'कलवर्ट', 'rate' => '57200'],


        ];

        foreach ($roadTypes as $roadType) {
            DB::table('road_types')->updateOrInsert(
                ['id' => $roadType['id']],
                [
                    'road_type' => $roadType['road_type'],
                    'rate' => $roadType['rate'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
