<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ServiceCredential;

class ServiceCredentialSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                "id" => 1,
                'dept_service_id' => '75',
                'service_name' => 'Marriage Registration',
                'service_url' => 'marriage-registration/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6774,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 25,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 2,
                'dept_service_id' => '3',
                'service_name' => 'Issuance Of Property Tax Assessment Copy',
                'service_url' => 'issuance-of-property-tax/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6813,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 3,
                'dept_service_id' => '2',
                'service_name' => 'Issuance Of No Dues Certificate (Property)',
                'service_url' => 'no-dues/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6814,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 4,
                'dept_service_id' => '4',
                'service_name' => 'Issuance Of Transfer Of Property Certificate Other Way',
                'service_url' => 'transfer-property/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8248,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 5,
                'dept_service_id' => '5',
                'service_name' => 'New Taxation',
                'service_url' => 'new-taxation/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8265,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 6,
                'dept_service_id' => '8',
                'service_name' => 'Re-taxation',
                'service_url' => 'retaxation/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7351,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 7,
                'dept_service_id' => '6',
                'service_name' => 'Preparation Of Tax Demand',
                'service_url' => 'tax-demand/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7352,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 8,
                'dept_service_id' => '7',
                'service_name' => 'Property Tax Exemption',
                'service_url' => 'tax-exemption/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7353,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 9,
                'dept_service_id' => '11',
                'service_name' => 'Tax exemption for non-resident properties',
                'service_url' => 'tax-exemption-non-resident/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7354,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 10,
                'dept_service_id' => '9',
                'service_name' => 'Self Assessment',
                'service_url' => 'self-assessment/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7355,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 11,
                'dept_service_id' => '10',
                'service_name' => 'To File An Objection',
                'service_url' => 'registration-of-objection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7356,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 12,
                'dept_service_id' => '21',
                'service_name' => 'New Water Connection',
                'service_url' => 'water-new-connection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6800,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 13,
                'dept_service_id' => '22',
                'service_name' => 'Complaint Of Illegal Water Connection',
                'service_url' => 'water-illegal-connection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6801,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 14,
                'dept_service_id' => '23',
                'service_name' => 'Making Change In Ownership',
                'service_url' => 'water-change-ownership/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6802,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 15,
                'dept_service_id' => '24',
                'service_name' => 'Making Change In Water Connection Size',
                'service_url' => 'water-connection-size-change/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6803,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 16,
                'dept_service_id' => '15',
                'service_name' => 'Water Re Connection',
                'service_url' => 'water-reconnection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6804,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 17,
                'dept_service_id' => '16',
                'service_name' => 'Making Change In Water Connection Size',
                'service_url' => 'water-disconnect-supply/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6805,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 6805,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 18,
                'dept_service_id' => '17',
                'service_name' => 'Water Connection Usage Change',
                'service_url' => 'water-change-connection-usage/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6806,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 19,
                'dept_service_id' => '18',
                'service_name' => 'Preparation Of Water Tax Bill',
                'service_url' => 'water-Tax-bill/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6807,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 365,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 20,
                'dept_service_id' => '19',
                'service_name' => 'No Dues Certificate Water Supply',
                'service_url' => 'water-no-dues/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6808,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 21,
                'dept_service_id' => '20',
                'service_name' => 'Certificate Of Unavailability Of Water Supply',
                'service_url' => 'water-unavailability-supply/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6809,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 22,
                'dept_service_id' => '25',
                'service_name' => 'Complaint Of Defective Water Meter',
                'service_url' => 'water-defective-meter/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6810,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 23,
                'dept_service_id' => '26',
                'service_name' => 'Complaint Of Water Pressure',
                'service_url' => 'water-pressure-complaint/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6811,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 24,
                'dept_service_id' => '27',
                'service_name' => 'Complaint Of Water Quality',
                'service_url' => 'water-quality-complaint/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 6812,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 25,
                'dept_service_id' => '30',
                'service_name' => 'Plumber License',
                'service_url' => 'trade-plumber-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7357,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 26,
                'dept_service_id' => '31',
                'service_name' => 'Renewal Of Plumber License',
                'service_url' => 'renewal-plumber-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7358,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 27,
                'dept_service_id' => '32',
                'service_name' => 'New Trade License Permission',
                'service_url' => 'trade-new-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7359,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 28,
                'dept_service_id' => '33',
                'service_name' => 'Renewal Of Trade License Permission',
                'service_url' => 'trade-renewal-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7291,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 29,
                'dept_service_id' => '34',
                'service_name' => 'Auto Renewal of Trade License',
                'service_url' => 'trade-autorenewal-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7292,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 30,
                'dept_service_id' => '35',
                'service_name' => 'Transfer Of Trade License Permission',
                'service_url' => 'trade-license-transfer/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7293,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 31,
                'dept_service_id' => '36',
                'service_name' => 'Request For Trade License Permission Secondry Copy',
                'service_url' => 'trade-per-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7294,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 32,
                'dept_service_id' => '37',
                'service_name' => 'NOC for Pandol/ Mandap',
                'service_url' => 'trade-noc-mandap/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7295,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 3,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 33,
                'dept_service_id' => '38',
                'service_name' => 'Trade License Name Change Request',
                'service_url' => 'trade-change-license-name/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7296,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 34,
                'dept_service_id' => '39',
                'service_name' => 'Trade License Type Change Request',
                'service_url' => 'trade-change-license-type/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7297,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 35,
                'dept_service_id' => '41',
                'service_name' => 'Cancellation of Trade License',
                'service_url' => 'trade-license-cancellation/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7298,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 36,
                'dept_service_id' => '43',
                'service_name' => 'Trade License Owner Or Partner Count Change',
                'service_url' => 'trade-change-owner-count/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7299,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 37,
                'dept_service_id' => '27',
                'service_name' => 'Renewal Of Trade License Permission',
                'service_url' => 'trade-renewal-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7360,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 38,
                'dept_service_id' => '28',
                'service_name' => 'New Trade License Permission',
                'service_url' => 'trade-new-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7361,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 39,
                'dept_service_id' => '78',
                'service_name' => 'Issuance Of Fire No Objection Certificate(Fire)',
                'service_url' => 'fire-no-objection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7362,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 40,
                'dept_service_id' => '79',
                'service_name' => 'Issuance Of Final Fire No Objection Certificate (Fire)',
                'service_url' => 'fire-final-no-objection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7363,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 41,
                'dept_service_id' => '80',
                'service_name' => 'Issuance of zone certificate',
                'service_url' => 'town-planing-zone-certificate/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7364,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 60,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 42,
                'dept_service_id' => '81',
                'service_name' => 'Giving Part Map',
                'service_url' => 'town-planing-bhag-nakasha/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7365,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 60,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 43,
                'dept_service_id' => '82',
                'service_name' => 'Road Cutting Permission',
                'service_url' => 'construction-road-cutting/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7366,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 44,
                'dept_service_id' => '83',
                'service_name' => 'Jal Mal Nissaran Connection',
                'service_url' => 'construction-drainage-connection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7367,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 45,
                'dept_service_id' => '183',
                'service_name' => 'Issuance Of Fire No Objection Certificate(Fire)',
                'service_url' => 'fire-no-objection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7302,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 46,
                'dept_service_id' => '184',
                'service_name' => 'Issuance Of Final Fire No Objection Certificate (Fire)',
                'service_url' => 'fire-final-no-objection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7303,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 47,
                'dept_service_id' => '185',
                'service_name' => 'Issuance of zone certificate',
                'service_url' => 'town-planing-zone-certificate/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7304,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 60,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 48,
                'dept_service_id' => '186',
                'service_name' => 'Giving Part Map',
                'service_url' => 'town-planing-bhag-nakasha/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7305,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 60,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 49,
                'dept_service_id' => '187',
                'service_name' => 'Road Cutting Permission',
                'service_url' => 'construction-road-cutting/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7306,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 50,
                'dept_service_id' => '188',
                'service_name' => 'Jal Mal Nissaran Connection',
                'service_url' => 'construction-drainage-connection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 7307,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 51,
                'dept_service_id' => '2020',
                'service_name' => 'New Tax Assessment',
                'service_url' => 'newtax-assessment/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8567,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 12,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 52,
                'dept_service_id' => '2021',
                'service_name' => 'Division of property in sub divisionn',
                'service_url' => 'divsub-division/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8568,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 12,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 53,
                'dept_service_id' => '2002',
                'service_name' => 'Advertisement License/Signage License New License and Renewal',
                'service_url' => 'advertisement-permission/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8570,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 15,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 54,
                'dept_service_id' => '2015',
                'service_name' => '	NOC of municipality for state license of food business',
                'service_url' => 'state-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8573,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 12,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 55,
                'dept_service_id' => '2016',
                'service_name' => 'Health NOC of municipality for state license of food business',
                'service_url' => 'healthnoc-munici/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8574,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 12,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 56,
                'dept_service_id' => '2027',
                'service_name' => '	License for the Lodging House',
                'service_url' => 'trade-license-loading/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8575,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 57,
                'dept_service_id' => '2028',
                'service_name' => 'Renewal License for the Lodging House',
                'service_url' => 'trade-renew-license-loading/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8576,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 58,
                'dept_service_id' => '2029',
                'service_name' => 'Issuance of license for Marriage Hall/Meeting Hall etc.',
                'service_url' => 'trade-issuance-license-marriage/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8577,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 59,
                'dept_service_id' => '2030',
                'service_name' => 'Renewal of License for Marriage Hall/Meeting Hall etc.',
                'service_url' => 'trade-renew-license-marriage/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8578,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 7,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 60,
                'dept_service_id' => '2033',
                'service_name' => 'Granting permission for felling of trees as per the provisions of Section 8 of the Maharashtra Urban Areas Tree Protection and Conservation Act, 1975',
                'service_url' => 'tree-protection/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8579,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 45,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 61,
                'dept_service_id' => '2014',
                'service_name' => 'Mobile Tower Permission',
                'service_url' => 'mobile-tower/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8580,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 30,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 62,
                'dept_service_id' => '241',
                'service_name' => 'To issue occupancy certificate',
                'service_url' => 'town-occupancy-certificate/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8582,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 63,
                'dept_service_id' => '2032',
                'service_name' => 'Granting permission for laying underground telecommunication duct (optical fiber cable)',
                'service_url' => 'grant-telecome/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8583,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 64,
                'dept_service_id' => '2022',
                'service_name' => 'Tax assessment on demolishing and reconstruction of the property',
                'service_url' => 'demolishingproperty/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8584,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 65,
                'dept_service_id' => '2024',
                'service_name' => 'Licensing of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'service_url' => 'grantnursing-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8586,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 66,
                'dept_service_id' => '2025',
                'service_name' => 'Renewal of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'service_url' => 'renewnursing-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8587,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 67,
                'dept_service_id' => '2026',
                'service_name' => 'Owners Name change/ Partner name  of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'service_url' => 'changenursing-license/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8588,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 68,
                'dept_service_id' => '2034',
                'service_name' => 'Movie Shooting License (Movie Shooting License) New License and Renewal',
                'service_url' => 'movie-shooting/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8571,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 69,
                'dept_service_id' => '2035',
                'service_name' => 'To issue building permission',
                'service_url' => 'town-building-permission/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8581,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 70,
                'dept_service_id' => '2037',
                'service_name' => 'Change The Business Holder/Partner',
                'service_url' => 'trade-change-holder-partner/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8585,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ],
            [
                "id" => 72,
                'dept_service_id' => '2038',
                'service_name' => 'To issue drainage / sewer connection',
                'service_url' => 'drainage/create',
                'client_code' => 'PNL224',
                'check_sum_key' => 'PNMCNN2v247M',
                'str_key' => '@pn@PNM@m@h@0nl!ne@23523',
                'str_iv' => 'PNM@05@3',
                'soap_end_point_url' => 'https://testcitizenservices.mahaitgov.in//Dept_Authentication.asmx',
                'soap_action_url' => 'http://tempuri.org/GetParameterNew',
                'soap_action_app_status_url' => 'http://tempuri.org/SetAppStatus',
                'validate_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/ValidateRequest',
                'out_payment_url' => 'https://testcitizenservices.mahaitgov.in//en/OutPayment/Pay',
                'service_id' => 8585,
                'ulb_id' => 18,
                'ulb_district' => 520,
                'service_day' => 21,
                'is_paid_service' => 1,
                'is_paid_service_by_aapale_sarkar' => 1,
                'service_charge' => 100
            ]
        ];

        foreach ($services as $service) {
            ServiceCredential::updateOrCreate([
                'id' => $service['id']
            ], [
                'id' => $service['id'],
                'dept_service_id' => $service['dept_service_id'],
                'service_name' => $service['service_name'],
                'service_url' => $service['service_url'],
                'client_code' => $service['client_code'],
                'check_sum_key' => $service['check_sum_key'],
                'str_key' => $service['str_key'],
                'str_iv' => $service['str_iv'],
                'soap_end_point_url' => $service['soap_end_point_url'],
                'soap_action_url' => $service['soap_action_url'],
                'soap_action_app_status_url' => $service['soap_action_app_status_url'],
                'validate_payment_url' => $service['validate_payment_url'],
                'out_payment_url' => $service['out_payment_url'],
                'service_id' => $service['service_id'],
                'ulb_id' => $service['ulb_id'],
                'ulb_district' => $service['ulb_district'],
                'service_day' => $service['service_day'],
                'is_paid_service' => $service['is_paid_service'],
                'is_paid_service_by_aapale_sarkar' => $service['is_paid_service_by_aapale_sarkar'],
                'service_charge' => $service['service_charge'],
            ]);
        }
    }
}
