<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ServiceName;

class ServiceNameSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'service_id' => 2,
                'service_name' => 'No Due Certificate/थकबाकी नसल्याचे प्रमाणपत्र',
                'model' => '\App\Models\PropertyTax\NoDueCertificate',
                'add_route' => 'no-dues.create',
                'edit_route' => 'no-dues.edit',
                'certificate_route' => 'no-dues.show',
                'receipt_route' => 'no-dues.generateReceipt',
            ],
            [
                'service_id' => 3,
                'service_name' => 'Property Tax Assessment/मालमत्ता कर उतारा देणे',
                'model' => '\App\Models\PropertyTax\PropertyTaxAssessment',
                'add_route' => 'issuance-of-property-tax.create',
                'edit_route' => 'issuance-of-property-tax.edit',
                'certificate_route' => 'issuance-of-property-tax.show',
                'receipt_route' => 'issuance-of-property-tax.generateReceipt',
            ],
            [
                'service_id' => 4,
                'service_name' => 'Transfer Property Certificate/दस्तऐवजाच्या आधारे मालमत्ता हस्तांतरण नोंद प्रमाणपत्र देणे',
                'model' => '\App\Models\PropertyTax\TransferPropertyCertificate',
                'add_route' => 'transfer-property.create',
                'edit_route' => 'transfer-property.edit',
                'certificate_route' => 'transfer-property.show',
                'receipt_route' => 'transfer-property.generateReceipt',

            ],
            [
                'service_id' => 5,
                'service_name' => 'New Taxation/नव्याने कर आकारणी',
                'model' => '\App\Models\PropertyTax\Newtaxation',
                'add_route' => 'new-taxation.create',
                'edit_route' => 'new-taxation.edit',
                'certificate_route' => 'new-taxation.show',
                'receipt_route' => 'new-taxation.generateReceipt',


            ],
            [
                'service_id' => 9,
                'service_name' => 'Self Assessment/स्वयंमुल्यांकन',
                'model' => '\App\Models\PropertyTax\SelfAssessment',
                'add_route' => 'self-assessment.create',
                'edit_route' => 'self-assessment.edit',
                'certificate_route' => 'self-assessment.show',
                'receipt_route' => 'self-assessment.generateReceipt'

            ],
            [
                'service_id' => 6,
                'service_name' => 'Tax Demands/कराची मागणीपत्र तयार करणे',
                'model' => '\App\Models\PropertyTax\TaxDemand',
                'add_route' => 'tax-demand.create',
                'edit_route' => 'tax-demand.edit',
                'certificate_route' => 'tax-demand.show',
                'receipt_route' => 'tax-demand.generateReceipt',
            ],
            [
                'service_id' => 7,
                'service_name' => 'Tax Exemption/करमाफी मिळणे',
                'model' => '\App\Models\PropertyTax\TaxExemption',
                'add_route' => 'tax-exemption.create',
                'edit_route' => 'tax-exemption.edit',
                'certificate_route' => 'tax-exemption.show',
                'receipt_route' => 'tax-exemption.generateReceipt',
            ],
            [
                'service_id' => 8,
                'service_name' => 'ReTaxation/पुनः कर आकारणी',
                'model' => '\App\Models\PropertyTax\ReTaxation',
                'add_route' => 'retaxation.create',
                'edit_route' => 'retaxation.edit',
                'certificate_route' => 'retaxation.show',
                'receipt_route' => 'retaxation.generateReceipt',
            ],
            [
                'service_id' => 10,
                'service_name' => 'Registration Of Objection/आक्षेप नोंदविणे',
                'model' => '\App\Models\PropertyTax\RegistrationOfObjection',
                'add_route' => 'registration-of-objection.create',
                'edit_route' => 'registration-of-objection.edit',
                'certificate_route' => 'registration-of-objection.show',
                'receipt_route' => 'registration-of-objection.generateReceipt'

            ],
            [
                'service_id' => 11,
                'service_name' => 'Tax Exemption Non Resident Properties/रहिवासी नसलेल्या मालमत्ताना करात सूट मिळणे',
                'model' => '\App\Models\PropertyTax\TaxExemptionNonResidentProperties',
                'add_route' => 'tax-exemption-non-resident.create',
                'edit_route' => 'tax-exemption-non-resident.edit',
                'certificate_route' => 'tax-exemption-non-resident.show',
                'receipt_route' => 'tax-exemption-non-resident.generateReceipt'

            ],
            [
                'service_id' => 21,
                'service_name' => 'New Water Connection / नविन नळजोडणी',
                'model' => '\App\Models\WaterDepartment\Waternewconnection',
                'add_route' => 'water-new-connection.create',
                'edit_route' => 'water-new-connection.edit',
                'certificate_route' => 'water-new-connection.show',
                'receipt_route' => 'water-new-connection.generateReceipt',

            ],
            [
                'service_id' => 22,
                'service_name' => 'Complaint Of Illegal Water Connection / अनधिकृत नळ जोडणी तक्रार',
                'model' => '\App\Models\WaterDepartment\Illegalwaterconnection',
                'add_route' => 'water-illegal-connection.create',
                'edit_route' => 'water-illegal-connection.edit',
                'certificate_route' => 'water-illegal-connection.show',
                'receipt_route' => 'water-illegal-connection.generateReceipt',

            ],
            [
                'service_id' => 23,
                'service_name' => 'Making Change In Ownership / मालकी हक्कात बदल करणे',
                'model' => '\App\Models\WaterDepartment\WaterChangeOwnership',
                'add_route' => 'water-change-ownership.create',
                'edit_route' => 'water-change-ownership.edit',
                'certificate_route' => 'water-change-ownership.show',
                'receipt_route' => 'water-change-ownership.generateReceipt',

            ],
            [
                'service_id' => 24,
                'service_name' => 'Making Change In Water Connection Size / नळजोडणी आकारामध्ये बदल करणे',
                'model' => '\App\Models\WaterDepartment\WaterChangeConnectionSize',
                'add_route' => 'water-connection-size-change.create',
                'edit_route' => 'water-connection-size-change.edit',
                'certificate_route' => 'water-connection-size-change.show',
                'receipt_route' => 'water-connection-size-change.generateReceipt',

            ],
            [
                'service_id' => 15,
                'service_name' => 'Water Re Connection / पुनः जोडणी करणे',
                'model' => '\App\Models\WaterDepartment\WaterReconnection',
                'add_route' => 'water-reconnection.create',
                'edit_route' => 'water-reconnection.edit',
                'certificate_route' => 'water-reconnection.show',
                'receipt_route' => 'water-reconnection.generateReceipt',
            ],
            [
                'service_id' => 16,
                'service_name' => 'Disconnection Water Supply / तात्पुरते किंवा कायमस्वरूपी नळजोडणी खंडीत करणे',
                'model' => '\App\Models\WaterDepartment\WaterDisconnectSupply',
                'add_route' => 'water-disconnect-supply.create',
                'edit_route' => 'water-disconnect-supply.edit',
                'certificate_route' => 'water-disconnect-supply.show',
                'receipt_route' => 'water-disconnect-supply.generateReceipt',

            ],
            [
                'service_id' => 17,
                'service_name' => 'Connection Usage Change / नळजोडणीच्या वापरामध्ये बदल करणे',
                'model' => '\App\Models\WaterDepartment\WaterChangeInUse',
                'add_route' => 'water-change-connection-usage.create',
                'edit_route' => 'water-change-connection-usage.edit',
                'certificate_route' => 'water-change-connection-usage.show',
                'receipt_route' => 'water-change-connection-usage.generateReceipt',

            ],
            [
                'service_id' => 18,
                'service_name' => 'Preparation Of Water Tax Bill / पाणी देयक तयार करणे',
                'model' => '\App\Models\WaterDepartment\WaterTaxBill',
                'add_route' => 'water-Tax-bill.create',
                'edit_route' => 'water-Tax-bill.edit',
                'certificate_route' => 'water-Tax-bill.show',
                'receipt_route' => 'water-Tax-bill.generateReceipt',
            ],
            [
                'service_id' => 19,
                'service_name' => 'No Dues Certificate Water Supply / थकबाकी नसल्याचा दाखला ( पाणी पुरवठा )',
                'model' => '\App\Models\WaterDepartment\WaterNoDues',
                'add_route' => 'water-no-dues.create',
                'edit_route' => 'water-no-dues.edit',
                'certificate_route' => 'water-no-dues.show',
                'receipt_route' => 'water-no-dues.generateReceipt',
            ],
            [
                'service_id' => 20,
                'service_name' => 'Unavailability Of Water Supply / पाणीपुरवठा जोडणी नसले बाबत प्रमाणपत्र',
                'model' => '\App\Models\WaterDepartment\WaterUnavailabilitySupply',
                'add_route' => 'water-unavailability-supply.create',
                'edit_route' => 'water-unavailability-supply.edit',
                'certificate_route' => 'water-unavailability-supply.show',
                'receipt_route' => 'water-unavailability-supply.generateReceipt',

            ],
            [
                'service_id' => 25,
                'service_name' => 'Complaint Of Defective Water Meter / नादुरुस्त मिटर तक्रार करणे',
                'model' => '\App\Models\WaterDepartment\WaterDefectiveMeter',
                'add_route' => 'water-defective-meter.create',
                'edit_route' => 'water-defective-meter.edit',
                'certificate_route' => 'water-defective-meter.show',
                'receipt_route' => 'water-defective-meter.generateReceipt',
            ],
            [
                'service_id' => 26,
                'service_name' => 'Complaint Of Water Pressure / पाण्याची दबाव क्षमता तक्रार',
                'model' => '\App\Models\WaterDepartment\WaterPressureComplaint',
                'add_route' => 'water-pressure-complaint.create',
                'edit_route' => 'water-pressure-complaint.edit',
                'certificate_route' => 'water-pressure-complaint.show',
                'receipt_route' => 'water-pressure-complaint.generateReceipt',
            ],
            [
                'service_id' => 27,
                'service_name' => 'Complaint Of Water Quality / पाण्याची गुणवत्ता तक्रार',
                'model' => '\App\Models\WaterDepartment\WaterQualityComplaint',
                'add_route' => 'water-quality-complaint.create',
                'edit_route' => 'water-quality-complaint.edit',
                'certificate_route' => 'water-quality-complaint.show',
                'receipt_route' => 'water-quality-complaint.generateReceipt',

            ],
            [
                'service_id' => 30,
                'service_name' => 'Plumber License / प्लंबर परवाना',
                'model' => '\App\Models\WaterDepartment\WaterPlumberLicense',
                'add_route' => 'trade-plumber-license.create',
                'edit_route' => 'trade-plumber-license.edit',
                'certificate_route' => 'trade-plumber-license.show',
                'receipt_route' => 'trade-plumber-license.generateReceipt',

            ],
            [
                'service_id' => 31,
                'service_name' => 'Renewal Of Plumber License / प्लंबर परवाना नुतनीकरण करणे',
                'model' => '\App\Models\WaterDepartment\WaterRenewalOfPlumber',
                'add_route' => 'renewal-plumber-license.create',
                'edit_route' => 'renewal-plumber-license.edit',
                'certificate_route' => 'renewal-plumber-license.show',
                'receipt_route' => 'renewal-plumber-license.generateReceipt',
            ],
            [
                'service_id' => 32,
                'service_name' => 'New Trade License Permission / नवीन व्यवसाय परवाना मिळणे',
                'model' => '\App\Models\Trade\TradeNewLicensePermission',
                'add_route' => 'trade-new-license.create',
                'edit_route' => 'trade-new-license.edit',
                'certificate_route' => 'trade-new-license.show',
                'receipt_route' => 'trade-new-license.generateReceipt',
            ],
            [
                'service_id' => 33,
                'service_name' => 'Renewal Of Trade License Permission/व्यवसाय परवाना नुतनीकरण',
                'model' => '\App\Models\Trade\TradeRenewalLicensePermission',
                'add_route' => 'trade-renewal-license.create',
                'edit_route' => 'trade-renewal-license.edit',
                'certificate_route' => 'trade-renewal-license.show',
                'receipt_route' => 'trade-renewal-license.generateReceipt',
            ],
            [
                'service_id' => 34,
                'service_name' => 'Auto Renewal of Trade License / व्यवसाय परवाना स्वयंनुतनीकरण',
                'model' => '\App\Models\Trade\TradeAutoRenewalLicensePermission',
                'add_route' => 'trade-autorenewal-license.create',
                'edit_route' => 'trade-autorenewal-license.edit',
                'certificate_route' => 'trade-autorenewal-license.show',
                'receipt_route' => 'trade-autorenewal-license.generateReceipt',

            ],
            [
                'service_id' => 35,
                'service_name' => 'Transfer Of Trade License Permission / व्यवसाय परवाना हस्तांतरण करणे',
                'model' => '\App\Models\Trade\TradeLicenseTransfer',
                'add_route' => 'trade-license-transfer.create',
                'edit_route' => 'trade-license-transfer.edit',
                'certificate_route' => 'trade-license-transfer.show',
                'receipt_route' => 'trade-license-transfer.generateReceipt',

            ],
            [
                'service_id' => 36,
                'service_name' => 'Trade License Permission Secondry Copy / व्यवसाय परवाना दुय्यम प्रत मिळणे',
                'model' => '\App\Models\Trade\TradePerLicense',
                'add_route' => 'trade-per-license.create',
                'edit_route' => 'trade-per-license.edit',
                'certificate_route' => 'trade-per-license.show',
                'receipt_route' => 'trade-per-license.generateReceipt',
            ],
            [
                'service_id' => 37,
                'service_name' => 'NOC for Pandal/Mandap / मंडपासाठी ना हरकत प्रमाणपत्र',
                'model' => '\App\Models\Trade\TradeNocForMandap',
                'add_route' => 'trade-noc-mandap.create',
                'edit_route' => 'trade-noc-mandap.edit',
                'certificate_route' => 'trade-noc-mandap.show',
                'reject_certificate' => 'trade-noc-mandap.downloadRejectionCertificate',
                'receipt_route' => 'trade-noc-mandap.generateReceipt',

            ],
            [
                'service_id' => 38,
                'service_name' => 'Trade License Name Change Request / व्यवसायाचे नाव बदलणे',
                'model' => '\App\Models\Trade\TradeChangeLicenseName',
                'add_route' => 'trade-change-license-name.create',
                'edit_route' => 'trade-change-license-name.edit',
                'certificate_route' => 'trade-change-license-name.show',
                'receipt_route' => 'trade-change-license-name.generateReceipt',

            ],
            [
                'service_id' => 39,
                'service_name' => 'Trade License Type Change Request / व्यवसाय (प्रकार) बदलणे',
                'model' => '\App\Models\Trade\TradeChangeLicenseType',
                'add_route' => 'trade-change-license-type.create',
                'edit_route' => 'trade-change-license-type.edit',
                'certificate_route' => 'trade-change-license-type.show',
                'receipt_route' => 'trade-change-license-type.generateReceipt',

            ],
            [
                'service_id' => 41,
                'service_name' => 'Cancellation of Trade License / व्यवसाय परवाना रद्द करणे',
                'model' => '\App\Models\Trade\TradeLicenseCancellation',
                'add_route' => 'trade-license-cancellation.create',
                'edit_route' => 'trade-license-cancellation.edit',
                'certificate_route' => 'trade-license-cancellation.show',
                'receipt_route' => 'trade-license-cancellation.generateReceipt',

            ],
            [
                'service_id' => 43,
                'service_name' => 'License Partner Count Change / भागीदाराच्या संख्येत बदल (वाढ/ कमी)',
                'model' => '\App\Models\Trade\TradeChangeOwnerCount',
                'add_route' => 'trade-change-owner-count.create',
                'edit_route' => 'trade-change-owner-count.edit',
                'certificate_route' => 'trade-change-owner-count.show',
                'receipt_route' => 'trade-change-owner-count.generateReceipt',
            ],
            // [
            //     'service_id' => 36,
            //     'service_name' => 'License Partner Name Change',
            //     'model' => '\App\Models\Trade\TradeChangeOwnerName',
            //     'add_route' => 'trade-change-owner-name.create',
            //     'edit_route' => 'trade-change-owner-name.edit'
            // ],
            [
                'service_id' => 75,
                'service_name' => 'ISSUANCE OF MARRIAGE REGISTRATION CERTIFICATE/विवाह नोंदणी प्रमाणपत्र देणे',
                'model' => '\App\Models\Marriage\MarriageRegistrationForm',
                'add_route' => 'marriage-registration.create',
                'edit_route' => 'marriage-registration.edit',
                'certificate_route' => 'marriage-registration.show',
                'receipt_route' => 'marriage-registration.generateReceipt',

            ],
            [
                'service_id' => 183,
                'service_name' => 'Issuance Of Fire No Objection Certificate(Fire)/अग्निशमन ना-हरकत दाखला देणे',
                'model' => '\App\Models\FireDepartment\FireNoObjection',
                'add_route' => 'fire-no-objection.create',
                'edit_route' => 'fire-no-objection.edit',
                'certificate_route' => 'fire-no-objection.show',
                'receipt_route' => 'fire-no-objection.generateReceipt',

            ],
            [
                'service_id' => 184,
                'service_name' => 'Issuance Of Final Fire No Objection Certificate (Fire)/अग्निशमन अंतिम ना हरकत दाखला',
                'model' => '\App\Models\FireDepartment\FireFinalNoObjection',
                'add_route' => 'fire-final-no-objection.create',
                'edit_route' => 'fire-final-no-objection.edit',
                'certificate_route' => 'fire-final-no-objection.show',
                'receipt_route' => 'fire-final-no-objection.generateReceipt',

            ],
            [
                'service_id' => 185,
                'service_name' => 'Issuance of zone certificate/झोन दाखला देणे',
                'model' => '\App\Models\CityStructure\CityStructureZoneCertificate',
                'add_route' => 'town-planing-zone-certificate.create',
                'edit_route' => 'town-planing-zone-certificate.edit',
                'certificate_route' => 'town-planing-zone-certificate.show',
                'receipt_route' => 'town-planing-zone-certificate.generateReceipt',

            ],
            [
                'service_id' => 186,
                'service_name' => 'Giving Part Map/भाग नकाशा देणे',
                'model' => '\App\Models\CityStructure\CityStructurePartMap',
                'add_route' => 'town-planing-bhag-nakasha.create',
                'edit_route' => 'town-planing-bhag-nakasha.edit',
                'certificate_route' => 'town-planing-bhag-nakasha.show',
                'receipt_route' => 'town-planing-bhag-nakasha.generateReceipt',

            ],
            [
                'service_id' => 187,
                'service_name' => 'Road Cutting Permission/रस्ते खोदणे परवानगी',
                'model' => '\App\Models\ConstructionDepartment\ConstructionRoadCutting',
                'add_route' => 'construction-road-cutting.create',
                'edit_route' => 'construction-road-cutting.edit',
                'certificate_route' => 'construction-road-cutting.show',
                'receipt_route' => 'construction-road-cutting.generateReceipt',
                'demandnote'  => 'construction-road-cutting.demand_note',
                'payment' => 'construction-road-cutting.paymentoptions'
            ],
            [
                'service_id' => 188,
                'service_name' => 'Jal Mal Nissaran Connection',
                'model' => '\App\Models\ConstructionDepartment\ConstructionDrainageConnection',
                'add_route' => 'construction-drainage-connection.create',
                'edit_route' => 'construction-drainage-connection.edit',
                'certificate_route' => 'construction-drainage-connection.show',
                'receipt_route' => 'construction-drainage-connection.generateReceipt',

            ],
            [
                'service_id' => 2001,
                'service_name' => 'Abattoir License',
                'model' => '\App\Models\AbattoirLicense',
                'add_route' => 'abattoir-license.create',
                'edit_route' => 'abattoir-license.edit',
                'certificate_route' => 'abattoir-license.show',
                'receipt_route' => 'abattoir-license.generateReceipt',

            ],
            [
                'service_id' => 2002,
                'service_name' => 'Advertizement Permission',
                'model' => '\App\Models\AdvertisementPermission',
                'add_route' => 'advertisement-permission.create',
                'edit_route' => 'advertisement-permission.edit',
                'certificate_route' => 'advertisement-permission.show',
                'receipt_route' => 'advertisement-permission.generateReceipt',
            ],
            [
                'service_id' => 2003,
                'service_name' => 'Gardens Filming and Photography Permission',
                'model' => '\App\Models\GardensFilming',
                'add_route' => 'gardens-filming.create',
                'edit_route' => 'gardens-filming.edit',
                'certificate_route' => 'gardens-filming.show',
                'receipt_route' => 'gardens-filming.generateReceipt',
            ],
            [
                'service_id' => 2004,
                'service_name' => 'Health License',
                'model' => '\App\Models\HealthLicense',
                'add_route' => 'health-license.create',
                'edit_route' => 'health-license.edit',
                'certificate_route' => 'health-license.show',
                'receipt_route' => 'health-license.generateReceipt',

            ],
            [
                'service_id' => 2005,
                'service_name' => 'Hoarding Permission  ',
                'model' => '\App\Models\HoardingPermission',
                'add_route' => 'hoarding-permission.create',
                'edit_route' => 'hoarding-permission.edit',
                'certificate_route' => 'hoarding-permission.show',
                'receipt_route' => 'hoarding-permission.generateReceipt',
                'demandnote'  => 'hoarding-permission.generatedemandnote'

            ],
            // [
            //     'service_id' => 241,
            //     'service_name' => 'Occupancy Completion Certificate',
            //     'model' => '\App\Models\TownPlanning\OccupancyCertificate',
            //     'add_route' => 'town-occupancy-certificate.create',
            //     'edit_route' => 'town-occupancy-certificate.edit',
            //     'certificate_route' => 'town-occupancy-certificate.show'

            // ],
            [
                'service_id' => 2006,
                'service_name' => 'Park Culture Permission  ',
                'model' => '\App\Models\ParkCulturePermission',
                'add_route' => 'park-culture.create',
                'edit_route' => 'park-culture.edit',
                'certificate_route' => 'park-culture.show',
                'receipt_route' => 'park-culture.generateReceipt',
            ],
            [
                'service_id' => 2008,
                'service_name' => 'Permission for Shooting ',
                'model' => '\App\Models\PermissionShooting',
                'add_route' => 'permission-shooting.create',
                'edit_route' => 'permission-shooting.edit',
                'certificate_route' => 'permission-shooting.show',
                'receipt_route' => 'permission-shooting.generateReceipt',

            ],

            [
                'service_id' => 240,
                'service_name' => 'Issue Plinth Completion Certificate ',
                'model' => '\App\Models\PlinthCertificate',
                'add_route' => 'plinth-certification.create',
                'edit_route' => 'plinth-certification.edit',
                'certificate_route' => 'plinth-certification.show',
                'receipt_route' => 'plinth-certification.generateReceipt',
            ],
            [
                'service_id' => 2007,
                'service_name' => 'Permission For PMCs Owned ground for temporary rent ',
                'model' => '\App\Models\permissionForPmcOwn',
                'add_route' => 'pmc-owned.create',
                'edit_route' => 'pmc-owned.edit',
                'certificate_route' => 'pmc-owned.show',
                'receipt_route' => 'pmc-owned.generateReceipt',

            ],
            [
                'service_id' => 2008,
                'service_name' => 'Permission for Shooting ',
                'model' => '\App\Models\PermissionShooting',
                'add_route' => 'permission-shooting.create',
                'edit_route' => 'permission-shooting.edit',
                'certificate_route' => 'permission-shooting.show',
                'receipt_route' => 'permission-shooting.generateReceipt',
            ],

            [
                'service_id' => 2009,
                'service_name' => 'Projection And Stall Board License ',
                'model' => '\App\Models\StallBoardLicense',
                'add_route' => 'stallboard-license.create',
                'edit_route' => 'stallboard-license.edit',
                'certificate_route' => 'stallboard-license.show',
                'receipt_route' => 'stallboard-license.generateReceipt',

            ],

            [
                'service_id' => 2010,
                'service_name' => 'Tents Permission On Temporarily Basis',
                'model' => '\App\Models\TentsPermission',
                'add_route' => 'tents-permission.create',
                'edit_route' => 'tents-permission.edit',
                'certificate_route' => 'tents-permission.show',
                'receipt_route' => 'tents-permission.generateReceipt',
            ],
            [
                'service_id' => 2011,
                'service_name' => 'Permission for PMCs Owned School Classrooms & Classrooms For Rent',
                'model' => '\App\Models\ClassroomsForRent',
                'add_route' => 'classroom-rent.create',
                'edit_route' => 'classroom-rent.edit',
                'certificate_route' => 'classroom-rent.show',
                'receipt_route' => 'classroom-rent.generateReceipt',

            ],
            [
                'service_id' => 2012,
                'service_name' => 'permission for Procession and Parade',
                'model' => '\App\Models\ProcessionAndParade',
                'add_route' => 'procession-parade.create',
                'edit_route' => 'procession-parade.edit',
                'certificate_route' => 'procession-parade.show',
                'receipt_route' => 'procession-parade.generateReceipt',

            ],
            [
                'service_id' => 2013,
                'service_name' => 'To Record Objection',
                'model' => '\App\Models\RecordObjections',
                'add_route' => 'record-objections.create',
                'edit_route' => 'record-objections.edit',
                'certificate_route' => 'record-objections.show',
                'receipt_route' => 'record-objections.generateReceipt',
            ],
            // [
            //     'service_id' => 2014,
            //     'service_name' => 'Mobile Tower Permission',
            //     'model' => '\App\Models\MobileTower',
            //     'add_route' => 'mobile-tower.create',
            //     'edit_route' => 'mobile-tower.edit',
            //     'certificate_route' => 'mobile-tower.show'

            // ],
            
            [
                'service_id' => 2015,
                'service_name' => 'NOC of Municipality for State License Of Food Business',
                'model' => '\App\Models\StateLicense',
                'add_route' => 'state-license.create',
                'edit_route' => 'state-license.edit',
                'certificate_route' => 'state-license.show',
                'receipt_route' => 'state-license.generateReceipt',

            ],

            [
                'service_id' => 2016,
                'service_name' => 'Health NOC of municipality for state license of food business',
                'model' => '\App\Models\HealthNocMunci',
                'add_route' => 'healthnoc-munici.create',
                'edit_route' => 'healthnoc-munici.edit',
                'certificate_route' => 'healthnoc-munici.show',
                'receipt_route' => 'healthnoc-munici.generateReceipt',

            ],
            [
                'service_id' => 2017,
                'service_name' => 'Movable Advertisement Permission',
                'model' => '\App\Models\MovableAdvertisementPermission',
                'add_route' => 'movable-advertisement.create',
                'edit_route' => 'movable-advertisement.edit',
                'certificate_route' => 'movable-advertisement.show',
                'receipt_route' => 'movable-advertisement.generateReceipt',

            ],

            [
                'service_id' => 2018,
                'service_name' => 'CFC',
                'model' => '\App\Models\Cfc',
                'add_route' => 'cfc.create',
                'edit_route' => 'cfc.edit',
                'certificate_route' => 'cfc.show',
                'receipt_route' => 'cfc.generateReceipt',

            ],
            [
                'service_id' => 2020,
                'service_name' => 'New Tax Assessment',
                'model' => '\App\Models\NewTaxAssessment',
                'add_route' => 'newtax-assessment.create',
                'edit_route' => 'newtax-assessment.edit',
                'certificate_route' => 'newtax-assessment.show',
                'receipt_route' => 'newtax-assessment.generateReceipt',
            ],
            [
                'service_id' => 2021,
                'service_name' => 'Division Of Property In Sub Division',
                'model' => '\App\Models\DivSubDivision',
                'add_route' => 'divsub-division.create',
                'edit_route' => 'divsub-division.edit',
                'certificate_route' => 'divsub-division.show',
                'receipt_route' => 'divsub-division.generateReceipt',

            ],
            [
                'service_id' => 2022,
                'service_name' => 'Tax Assessment On Demolishing And Reconstruction Of The Property',
                'model' => '\App\Models\DemolishingProperty',
                'add_route' => 'demolishingproperty.create',
                'edit_route' => 'demolishingproperty.edit',
                'certificate_route' => 'demolishingproperty.show',
                'receipt_route' => 'demolishing-property.generateReceipt',

            ],
            [
                'service_id' => 2023,
                'service_name' => 'Trade NOC',
                'model' => '\App\Models\Trade\TradeNoc',
                'add_route' => 'tradenoc.create',
                'edit_route' => 'tradenoc.edit',
                'certificate_route' => 'tradenoc.show',
                'receipt_route' => 'tradenoc.generateReceipt',

            ],

            [
                'service_id' => 2024,
                'service_name' => 'Licensing of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'model' => '\App\Models\MedicalHealth\GrantNursingLicense',
                'add_route' => 'grantnursing-license.create',
                'edit_route' => 'grantnursing-license.edit',
                'certificate_route' => 'grantnursing-license.show',
                'receipt_route' => 'grantnursing-license.generateReceipt',

            ],

            [
                'service_id' => 2025,
                'service_name' => 'Renewal of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'model' => '\App\Models\MedicalHealth\RenewalNursingLicense',
                'add_route' => 'renewnursing-license.create',
                'edit_route' => 'renewnursing-license.edit',
                'certificate_route' => 'renewnursing-license.show',
                'receipt_route' => 'renewnursing-license.generateReceipt'

            ],

            [
                'service_id' => 2026,
                'service_name' => 'Owners Name change/ Partner name  of nursing homes under the Maharashtra Nursing Homes Registration Act, 1949',
                'model' => '\App\Models\MedicalHealth\ChangeNursingLicense',
                'add_route' => 'changenursing-license.create',
                'edit_route' => 'changenursing-license.edit',
                'certificate_route' => 'changenursing-license.show',
                'receipt_route' => 'changenursing-license.generateReceipt'


            ],
            [
                'service_id' => 2027,
                'service_name' => 'License for the Lodging House',
                'model' => '\App\Models\Trade\LicenseLoadgingHouse',
                'add_route' => 'trade-license-loading.create',
                'edit_route' => 'trade-license-loading.edit',
                'certificate_route' => 'trade-license-loading.show',
                'receipt_route' => 'trade-license-loading.generateReceipt'

            ],
            [
                'service_id' => 2028,
                'service_name' => 'Renewal License for the Lodging House',
                'model' => '\App\Models\Trade\RenewLicenseLoadging',
                'add_route' => 'trade-renew-license-loading.create',
                'edit_route' => 'trade-renew-license-loading.edit',
                'certificate_route' => 'trade-renew-license-loading.show',
                'receipt_route' => 'trade-renew-license-loading.generateReceipt'

            ],
            [
                'service_id' => 2029,
                'service_name' => 'Issuance of license for Marriage Hall/Meeting Hall etc.',
                'model' => '\App\Models\Trade\IssuanceLicenseMarriage',
                'add_route' => 'trade-issuance-license-marriage.create',
                'edit_route' => 'trade-issuance-license-marriage.edit',
                'certificate_route' => 'trade-issuance-license-marriage.show',
                'receipt_route' => 'trade-issuance-license-marriage.generateReceipt'

            ],
            [
                'service_id' => 2030,
                'service_name' => 'Renewal of License for Marriage Hall/Meeting Hall etc.',
                'model' => '\App\Models\Trade\RenewMarriageLicense',
                'add_route' => 'trade-renew-license-marriage.create',
                'edit_route' => 'trade-renew-license-marriage.edit',
                'certificate_route' => 'trade-renew-license-marriage.show',
                'receipt_route' => 'trade-renew-license-marriage.generateReceipt'

            ],
            [
                'service_id' => 2031,
                'service_name' => 'Issuance of hawker registration certificate',
                'model' => '\App\Models\Nulm\HawkerRegister',
                'add_route' => 'hawker-register.create',
                'edit_route' => 'hawker-register.edit',
                'certificate_route' => 'hawker-register.show',
                'receipt_route' => 'hawker-register.generateReceipt'
            ],
            [
                'service_id' => 2032,
                'service_name' => 'Granting permission for laying underground telecommunication ducts',
                'model' => '\App\Models\Pwd\GrantingTelecom',
                'add_route' => 'grant-telecome.create',
                'edit_route' => 'grant-telecome.edit',
                'certificate_route' => 'grant-telecome.show',
                'receipt_route' => 'grant-telecome.generateReceipt',
                'demandnote'  => 'grant-telecome.generatedemandnote'
            ],
            
            [
                'service_id' => 2033,
                'service_name' => 'Urban Areas Tree Protection',
                'model' => '\App\Models\TreeAuth\TreeProtection',
                'add_route' => 'tree-protection.create',
                'edit_route' => 'tree-protection.edit',
                'certificate_route' => 'tree-protection.show',
                'receipt_route' => 'tree-protection.generateReceipt',
            ],
            [
                'service_id' => 2034,
                'service_name' => 'Movie Shooting License (Movie Shooting License) New License and Renewaln',
                'model' => '\App\Models\Trade\MovieShooting',
                'add_route' => 'movie-shooting.create',
                'edit_route' => 'movie-shooting.edit',
                'certificate_route' => 'movie-shooting.show',
                'receipt_route' => 'movie-shooting.generateReceipt'

            ],
            // [
            //     'service_id' => 2035,
            //     'service_name' => 'To issue building permission',
            //     'model' => '\App\Models\TownPlanning\BuildingPermission',
            //     'add_route' => 'town-building-permission.create',
            //     'edit_route' => 'town-building-permission.edit',
            //     'certificate_route' => 'town-building-permission.show',
            // ],
            [
                'service_id' => 2037,
                'service_name' => 'Change The Business Holder/Partner',
                'model' => '\App\Models\Trade\ChangeHolderPartner',
                'add_route' => 'trade-change-holder-partner.create',
                'edit_route' => 'trade-change-holder-partner.edit',
                'certificate_route' => 'trade-change-holder-partner.show',
                'receipt_route' => 'trade-change-holder-partner.generateReceipt'

            ],
            [
                'service_id' => 2038,
                'service_name' => 'To issue drainage / sewer connection',
                'model' => '\App\Models\MallaNisaranDepartment\Drainage',
                'add_route' => 'drainage.create',
                'edit_route' => 'drainage.edit',
                'certificate_route' => 'drainage.show',
                'receipt_route' => 'drainage.generateReceipt'

            ],
            [
                'service_id' => 4890,
                'service_name' => 'Division Of Property Into Subdivisions',
                'model' => '\App\Models\Trade\PropertyDivisionIntoSubDivision',
                'add_route' => 'property-division.create',
                'edit_route' => 'property-division.edit',
                'certificate_route' => 'property-division.show',
                'receipt_route' => 'property-division.generateReceipt'

            ],
            [
                'service_id' => 5890,
                'service_name' => 'Issuance Of Transfer Of Property Certificate By Succession',
                'model' => '\App\Models\PropertyTax\TransferSelfPropertyCertificate',
                'add_route' => 'transfer-selfproperty.create',
                'edit_route' => 'transfer-selfproperty.edit',
                'certificate_route' => 'transfer-selfproperty.show',
                'receipt_route' => 'transfer-selfproperty.generateReceipt',

            ],
            [
                'service_id' => 2042,
                'service_name' => 'PWD Electrical for Strom Drain Water',
                'model' => '\App\Models\PwdElectrical\StromWaterDrain',
                'add_route' => 'strom-water-drains.create',
                'edit_route' => 'strom-water-drains.edit',
                'certificate_route' => 'strom-water-drains.show',
                'receipt_route' => 'strom-water-drains.generateReceipt'
            ],
            [
                'service_id' => 3042,
                'service_name' => 'Path Road Citizenship Certificate (NOC)',
                'model' => '\App\Models\PwdElectrical\PathRoadCitizenshipCertificate',
                'add_route' => 'path-road-citizen.create',
                'edit_route' => 'path-road-citizen.edit',
                'certificate_route' => 'path-road-citizen.show',
                'receipt_route' => 'path-road-citizen.generateReceipt'

            ],
            [
                'service_id' => 4042,
                'service_name' => 'Granting permission and design approval for private organizations to install slabs on gutters and footpaths',
                'model' => '\App\Models\PwdElectrical\PrivateInfrastructureWorkPermission',
                'add_route' => 'private-infrastructure.create',
                'edit_route' => 'private-infrastructure.edit',
                'certificate_route' => 'private-infrastructure.show',
                'receipt_route' => 'private-infrastructure.generateReceipt',

            ],
            // [
            //     'service_id' => 5042,
            //     'service_name' => 'Vikas Kamacha Gopniy Dakhala',
            //     'model' => '\App\Models\PwdElectrical\VikasKamachGopniyDakhla',
            //     'add_route' => 'vikas-kamacha-gopniy-dakhla.create',
            //     'edit_route' => 'vikas-kamacha-gopniy-dakhla.edit',
            //     'certificate_route' => 'vikas-kamacha-gopniy-dakhla.show',
            //     'receipt_route' => 'vikas-kamacha-gopniy-dakhla.generateReceipt',
            // ],

            // [
            //     'service_id' => 8042,
            //     'service_name' => 'Vibhag Thakbaki Naslyache Pramanpatra',
            //     'model' => '\App\Models\PwdElectrical\VibhagakadeThakbakiNaslyachePramanpatra',
            //     'add_route' => 'vibhag-thakbaki.create',
            //     'edit_route' => 'vibhag-thakbaki.edit',
            //     'certificate_route' => 'vibhag-thakbaki.show',
            //     'receipt_route' => 'vibhag-thakbaki.generateReceipt',

            // ],

            [
                'service_id' => 9041,
                'service_name' => 'Sarvajanik Jagetun Janara Rastyacha Dakhla',
                'model' => '\App\Models\PwdElectrical\SarvajanikJagetunJanaraRastyachaDakhla',
                'add_route' => 'sarvajnik-jagetun.create',
                'edit_route' => 'sarvajnik-jagetun.edit',
                'certificate_route' => 'sarvajnik-jagetun.show',
                'receipt_route' => 'sarvajnik-jagetun.generateReceipt',

            ],


            [
                'service_id' => 6042,
                'service_name' => 'Completion Certificate for Development Work ',
                'model' => '\App\Models\PwdElectrical\CompletionCertificateDevelopment',
                'add_route' => 'completition-certificate.create',
                'edit_route' => 'completition-certificate.edit',
                'certificate_route' => 'completition-certificate.show',
                'receipt_route' => 'completition-certificate.generateReceipt',

            ],

            [
                'service_id' => 7042,
                'service_name' => 'Development Works Quantity-wise Statement ',
                'model' => '\App\Models\PwdElectrical\DevelopmentWorksQuantity',
                'add_route' => 'development-work-quantity.create',
                'edit_route' => 'development-work-quantity.edit',
                'certificate_route' => 'development-work-quantity.show',
                'receipt_route' => 'development-work-quantity.generateReceipt',

            ],
            [
                'service_id' => 9042,
                'service_name' => 'Electric Meter Transfer Certificate (NOC) ',
                'model' => '\App\Models\EstateVibhag\ElectricMeterNameTransfer',
                'add_route' => 'electric-meter-name.create',
                'edit_route' => 'electric-meter-name.edit',
                'certificate_route' => 'electric-meter-name.show',
                'receipt_route' => 'electric-meter-name.generateReceipt',

            ],
             [
                'service_id' => 8990,
                'service_name' => 'No Objection Certificate for water supply system  ',
                'model' => '\App\Models\DrinageWater\FailureWater',
                'add_route' => 'failure-watersupply.create',
                'edit_route' => 'failure-watersupply.edit',
                'certificate_route' => 'failure-watersupply.show',
                'receipt_route' => 'failure-watersupply.generateReceipt'

            ],
            [
                'service_id' => 8920,
                'service_name' => 'SEWERAGE LINE CONNECTION NOC',
                'model' => '\App\Models\DrinageWater\SewerageNoc',
                'add_route' => 'sewerage-noc.create',
                'edit_route' => 'sewerage-noc.edit',
                'certificate_route' => 'sewerage-noc.show',
                'receipt_route' => 'sewerage-noc.generateReceipt'

            ],
            [
                'service_id' => 8921,
                'service_name' => 'Regarding obtaining the birth certificate',
                'model' => '\App\Models\InsuranceOfBirthCertificate\InsuranceBirth',
                'add_route' => 'insurance.create',
                'edit_route' => 'insurance.edit',
                'certificate_route' => 'insurance.show',
                'receipt_route' => 'insurance.generateReceipt',

            ],
            [
                'service_id' => 8922,
                'service_name' => 'Water connection repair permission',
                'model' => '\App\Models\DrinageWater\WaterRepair',
                'add_route' => 'waterrepair.create',
                'edit_route' => 'waterrepair.edit',
                'certificate_route' => 'waterrepair.show',
                 'receipt_route' => 'waterrepair.generateReceipt',

            ],
             [
                'service_id' => 8923,
                'service_name' => 'Water connection transfer permission',
                'model' => '\App\Models\DrinageWater\WaterTransfer',
                'add_route' => 'watertransferpermission.create',
                'edit_route' => 'watertransferpermission.edit',
                'certificate_route' => 'watertransferpermission.show',
                'receipt_route' => 'watertransferpermission.generateReceipt',

            ],
              [
                'service_id' => 8924,
                'service_name' => 'Certificate of potable water/पाणी पिण्यायोग्य असलेचे प्रमाणपत्र',
                'model' => '\App\Models\DrinageWater\PortableWater',
                'add_route' => 'portablewater.create',
                'edit_route' => 'portablewater.edit',
                'certificate_route' => 'portablewater.show',
                'receipt_route' => 'portablewater.generateReceipt',

            ],
            [
                'service_id' => 8925,
                'service_name' => 'Issues of Death Certificate/मृत्यू दाखला मिळविणेबाबत',
                'model' => '\App\Models\InsuranceOfBirthCertificate\InsuranceDeath',
                'add_route' => 'death-insurance.create',
                'edit_route' => 'death-insurance.edit',
                'certificate_route' => 'death-insurance.show',
                'receipt_route' => 'death-insurance.generateReceipt',

            ],
            [
                'service_id' => 8926,
                'service_name' => 'Sewerage Property Connection/सीवरेज प्रॉपर्टी कनेक्शन',
                'model' => '\App\Models\DrinageWater\SewerageProperty',
                'add_route' => 'sewerage-peoperty.create',
                'edit_route' => 'sewerage-peoperty.edit',
                'certificate_route' => 'sewerage-peoperty.show',
                'receipt_route' => 'sewerage-peoperty.generateReceipt',

            ],
            [
                'service_id' => 8927,
                'service_name' => 'Certificate of No Water Dues/पाणी देय नसल्याचे प्रमाणपत्र',
                'model' => '\App\Models\DrinageWater\WaterDues',
                'add_route' => 'water-dues.create',
                'edit_route' => 'water-dues.edit',
                'certificate_route' => 'water-dues.show',
                'receipt_route' => 'water-dues.generateReceipt',

            ],
            [
                'service_id' => 8928,
                'service_name'=>'Renewal of License/परवाना नूतनीकरण',
                'model'=>'\App\Models\Trade\TradeLicense',
                'add_route'=>'trade-license.create',
                'edit_route'=>'trade-license.edit',
                'certificate_route'=>'trade-license.show',
                'receipt_route' => 'trade-license.generateReceipt',

            ],
            [
                'service_id'=>8929,
                'service_name'=>'Civil Local Self-Government Nomination Certificate for State Food License/राज्य खाद्य परवान्या करिता नागरी स्थानिक स्वराज्य संस्थांचा नाहरकत दाखला',
                'model'=>'\App\Models\MedicalHealth\CivilLocalSelfGovernmentNomination',
                'add_route'=>'civil-local-self-government.create',
                'edit_route'=>'civil-local-self-government.edit',
                'certificate_route'=>'civil-local-self-government.show',
                'receipt_route' => 'civil-local-self-government.generateReceipt',

            ],
              [
                'service_id'=>8930,
                'service_name'=>' Solar Power / Solar Water Heating No Objection Certificate/सोलार पॉवर / सोलार वॉटर हिटिंग ना हरकत दाखला',
                'model'=>'\App\Models\EstateVibhag\SolarPower',
                'add_route'=>'solarpower-heater.create',
                'edit_route'=>'solarpower-heater.edit',
                'certificate_route'=>'solarpower-heater.show',
                'receipt_route' => 'solarpower-heater.generateReceipt',

              ],
                [
                'service_id'=>3996,
                'service_name'=>'Change of license holder/partner name/परवाना धारक/ भागीदाराचे नाव बदलणे',
                'model'=>'\App\Models\Trade\TradeHolderName',
                'add_route'=>'trade-change-of-holder.create',
                'edit_route'=>'trade-change-of-holder.edit',
                'certificate_route'=>'trade-change-of-holder.show',
                'receipt_route' => 'trade-change-of-holder.generateReceipt',

                ],
                [
                'service_id'=>8932,
                'service_name'=>'Maintaining gutter covers/गटारावरील झाकणे सुस्थितीत ठेवणे',
                'model'=>'\App\Models\MedicalHealth\GutterCover',
                'add_route'=>'guttercover-maintain.create',
                'edit_route'=>'guttercover-maintain.edit',
                'certificate_route'=>'guttercover-maintain.show',
                'receipt_route' => 'guttercover-maintain.generateReceipt',

                ],
            [
                'service_id'=>8933,
                'service_name'=>'Filling potholes on roads/रस्त्यांवरील खड्डे बुजविणे',
                'model'=>'\App\Models\MedicalHealth\Potholes',
                'add_route'=>'potholes-road.create',
                'edit_route'=>'potholes-road.edit',
                'certificate_route'=>'potholes-road.show',
                'receipt_route' => 'potholes-road.generateReceipt',
            ],

            [
                'service_id'=>9396,
                'service_name'=>'Keeping the city clean/शहरात स्वच्छता ठेवणे',
                'model'=>'\App\Models\CityClean',
                'add_route'=>'city-clean.create',
                'edit_route'=>'city-clean.edit',
                'certificate_route'=>'city-clean.show',
                'receipt_route' => 'city-clean.generateReceipt',
            ],

               [
                'service_id'=>9397,
                'service_name'=>'Certificate of good condition of air, access roads, and buildings/खेळती हवा, पोहोच रस्ते, व इमारती सुस्थितीत प्रमाणपत्र',
                'model'=>'\App\Models\PwdElectrical\WindBlow',
                'add_route'=>'wind-blow.create',
                'edit_route'=>'wind-blow.edit',
                'certificate_route'=>'wind-blow.show',
                'receipt_route' => 'wind-blow.generateReceipt',
            ]



        ];


        foreach ($services as $service) {
            ServiceName::updateOrCreate(
                [
                    'service_id' => $service['service_id']
                ],
                [
                    'service_id' => $service['service_id'],
                    'service_name' => $service['service_name'],
                    'model' => $service['model'],
                    'add_route' => $service['add_route'],
                    'edit_route' => $service['edit_route'],
                    'certificate_route' => $service['certificate_route'] ?? null,
                    'receipt_route' => $service['receipt_route'] ?? null,
                    'demandnote' => $service['demandnote'] ?? null,
                    'payment' => $service['payment'] ?? null,
                     'reject_certificate' => $service['reject_certificate'] ?? null,
                ]
            );
        }
    }
}
