<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Service;
use Log;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [

              [
                "id" => 1,
                "service_id" => null,
                "name" => "जन्म मृत्यु",
                "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],

            [
                "id" => 2,
                "service_id" => null,
                "name" => "नगररचना विभाग",
                "image" => "service/7eVpBS7RVfTqlmbuNHw77MXqUn6wkrWH2wbzwYZP.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 10:52:11",
                "updated_at" => "2024-06-10 10:52:11"
            ],
            [
                "id" => 3,
                "service_id" => null,
                "name" => "विवाह नोंदणी",
                "image" => "service/AfnTCgdUcscvA2QB4RTi6akZo18UpZKWf0GPJIkn.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 10:53:10",
                "updated_at" => "2024-06-10 10:53:10"
            ],
            [
                "id" => 4,
                "service_id" => null,
                "name" => "मालमत्ता कर विभाग",
                "image" => "service/8apAFL7HgTwAWfvScbYuChPeKS2vbgYTajhjh2tR.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 5,
                "service_id" => null,
                //"name" => "पाणी विभाग",
                "name" => "पाणी पुरवठा व मलनिःसारण विभाग",
                "image" => "service/LZ1aYUYeixkG7JStMf51o1AZz3l4qTPGMZwJtsnG.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 10:55:02",
                "updated_at" => "2024-06-10 10:55:02"
            ],
            [
                "id" => 6,
                "service_id" => null,
                "name" => "व्यापार परवाना",
                "image" => "service/ATrZemjqMVDgfjWV7bsu7ZIUZRzG9hVSwp5N7Z5E.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:56:18",
                "updated_at" => "2024-06-10 10:56:18"
            ],
            [
                "id" => 7,
                "service_id" => null,
                "name" => "अग्निशमन विभाग",
                "image" => "service/Mkkbnt9scijS9slt3nGARcS1nGAjaKS5vryKpixd.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 10:57:07",
                "updated_at" => "2024-06-10 10:57:07"
            ],
            [
                "id" => 8,
                "service_id" => null,
                "name" => "आरोग्य विभाग",
                "image" => "service/lycB5h8Do9CEWyzmiDFrjhLhrBQO9LK28gXWe0Zv.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:57:51",
                "updated_at" => "2024-06-10 10:57:51"
            ],
            [
                "id" => 9,
                "service_id" => 4,
                "name" => "मालमत्ता कर उतारा देणे",
                "image" => null,
                'table_name' => "property_tax_issuance_of_property_tax_assessments",
                "is_parent" => 1,
                "route_name" => "issuance-of-property-tax.create",
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            [
                "id" => 10,
                "service_id" => 4,
                "name" => "थकबाकी नसल्याचा दाखला देणे",
                "image" => null,
                'table_name' => "no_due_certificates",
                "is_parent" => 1,
                "route_name" => "no-dues.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 11:02:14",
                "updated_at" => "2024-06-10 11:02:14"
            ],
            [
                "id" => 11,
                "service_id" => 4,
                "name" => "अ) दस्तऐवजाच्या आधारे मालमत्ता हस्तांतरण नोंद प्रमाणपत्र देणे",
                "image" => null,
                'table_name' => "transfer-selfproperty",
                "is_parent" => 1,
                "route_name" => "transfer-selfproperty.create",
                "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:02:49",
                "updated_at" => "2024-06-10 11:02:49"
            ],
            [
                "id" => 12,
                "service_id" => 4,
                "name" => "नव्याने कर आकारणी",
                "image" => null,
                'table_name' => "newtaxations",
                "is_parent" => 1,
                "route_name" => "new-taxation.create",
                "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 11:04:01",
                "updated_at" => "2024-06-10 11:04:01"
            ],
            [
                "id" => 13,
                "service_id" => 4,
                "name" => "पुनः कर आकारणी",
                "image" => null,
                'table_name' => "re_taxations",
                "is_parent" => 1,
                "route_name" => "retaxation.create",
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:04:39",
                "updated_at" => "2024-06-10 11:04:39"
            ],
            [
                "id" => 14,
                "service_id" => 4,
                "name" => "कराची मागणीपत्र तयार करणे",
                "image" => null,
                'table_name' => "tax_demands",
                "servicetype" => "RTS",
                "is_parent" => 1,
                "route_name" => "tax-demand.create",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 11:12:21",
                "updated_at" => "2024-06-10 11:12:21"
            ],
            [
                "id" => 15,
                "service_id" => 4,
                "name" => "करमाफी मिळणे",
                "image" => null,
                'table_name' => "tax_exemptions",
                "servicetype" => "RTS",
                "is_parent" => 1,
                "route_name" => "tax-exemption.create",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:13:10",
                "updated_at" => "2024-06-10 11:13:10"
            ],
            [
                "id" => 16,
                "service_id" => 4,
                "name" => "रहिवास नसलेल्या मालमत्तांना करात सुट मिळणे",
                "image" => null,
                'table_name' => "tax_exemption_non_resident_properties",
                "is_parent" => 1,
                "route_name" => "tax-exemption-non-resident.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 11:14:16",
                "updated_at" => "2024-06-10 11:14:16"
            ],
            [
                "id" => 17,
                "service_id" => 4,
                "name" => "स्वयंमुल्यांकन",
                "image" => null,
                'table_name' => "self_assessments",
                "is_parent" => 1,
                "route_name" => "self-assessment.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:14:45",
                "updated_at" => "2024-06-10 11:14:45"
            ],
            [
                "id" => 18,
                "service_id" => 4,
                "name" => "आक्षेप नोंदविणे",
                "image" => null,
                'table_name' => "registration_of_objections",
                "is_parent" => 1,
                "route_name" => "registration-of-objection.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:22:43",
                "updated_at" => "2024-06-10 11:22:43"
            ],
            [
                "id" => 19,
                "service_id" => 5,
                "name" => "नवीन नळजोडणी देणे",
                "image" => null,
                'table_name' => "waternewconnections",
                "is_parent" => 1,
                "route_name" => "water-new-connection.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:34:06",
                "updated_at" => "2024-06-10 11:34:06"
            ],
            [
                "id" => 20,
                "service_id" => 5,
                "name" => "अनधिकृत नळ जोडणी तक्रार",
                "image" => null,
                'table_name' => "illegalwaterconnections",
                "is_parent" => 1,
                "route_name" => "water-illegal-connection.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 11:34:44",
                "updated_at" => "2024-06-10 11:34:44"
            ],
            [
                "id" => 21,
                "service_id" => 5,
                "name" => "मालकी हक्कात बदल करणे",
                "image" => null,
                'table_name' => "water_change_ownerships",
                "is_parent" => 1,
                "route_name" => "water-change-ownership.create",
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:35:12",
                "updated_at" => "2024-06-10 11:35:12"
            ],
            [
                "id" => 22,
                "service_id" => 5,
                "name" => "नळजोडणी आकारामध्ये बदल करणे",
                "image" => null,
                'table_name' => "water_change_connection_sizes",
                "is_parent" => 1,
                "route_name" => 'water-connection-size-change.create',
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 23,
                "service_id" => 5,
                "name" => "पुनः जोडणी करणे",
                "image" => null,
                'table_name' => "water_reconnections",
                "is_parent" => 1,
                "route_name" => "water-reconnection.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 24,
                "service_id" => 5,
                "name" => "तात्पुरते/ कायमस्वरूपी नळजोडणी खंडीत करणे",
                "image" => null,
                'table_name' => "water_disconnect_supplies",
                "is_parent" => 1,
                "route_name" => "water-disconnect-supply.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 11:35:12",
                "updated_at" => "2024-06-10 11:35:12"
            ],
            [
                "id" => 25,
                "service_id" => 5,
                "name" => "वापरामध्ये बदल करणे",
                "image" => null,
                'table_name' => "water_change_in_uses",
                "is_parent" => 1,
                "route_name" => 'water-change-connection-usage.create',
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 26,
                "service_id" => 5,
                "name" => "पाणी देयक तयार करणे",
                "image" => null,
                'table_name' => "water_tax_bills",
                "is_parent" => 1,
                "route_name" => "water-Tax-bill.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 27,
                "service_id" => 5,
                "name" => "थकबाकी नसल्याचा दाखला",
                "image" => null,
                'table_name' => "water_no_dues",
                "is_parent" => 1,
                "route_name" => "water-no-dues.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => null,
                "updated_at" => null
            ],

            [
                "id" => 28,
                "service_id" => 5,
                "name" => "नादुरुस्त मिटर तक्रार करणे",
                "image" => null,
                'table_name' => "water_defective_meters",
                "is_parent" => 1,
                "route_name" => "water-defective-meter.create",
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => null,
                "updated_at" => null
            ],

            [
                "id" => 29,
                "service_id" => 5,
                "name" => "पाण्याची दबाव क्षमता तक्रार",
                "image" => null,
                'table_name' => "water_pressure_complaints",
                "is_parent" => 1,
                "route_name" => "water-pressure-complaint.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 30,
                "service_id" => 5,
                "name" => "पाण्याची गुणवत्ता तक्रार",
                "image" => null,
                'table_name' => "water_quality_complaints",
                "is_parent" => 1,
                "route_name" => "water-quality-complaint.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => null,
                "updated_at" => null
            ],

            [
                "id" => 31,
                "service_id" => 5,
                "name" => "प्लंबर परवाना",
                "image" => null,
                'table_name' => "water_plumber_licenses",
                "is_parent" => 1,
                "route_name" => "trade-plumber-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:46:42",
                "updated_at" => "2024-06-10 11:46:42"
            ],
            [
                "id" => 32,
                "service_id" => 5,
                "name" => "प्लंबर परवाना नूतनीकरण करणे",
                "image" => null,
                'table_name' => "water_renewal_of_plumbers",
                "is_parent" => 1,
                "route_name" => "renewal-plumber-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 33,
                "service_id" => 6,
                "name" => "नवीन परवाना मिळणे",
                "image" => null,
                'table_name' => "trade_new_license_permissions",
                "is_parent" => 1,
                "route_name" => "trade-new-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 34,
                "service_id" => 6,
                "name" => "कालबाह्य परवानासाठी नुतनीकरण सूचना",
                "image" => null,
                'table_name' => "trade_renewal_license_permissions",
                "is_parent" => 1,
                "route_name" => "trade-renewal-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 35,
                "service_id" => 6,
                "name" => "व्यवसाय परवाना स्वयं-नुतनीकरण ",
                "image" => null,
                'table_name' => "trade_auto_renewal_license_permissions",
                "is_parent" => 1,
                "route_name" => "trade-autorenewal-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 36,
                "service_id" => 6,
                "name" => "परवाना हस्तांतरण",
                "image" => null,
                'table_name' => "trade_license_transfers",
                "is_parent" => 1,
                "route_name" => "trade-license-transfer.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 37,
                "service_id" => 6,
                "name" => "परवाना दुय्यम प्रत",
                "image" => null,
                'table_name' => "trade_per_licenses",
                "is_parent" => 1,
                "route_name" => "trade-per-license.create",
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => null,
                "updated_at" => null
            ],

             [
                "id" => 109,
                "service_id" => null,
                "name" => "सार्वजनिक उत्सव साजरा करणे करिता मंडप परवाना",
                "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],



            








            [
                "id" => 38,
                "service_id" => 109,
                "name" => "सार्वजनिक उत्सव साजरा करणे करिता मंडप ना हरकत प्रमाणपत्र",
                "image" => null,
                'table_name' => "trade_noc_for_mandaps",
                "is_parent" => 1,
                "route_name" => "trade-noc-mandap.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 39,
                "service_id" => 6,
                "name" => "व्यवसायाचे नाव बदलणे",
                "image" => null,
                'table_name' => "trade_change_license_names",
                "is_parent" => 1,
                "route_name" => "trade-change-license-name.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 40,
                "service_id" => 6,
                "name" => "व्यवसाय बदलणे",
                "image" => null,
                'table_name' => "trade_change_license_types",
                "is_parent" => 1,
                "route_name" => "trade-change-license-type.create",
                "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 41,
                "service_id" => 6,
                "name" => "भागीदाराच्या संख्येत बदल (वाढ/ कमी)",
                "image" => null,
                'table_name' => "trade_change_owner_counts",
                "is_parent" => 1,
                "route_name" => "trade-change-owner-count.create",
                 "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => null,
                "updated_at" => null
            ],

            [
                "id" => 42,
                "service_id" => 6,
                "name" => "परवाना रद्द करणे",
                "image" => null,
                'table_name' => "trade_license_cancellations",
                "is_parent" => 1,
                "route_name" => "trade-license-cancellation.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => null,
                "updated_at" => null
            ],
            [
                "id" => 43,
                "service_id" => null,
                "name" => "पीडब्ल्यूडी/इलेक्ट्रिकल",
                "image" => "service/lycB5h8Do9CEWyzmiDFrjhLhrBQO9LK28gXWe0Zv.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "NONRTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 10:57:51",
                "updated_at" => "2024-06-10 10:57:51"
            ],
            [
                "id" => 44,
                "service_id" => null,
                "name" => "इस्टेट विभाग",
                "image" => "service/lycB5h8Do9CEWyzmiDFrjhLhrBQO9LK28gXWe0Zv.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "NONRTS",
                "background_color" => "#ff3333",
                "created_at" => "2024-06-10 10:57:51",
                "updated_at" => "2024-06-10 10:57:51"
            ],
            [
                "id" => 45,
                "service_id" => 7,
                "name" => "अग्निशमन ना हरकत दाखला देणेे",
                "image" => null,
                'table_name' => "fire_no_objections",
                "is_parent" => 1,
                "route_name" => "fire-no-objection.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 12:00:09",
                "updated_at" => "2024-06-10 12:00:09"
            ],
            [
                "id" => 46,
                "service_id" => 7,
                "name" => "अग्निशमन अंतिम ना हरकत दाखला देणे",
                "image" => null,
                'table_name' => "fire_final_no_objections",
                "is_parent" => 1,
                "route_name" => "fire-final-no-objection.create",
                 "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 12:00:33",
                "updated_at" => "2024-06-10 12:00:33"
            ],
           [
                "id" => 47,
                "service_id" => 5,
                "name" => "पाणी अनुपलब्धता प्रमाणपत्र देणे",
                "image" => null,
                'table_name' => null,
                "is_parent" => 1,
                "route_name" => "water-unavailability-supply.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 12:02:48",
                "updated_at" => "2024-06-10 12:02:48"
            ],
            [
                "id" => 48,
                "service_id" => 2,
                "name" => "भाग नकाशा देणे",
                "image" => null,
                'table_name' => null,
                "is_parent" => 1,
                "route_name" => "town-planing-bhag-nakasha.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 12:01:41",
                "updated_at" => "2024-06-10 12:01:41"
            ],
             [
                "id" => 77,
                "service_id" => null,
                "name" => "PWD",
                "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],
            [
                "id" => 49,
                "service_id" => 77,
                "name" => "रस्ता खोदाई परवाना देणे",
                "image" => null,
                'table_name' => "construction_road_cuttings",
                "is_parent" => 1,
                "route_name" => "construction-road-cutting.create",
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 12:02:30",
                "updated_at" => "2024-06-10 12:02:30"
            ],
            [
                "id" => 50,
                "service_id" => 5,
                //"name" => "जलनि:सारण जोडणी देणे",
                "name" => "मलनि:सारण जोडणी देणे",
                "image" => null,
                'table_name' => "construction_drainage_connections",
                "is_parent" => 1,
                "route_name" => "construction-drainage-connection.create",
                 "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 12:02:48",
                "updated_at" => "2024-06-10 12:02:48"
            ],
            [
                "id" => 51,
                "service_id" => 3,
                "name" => "विवाह नोंदणी प्रमाणपत्र देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "marriage-registration.create",
                 "servicetype" => "RTS",
                'table_name' => "marriage_reg_forms",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
             [
                "id" => 52,
                "service_id" => 77,
                "name" => "रस्त्यांवरील खड्डे बुजविणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "potholes-road.create",
                 "servicetype" => "RTS",
                'table_name' => "potholes_road",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
             [
                "id" => 53,
                "service_id" => 4,
                "name" => "मालमत्ता पाडणे व पुनः बांधणी कर आकारणी",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "demolishingproperty.create",
                 "servicetype" => "RTS",
                'table_name' => "demolishing_properties",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 54,
                "service_id" => 6,
                "name" => "परवाना धारक/ भागीदाराचे नाव बदलणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "trade-change-of-holder.create",
                 "servicetype" => "RTS",
                'table_name' => "trade_change_holder_name",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 55,
                "service_id" => 6,
                "name" => "नवीन सिनेमा चित्रीकरण परवाना (Movie Shooting License) व  परवाना नुतणीकरण",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "movie-shooting.create",
                 "servicetype" => "RTS",
                'table_name' => "movie_shooting",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            // [
            //     "id" => 56,
            //     "service_id" => 8,
            //     "name" => "राज्य खाद्य परवान्या करिता नागरी स्थानिक स्वराज्य संस्थांचा नाहरकत दाखला",
            //     "image" => null,
            //     "is_parent" => 1,
            //     "route_name" => null,
            //      "servicetype" => "RTS",
            //     'table_name' => null,
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 10:54:22",
            //     "updated_at" => "2024-06-10 10:58:36"
            // ],
            [
                "id" => 104,
                "service_id" => null,
                "name" => "घनकचरा विभाग",
                "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],
            [
                "id" => 57,
                "service_id" => 104,
                "name" => "शहरात स्वच्छता ठेवणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "city-clean.create",
                "servicetype" => "RTS",
                'table_name' => null,
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

           [
                "id" => 58,
                "service_id" => 77,
                "name" => "गटारावरील झाकणे सुस्थितीत ठेवणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "guttercover-maintain.create",
                "servicetype" => "RTS",
                'table_name' => "guttercover",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 59,
                "service_id" => 6,
                "name" => "मंगल कार्यालय / सभागृह वगैरे परवाना देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "trade-issuance-license-marriage.create",
                 "servicetype" => "RTS",
                'table_name' => "issuance_license_marriages",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

            [
                "id" => 60,
                "service_id" => null,
                "name" => "वृक्ष विभाग",
                "image" => "service/lycB5h8Do9CEWyzmiDFrjhLhrBQO9LK28gXWe0Zv.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "RTS",
                "background_color" => "#2a85c7",
                "created_at" => "2024-06-10 10:57:51",
                "updated_at" => "2024-06-10 10:57:51"
            ],
            [
                "id" => 61,
                "service_id" => null,
                //"name" => "ड्रेनेज आणि सांडपाणी",
                "name" => "पाणी पुरवठा व मलनिःसारण विभाग",
                "image" => "service/lycB5h8Do9CEWyzmiDFrjhLhrBQO9LK28gXWe0Zv.png",
                "is_parent" => 0,
                "route_name" => null,
                'table_name' => null,
                "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:57:51",
                "updated_at" => "2024-06-10 10:57:51"
            ],




            [
                "id" => 62,
                "service_id" => 6,
                "name" => "मंगल कार्यालय / सभागृह वगैरे परवान्याचे नुतनीकरण करणे.",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "trade-renew-license-marriage.create",
                 "servicetype" => "RTS",
                'table_name' => "renew_marriage_licenses",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

            [
                "id" => 63,
                "service_id" => 6,
                "name" => "फेरीवाले नोंदणी प्रमाणपत्र देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "hawker-register.create",
                 "servicetype" => "RTS",
                'table_name' => "hawker_registers",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 64,
                "service_id" => 61,
                "name" => "पाणी पिण्यायोग्य असलेचे प्रमाणपत्र ",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "portablewater.create",
                "servicetype" => "NONRTS",
                'table_name' => "portable_water",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],
            [
                "id" => 65,
                "service_id" => 77,
                "name" => "भूमिगत दूरसंचार वाहिनी (ऑप्टीकल फायबर केबल) टाकण्याकरीता परवानगी देणे.",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "grant-telecome.create",
                 "servicetype" => "RTS",
                'table_name' => "granting_telecoms",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            // [
            //     "id" => 66,
            //     "service_id" => 2,
            //     "name" => "मोबाइल टॉवर परवाना",
            //     "image" => null,
            //     "is_parent" => 1,
            //     "route_name" => "mobile-tower.create",
            //     "servicetype" => "RTS",
            //     'table_name' => "mobile_towers",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 10:54:22",
            //     "updated_at" => "2024-06-10 10:58:36"
            // ],
            [
                "id" => 67,
                "service_id" => 60,
                "name" => "महाराष्ट्र (नागरी क्षेत्रे) वृक्ष संरक्षण आणि संवर्धन अधिनियम, १९७५ मधील कलम ८ मधील तरतुदींनुसार वृक्षतोड परवानगी देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "tree-protection.create",
                 "servicetype" => "RTS",
                'table_name' => "tree_protections",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            // [
            //     "id" => 68,
            //     "service_id" => 2,
            //     "name" => "बांधकाम परवाना देणे",
            //     "image" => null,
            //     "is_parent" => 1,
            //     "route_name" => "town-building-permission.create",
            //     "servicetype" => "RTS",
            //     'table_name' => "building_permissions",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 10:54:22",
            //     "updated_at" => "2024-06-10 10:58:36"
            // ],
            // [
            //     "id" => 69,
            //     "service_id" => 2,
            //     "name" => "भोगवटा प्रमाणपत्र देणे",
            //     "image" => null,
            //     "is_parent" => 1,
            //     "route_name" => "town-occupancy-certificate.create",
            //     "servicetype" => "RTS",
            //     'table_name' => "occupancy_certificates",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 10:54:22",
            //     "updated_at" => "2024-06-10 10:58:36"
            // ],
            [
                "id" => 70,
                "service_id" => 61,
                "name" => "SEWERAGE PROPERTY CONNECTION",
                "image" => null,
                "is_parent" => 1,
                "route_name" => 'sewerage-peoperty.create',
                "servicetype" => "RTS",
                'table_name' => 'sewerage_properties',
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

            [
                "id" => 71,
                "service_id" => 8,
                "name" => "महाराष्ट्र शुश्रृषा-गृह नोंदणी अधिनियम, १९४९ अंतर्गत शुश्रृषा-गृह परवाना देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "grantnursing-license.create",
                 "servicetype" => "RTS",
                'table_name' => "grant_nursing_licenses",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 72,
                "service_id" => 8,
                "name" => "महाराष्ट्र शुश्रृषा-गृह नोंदणी अधिनियम, १९४९ अंतर्गत शुश्रृषा-गृह परवान्याचे नुतनीकरण करणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "renewnursing-license.create",
                 "servicetype" => "RTS",
                'table_name' => "renewal_nursing_licenses",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 73,
                "service_id" => 8,
                "name" => "महाराष्ट्र शुश्रृषा-गृह नोंदणी अधिनियम, १९४९ अंतर्गत परवान्यावर परवाना धारक/भागीदाराचे नाव बदलणे .",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "changenursing-license.create",
                 "servicetype" => "RTS",
                'table_name' => "change_nursing_licenses",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 74,
                "service_id" => 4,
                "name" => "उप विभागामध्ये मालमत्ता विभाजन",
                "image" => null,
                'table_name' => "property_division_into_sub_divisions",
                "is_parent" => 1,
                "route_name" => "property-division.create",
                 "servicetype" => "RTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            // [
            //     "id" => 75,
            //     "service_id" => 4,
            //     "name" => "मालमत्ता हस्तांतरण नोंद प्रमाणपत्र देणे (वारसा हक्कानुसार)",
            //     "image" => null,
            //     'table_name' => null,
            //     "is_parent" => 1,
            //     "route_name" => null,
            //      "servicetype" => "RTS",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

            [
                "id" => 76,
                "service_id" => 43,
                "name" => "स्टॉर्म वॉटर ड्रेन नाहरकत:दाखला परवानगी (NOC)",
                "image" => null,
                'table_name' => "strom_water_drains",
                "is_parent" => 1,
                "route_name" => "strom-water-drains.create",
                 "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],



            [
                "id" => 78,
                "service_id" => 43,
                "name" => "गटारे, फूटपाथ यावर खाजगी संस्थामार्फत स्लॅब टाकण्यासाठी परवानगी व डिझाईन देणे / खाजगी संस्थांना स्वखर्चाने गटारे, नाले, रस्ते बांधण्यास परवानगी देणे",
                "image" => null,
                'table_name' => "private_infrastructure_work_permissions",
                "is_parent" => 1,
                "route_name" => "private-infrastructure.create",
                 "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            // [
            //     "id" => 79,
            //     "service_id" => 43,
            //     "name" => "विकास कामाचा गोपनिय दाखला",
            //     "image" => null,
            //     'table_name' => "vikas_kamach_gopniy_dakhlas",
            //     "is_parent" => 1,
            //     "route_name" => "vikas-kamacha-gopniy-dakhla.create",
            //      "servicetype" => "NONRTS",
            //     "background_color" => "#b73107",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],
             [
                "id" => 80,
                "service_id" => 43,
                "name" => "विकास कामाबाबत पूर्णत्वाचा दाखला",
                "image" => null,
                'table_name' => "completion_certificate_developments",
                "is_parent" => 1,
                "route_name" => "completition-certificate.create",
                 "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],


            [
                "id" => 81,
                "service_id" => 43,
                "name" => "विभागाकडे थकबाकी नसल्याचे प्रमाणपत्र",
                "image" => null,
                'table_name' => "vibhagakade_thakbaki_naslyache_pramanpatras",
                "is_parent" => 1,
                "route_name" => "vibhag-thakbaki.create",
                 "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            [
                "id" => 82,
                "service_id" => 43,
                "name" => " विकास कामांचा(quantityWise) प्रमाणानुसार तपशील",
                "image" => null,
                'table_name' => "development_works_quantities",
                "is_parent" => 1,
                "route_name" => "development-work-quantity.create",
                "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],


            [
                "id" => 83,
                "service_id" => 43,
                "name" => "सार्वजनिक जागेतून जाणारा रस्त्याचा दाखला",
                "image" => null,
                'table_name' => "sarvajanik_jagetun_janara_rastyacha_dakhlas",
                "is_parent" => 1,
                "route_name" => "sarvajnik-jagetun.create",
                "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            [
                "id" => 84,
                "service_id" => 1,
                "name" => "Issuance of Birth Certificate/जन्म प्रमाणपत्र देणे",
                "image" => null,
                'table_name' => 'insurance_births',
                "is_parent" => 1,
                "route_name" => 'insurance.create',
                "servicetype" => "RTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            [
                "id" => 85,
                "service_id" => 1,
                "name" => "Issuance of Death Certificate/मृत्यू प्रमाणपत्र देणे",
                "image" => null,
                'table_name' => 'insurance_deaths',
                "is_parent" => 1,
                "route_name" => 'death-insurance.create',
                "servicetype" => "RTS",
                "background_color" => "#037ca2",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            //  [
            //     "id" => 86,
            //     "service_id" => 6,
            //     "name" => "व्यापार / व्यवसाय / साठा करणेसाठी ना हरकत प्रमाणपत्र",
            //     "image" => null,
            //     'table_name' => null,
            //     "is_parent" => 1,
            //     "route_name" => null,
            //     "servicetype" => "RTS",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],
            
            //   [
            //     "id" => 87,
            //     "service_id" => 2,
            //     "name" => "जोते प्रमाणपत्र/Jote certificate",
            //     "image" => null,
            //     'table_name' => null,
            //     "is_parent" => 1,
            //     "route_name" => null,
            //     "servicetype" => "RTS",
            //     "background_color" => "#b73107",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

            [
                "id" => 88,
                "service_id" => 44,
                "name" => "विद्युत मीटर स्थलांतर प्रमाणपत्र (एनओसी)",
                "image" => null,
                'table_name' => "electric_meter_name_transfers",
                "is_parent" => 1,
                "route_name" => "electric-meter-name.create",
                "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],

             [
                "id" => 89,
                "service_id" => 61,
                "name" => "पाणी पुरवठा व्यवस्थेचा ना हरकत दाखला",
                "image" => null,
                'table_name' => "failure_water_supply",
                "is_parent" => 1,
                "route_name" => "failure-watersupply.create",
                "servicetype" => "NONRTS",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
            // [
            //     "id" => 90,
            //     "service_id" => 61,
            //     "name" => "मलनिःसारण (Sewerage line) वाहिनी जोडणी ना हरकत दाखला",
            //     "image" => null,
            //     'table_name' => "sewerage_noc",
            //     "is_parent" => 1,
            //     "route_name" => "sewerage-noc.create",
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#b73107",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

            // [
            //     "id" => 91,
            //     "service_id" => 61,
            //     "name" => "जलजोडणी दुरुस्ती परवानगी",
            //     "image" => null,
            //     'table_name' => "water_repair_connection",
            //     "is_parent" => 1,
            //     "route_name" => "waterrepair.create",
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

            //  [
            //     "id" => 92,
            //     "service_id" => 61,
            //     "name" => "जलजोडणी स्थानांतरीत परवानगी",
            //     "image" => null,
            //     'table_name' => "watertransfer_permission",
            //     "is_parent" => 1,
            //     "route_name" => "watertransferpermission.create",
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#037ca2",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],
            
            //  [
            //     "id" => 93,
            //     "service_id" => 61,
            //     "name" => "Rain Water Harvesting प्रकल्प नाहरकत दाखला",
            //     "image" => null,
            //     'table_name' => null,
            //     "is_parent" => 1,
            //     "route_name" => null,
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#b73107",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

            [
                "id" => 94,
                "service_id" => 43,
                "name" => "खेळती हवा, पोहोच रस्ते, व इमारती सुस्थितीत प्रमाणपत्र",
                "image" => null,
                'table_name' => "windblow",
                "is_parent" => 1,
                "route_name" => "wind-blow.create",
                "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
              [
                "id" => 95,
                "service_id" => 43,
                "name" => "सोलार पॉवर / सोलार वॉटर हिटिंग ना हरकत दाखला",
                "image" => null,
                'table_name' => "solarpower",
                "is_parent" => 1,
                "route_name" => "solarpower-heater.create",
                "servicetype" => "NONRTS",
                "background_color" => "#b73107",
                "created_at" => "2024-06-10 11:01:43",
                "updated_at" => "2024-06-10 11:01:43"
            ],
              [
                "id" => 96,
                "service_id" => 8,
                "name" => "खाद्य नोंदणी प्रमाणपत्राकरिता नागरी स्थानिक स्वराज्य संस्थानचा आरोग्यविषयक नाहरकत दाखला",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "civil-local-self-government.create",
                "servicetype" => "RTS",
                'table_name' => "civil_local_self_government_nominations",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            

            // [
            //     "id" => 97,
            //     "service_id" => 61,
            //     "name" => "Certificate of No Water Dues",
            //     "image" => null,
            //     'table_name' => "water_dues",
            //     "is_parent" => 1,
            //     "route_name" => "water-dues.create",
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#00aea4",
            //     "created_at" => "2024-06-10 11:01:43",
            //     "updated_at" => "2024-06-10 11:01:43"
            // ],

             [
                "id" => 98,
                "service_id" => 6,
                "name" => "परवान्याचे नुतनीकरण",
                "image" => null,
                "is_parent" => 1,
                "route_name" => 'trade-license.create',
                "servicetype" => "RTS",
                'table_name' => 'trade_licenses',
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
               ],
                [
                "id" => 99,
                "service_id" => 2,
                "name" => "झोन दाखला देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "town-planing-zone-certificate.create",
                "servicetype" => "RTS",
                'table_name' => "city_structure_zone_certificates",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

             [
                "id" => 103,
                "service_id" => null,
                "name" => "जाहिरात विभाग",
                "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
                "is_parent" => 0,
                "route_name" => null,
                "table_name" => null,
                "servicetype" => "RTS",
                "background_color" => "#5d92baff",
                "created_at" => "2024-06-10 10:51:08",
                "updated_at" => "2024-06-10 10:51:08"
            ],
               [
                "id" => 100,
                "service_id" => 103,
                "name" => "नवीन जाहिरात परवाना /आकाशचिन्ह परवाना (Signange License) व परवाना नुतणीकरण",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "hoarding-permission.create",
                "servicetype" => "RTS",
                'table_name' => "hoarding_permissions",
                "background_color" => "#2cb1aaff",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],

            [
                "id" => 101,
                "service_id" => 6,
                "name" => "लॉजिंग हाऊस परवाना देणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "trade-license-loading.create",
                "servicetype" => "RTS",
                'table_name' => "license_loadging_houses",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],
            [
                "id" => 102,
                "service_id" => 6,
                "name" => "लॉजिंग हाऊस परवान्याचे नुतनीकरण करणे",
                "image" => null,
                "is_parent" => 1,
                "route_name" => "trade-renew-license-loading.create",
                "servicetype" => "RTS",
                'table_name' => "renew_license_loadgings",
                "background_color" => "#00aea4",
                "created_at" => "2024-06-10 10:54:22",
                "updated_at" => "2024-06-10 10:58:36"
            ],






            //  [
            //     "id" => 110,
            //     "service_id" => null,
            //     "name" => "सफाई मागणी ",
            //     "image" => "service/ZolWqfXTl0JjOWRUNdfaVuw1iF5Ktu1EghTWS4n0.png",
            //     "is_parent" => 0,
            //     "route_name" => null,
            //     "table_name" => null,
            //     "servicetype" => "NONRTS",
            //     "background_color" => "#b73107",
            //     "created_at" => "2024-06-10 10:51:08",
            //     "updated_at" => "2024-06-10 10:51:08"
            // ],



            // [
            //     "id" => 106,
            //     "service_id" => 110,
            //     "name" => "मागणी सफाई प्रमाणपत्र",
            //     "image" => null,
            //    'table_name' => "demand_safai",
            //     "is_parent" => 1,
            //     "route_name" => "demand-safai.create",
            //      "servicetype" => "NONRTS",
            //     "background_color" => "#2a85c7",
            //     "created_at" => null,
            //     "updated_at" => null
            // ],







        ];

        foreach ($services as $service) {
            Service::updateOrCreate([
                'id' => $service['id']
            ], [
                'id' => $service['id'],
                'service_id' => $service['service_id'],
                'name' => $service['name'],
                'image' => $service['image'],
                'is_parent' => $service['is_parent'],
                'table_name' => $service['table_name'],
                'route_name' => $service['route_name'],
                'servicetype' => $service['servicetype'],
                'background_color' => $service['background_color'],
                'created_at' => $service['created_at'],
                'updated_at' => $service['updated_at']
            ]);
        }
    }
}
