<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TreeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     */
    public function run(): void
    {
        DB::table('treestypes')->insert([
            [
                'type' => 'वृक्ष तोडणे',
                'description' => '१) १ झाड तोडण्याच्या बदल्यात अंदाजित केलेल्या वया प्रमाणे भारतीय प्रजातीची ६ फुट उंचीच्या रोपांची लागवड करण्यात यावी,
                                  २) मात्र वृक्षरोपणासाठी जागा नसेल तर वृक्ष प्राधिकरणाकडे वृक्ष रोपे लावणे य वृक्षरोपांचे जतन करण्या
                                  प्रित्यर्थ नापरतावा वृक्षनिधी रक्कम रु.१.५००/- प्रति वृक्ष प्रमाणे जमा करुन घेणे.'
            ],
            [
                'type' => 'वृक्ष पुनःरोपण',
                'description' => '१) १ झाड पुर्नः रोपण करण्याच्या बदल्यात ०१ नग भारतीय प्रजातीचे ६ फुट उंचीच्या रोपांची लागवड करण्यात यावी.
                                  २) नव्याने १ वृक्ष पुर्नः रोपण करण्याप्रित्यार्थ रु.५,०००/- प्रति वृक्ष प्रमाणे सुरक्षा अनामत रक्कम जमा करणे. पुर्नरोपणाच्या दिनांकापासून तीन वर्षापर्यंत नित्यनियमाने दर सहा महिन्यानी वृक्ष स्थिती (Tree Status) अहवाल महानगरपालिकेस सादर करणे. तदनंतर वृक्ष सुस्थितीत असल्याची खातरजमा केल्यानंतर सुरक्षा अनामत रक्कम परत करण्यात येईल,
                                  ३) १ वृक्ष पुर्नः रोपण करण्यासाठी सोयायटी / अर्जदाराकडे पुर्न: रोपण करण्यासाठी जागा उपलब्ध नसरन्यास व महानगरपालिका जागा उपलब्ध करुन देत असल्यास रु.५,०००/- सुरक्षा अनामत ऐवजी रु.५,०००/-प्रति वृक्ष प्रमाणे वृक्षनिधी जमा करणे व महानगरपालिकेकडून झड पुनः रोपण करण्यात येईल.'
            ],
            [
                'type' => 'वृक्षाची छाटणी करणे',
                'description' => 'खाजगी जागेतील वृक्षाची छाटणी करणे व छाटणी उचलुन मनपा वाहनाद्वारे घोडबंदर प्रकल्प येथे टाकणेकामी प्रती वृक्ष प्रमाणे रु.१,०००/- वृक्ष निधी जमा करुन घेणे,'
            ],
             [
                'type' => 'वृक्षाची छाटणी (फांद्या) उचलणे',
                'description' => 'खाजगी जागेतील करण्यात आलेली छाटणी उचलणेकामी प्रती वृक्ष याप्रमाणे रु. ५००/- जमा करुन घेणे.'
            ],
             [
                'type' => 'धोकादायक झाडे मुळासहित काढणे',
                'description' => 'महानगरपालिकेची झाडे काढणेकामी परवानगी सोसायटीधारकांनी प्राप्त करुन घेतल्यानंतर मनपा कर्मचारी यांच्या मार्फत धोकादायक झाडे मुळासहित काढणेकामी नागरीक / को. ऑ.हौ.सो.लि. सोसायटी यांची विनंती असेल तर प्रती वृक्ष खालील प्रमाणे जमा करुन घेणे'
            ],
        ]);
    }
}



