<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UsageTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $usageTypes = [
            'Residential' => [
                'Single-family house',
                'Multi-family apartment',
                'Tenanted house',
                'Government quarters',
                'Slum dwelling',
                'Row house / chawl',
            ],
            'Commercial' => [
                'Retail shop',
                'Office space',
                'Shopping mall unit',
                'Restaurant / hotel',
                'Cinema hall',
                'Service center / workshop',
            ],
            'Industrial' => [
                'Light industry (small-scale manufacturing)',
                'Heavy industry (large manufacturing)',
                'Godown / storage',
                'Cold storage',
                'Processing plant',
            ],
            'Institutional' => [
                'Educational (school, college, training center)',
                'Health care (hospital, clinic, dispensary)',
                'Religious building (temple, mosque, church)',
                'Public utility (community hall, library)',
            ],
            'Mixed Use' => [
                'Shop + residence',
                'Office + residence',
                'Warehouse + retail',
            ],
            'Vacant Land' => [
                'Residential plot',
                'Commercial plot',
                'Industrial plot',
                'Agricultural land within city limits',
            ],
            'Special Category' => [
                'Exempted government property',
                'Heritage building',
                'Charitable trust property',
            ],
        ];

        foreach ($usageTypes as $typeName => $subTypes) {
            $usageTypeId = DB::table('usage_types')->insertGetId([
                'name' => $typeName,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            foreach ($subTypes as $subTypeName) {
                DB::table('sub_usage_types')->insert([
                    'usage_type_id' => $usageTypeId,
                    'name' => $subTypeName,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
