<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VrukshTypeSeeder extends Seeder
{
    public function run(): void
    {
        $type1 = "सोसायटी / घरांच्या परिसरातील झाडे तोडणे / पुर्नरोपण / छाटणी करणे.";
        $type2 = "विकासकामातील झाडे तोडणे/ पुर्नरोपण करणे.";

        DB::table('vrukshtypes')->insert([
            // ✅ वृक्ष तोडणे
            [
                'type' => $type1,
                'name' => 'वृक्ष तोडणे',
                'service_id' => '2033',
                'sub_name' => null,
                'rate' => null,
                'amount' => 300,
                'question1' => 'नवीन वृक्षारोपण करायचे आहे का?',
                'question2' => 'वृक्षारोपणासाठी जागा उपलब्ध आहे का?',
                'yes_amount' => 0,
                'no_amount' => 1500,
            ],

            // ✅ वृक्ष पुनःरोपण
            [
                'type' => $type1,
                'name' => 'वृक्ष पुनःरोपण',
                'service_id' => '2033',
                'sub_name' => null,
                'rate' => null,
                'amount' => 300,
                'question1' => 'नवीन वृक्ष पुनःरोपण करायचे आहे का?',
                'question2' => 'वृक्ष पुनःरोपणासाठी जागा उपलब्ध आहे का?',
                'yes_amount' => 5000,
                'no_amount' => 5000,
            ],

            // ✅ वृक्षाची छाटणी करणे
            [
                'type' => $type1,
                'name' => 'वृक्षाची छाटणी करणे',
                 'service_id' => '2033',
                'sub_name' => null,
                'rate' => 1000,
                'amount' => 300,
                'question1' => null,
                'question2' => null,
                'yes_amount' => null,
                'no_amount' => null,
            ],

            // ✅ वृक्षांची छाटणी (फांद्या) उचलणे
            [
                'type' => $type1,
                'name' => 'वृक्षांची छाटणी (फांद्या) उचलणे',
                 'service_id' => '2033',
                'sub_name' => null,
                'rate' => 500,
                'amount' => 300,
                'question1' => null,
                'question2' => null,
                'yes_amount' => null,
                'no_amount' => null,
            ],

            // ✅ धोकादायक झाडे मुळासहित काढणे (तीन प्रकार)
            [
                'type' => $type1,
                'name' => 'धोकादायक झाडे मुळासहित काढणे',
                 'service_id' => '2033',
                'sub_name' => 'उंची (Height) - २० फुटापर्यंत बुंध्याची जाडी (Girth) - १ फुटापर्यंत',
                'rate' => 2400,
                'amount' => 300,
                'question1' => null,
                'question2' => null,
                'yes_amount' => null,
                'no_amount' => null,
            ],
            [
                'type' => $type1,
                'name' => 'धोकादायक झाडे मुळासहित काढणे',
                 'service_id' => '2033',
                'sub_name' => 'उंची (Height) - २० ते ३५ फुटापर्यंत बुंध्याची जाडी (Girth) - १ ते २.५० फुट',
                'rate' => 5400,
                'amount' => 300,
                'question1' => null,
                'question2' => null,
                'yes_amount' => null,
                'no_amount' => null,
            ],
            [
                'type' => $type1,
                'name' => 'धोकादायक झाडे मुळासहित काढणे',
                 'service_id' => '2033',
                'sub_name' => 'उंची (Height) - ३५ ते ५० फुट किंवात्यापेक्षा जास्त बुंध्याची जाडी (Girth) - २.५० फुटापेक्षा जास्त',
                'rate' => 11200,
                'amount' => 300,
                'question1' => null,
                'question2' => null,
                'yes_amount' => null,
                'no_amount' => null,
            ],

            // ✅ Type 2
            [
                'type' => $type2,
                'name' => 'वृक्ष तोडणे',
                 'service_id' => '2033',
                'sub_name' => null,
                'rate' => null,
                'amount' => 300,
                'question1' => 'नवीन वृक्षारोपण करायचे आहे का?',
                'question2' => 'वृक्षारोपणासाठी जागा उपलब्ध आहे का?',
                'yes_amount' => 10000,
                'no_amount' => 25000,
            ],
            [
                'type' => $type2,
                'name' => 'वृक्ष पुनःरोपण',
                'service_id' => '2033',
                'sub_name' => null,
                'rate' => null,
                'amount' => 300,
                'question1' => 'नवीन वृक्ष पुनःरोपण करायचे आहे का?',
                'question2' => 'वृक्ष पुनःरोपणासाठी जागा उपलब्ध आहे का?',
                'yes_amount' => 10000,
                'no_amount' => 25000,
            ],
        ]);
    }
}
