<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class WaterPrabhagMainSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $prabhags = [
            'Uttan',
            'Miraroad',
            'Rai-Murdha',
            'Kankiya-Ghodbandar-Chene',
            'Kashi',
            'Bhayander East',
            'Dongri',
            'Miragaon',
            'Bhayander West',
        ];

        foreach ($prabhags as $name) {
            DB::table('water_prabhags')->updateOrInsert(
                ['name' => $name],
                [
                    'status' => 1,
                    'updated_at' => now(),
                    'created_at' => now(),
                ]
            );
        }
    }
}
