<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class WaterPrabhagSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $prabhagward = [
            ['id' => 1, 'prabhag_id' => '1', 'prabhag_name' => 'Uttan', 'ward_name' => 'A'],
            ['id' => 2, 'prabhag_id' => '1', 'prabhag_name' => 'Uttan', 'ward_name' => 'B'],
            ['id' => 3, 'prabhag_id' => '2', 'prabhag_name' => 'Miraroad', 'ward_name' => 'O'],
            ['id' => 4, 'prabhag_id' => '2', 'prabhag_name' => 'Miraroad', 'ward_name' => 'N'],
            ['id' => 5, 'prabhag_id' => '2', 'prabhag_name' => 'Miraroad', 'ward_name' => 'Z'],
            ['id' => 6, 'prabhag_id' => '3', 'prabhag_name' => 'Rai-Murdha', 'ward_name' => 'E'],
            ['id' => 7, 'prabhag_id' => '4', 'prabhag_name' => 'Kankiya-Ghodbandar-Chene', 'ward_name' => 'T'],
            ['id' => 8, 'prabhag_id' => '4', 'prabhag_name' => 'Kankiya-Ghodbandar-Chene', 'ward_name' => 'F'],
            ['id' => 9, 'prabhag_id' => '4', 'prabhag_name' => 'Kankiya-Ghodbandar-Chene', 'ward_name' => 'U'],
            ['id' => 10, 'prabhag_id' => '4', 'prabhag_name' => 'Kankiya-Ghodbandar-Chene', 'ward_name' => 'V'],
            ['id' => 11, 'prabhag_id' => '4', 'prabhag_name' => 'Kankiya-Ghodbandar-Chene', 'ward_name' => 'F-1'],
            ['id' => 12, 'prabhag_id' => '5', 'prabhag_name' => 'Kashi', 'ward_name' => 'S'],
            ['id' => 13, 'prabhag_id' => '6', 'prabhag_name' => 'Bhayander East', 'ward_name' => 'I'],
            ['id' => 14, 'prabhag_id' => '6', 'prabhag_name' => 'Bhayander East', 'ward_name' => 'J'],
            ['id' => 15, 'prabhag_id' => '6', 'prabhag_name' => 'Bhayander East', 'ward_name' => 'M'],
            ['id' => 16, 'prabhag_id' => '6', 'prabhag_name' => 'Bhayander East', 'ward_name' => 'J-1'],
            ['id' => 17, 'prabhag_id' => '6', 'prabhag_name' => 'Bhayander East', 'ward_name' => 'K'],
            ['id' => 18, 'prabhag_id' => '7', 'prabhag_name' => 'Dongri', 'ward_name' => 'C'],
            ['id' => 19, 'prabhag_id' => '7', 'prabhag_name' => 'Dongri', 'ward_name' => 'D'],
            ['id' => 20, 'prabhag_id' => '7', 'prabhag_name' => 'Dongri', 'ward_name' => 'X'],
            ['id' => 21, 'prabhag_id' => '8', 'prabhag_name' => 'Miragaon', 'ward_name' => 'Q'],
            ['id' => 22, 'prabhag_id' => '8', 'prabhag_name' => 'Miragaon', 'ward_name' => 'P'],
            ['id' => 23, 'prabhag_id' => '8', 'prabhag_name' => 'Miragaon', 'ward_name' => 'R'],
            ['id' => 24, 'prabhag_id' => '9', 'prabhag_name' => 'Bhayander West', 'ward_name' => 'G'],
            ['id' => 25, 'prabhag_id' => '9', 'prabhag_name' => 'Bhayander West', 'ward_name' => 'H'],
        ];

        foreach ($prabhagward as $multifactors) {
            DB::table('water_prabhag_wards')->updateOrInsert(
                ['id' => $multifactors['id']],
                [
                    'prabhag_id' => $multifactors['prabhag_id'],
                    'prabhag_name' => $multifactors['prabhag_name'],
                    'ward_name' => $multifactors['ward_name'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
