<?php

namespace Database\Seeders;

use Illuminate\Support\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class WaterRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $waterRates = [
            // change in ownership
            ['id' => 1, 'service_id' => '23', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '3000'],
            ['id' => 2, 'service_id' => '23', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '5000'],
            //
            ['id' => 3, 'service_id' => '16', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '3570'],
            ['id' => 4, 'service_id' => '16', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '3570'],
            ['id' => 5, 'service_id' => '15', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '3000'],
            ['id' => 6, 'service_id' => '15', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '3000'],
            ['id' => 7, 'service_id' => '17', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '5000'],
            ['id' => 8, 'service_id' => '17', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '5000'],
            ['id' => 9, 'service_id' => '21', 'type' => 'अनिवासी व्यवसाय', 'sub_type' => 'व्यवसाय 1', 'rate' => '78070'],
            ['id' => 10, 'service_id' => '21', 'type' => 'अनिवासी व्यवसाय', 'sub_type' => 'व्यवसाय 2', 'rate' => '46870'],
          
            // New Water Connection
            ['id' => 11, 'service_id' => '21', 'type' => 'निवासी', 'sub_type' => 'इमारत', 'rate' => '52220'],
            ['id' => 12, 'service_id' => '21', 'type' => 'निवासी', 'sub_type' => 'गावठाण स्वतंत्र घर', 'rate' => '6520'],
            ['id' => 13, 'service_id' => '21', 'type' => 'निवासी', 'sub_type' => 'गट कनेक्शन', 'rate' => '7520'],
            ['id' => 14, 'service_id' => '21', 'type' => 'निवासी', 'sub_type' => 'रो हाउस / बंगला', 'rate' => '39520'],

            //duristi parvangi//
            //panyachi dabav skamata 1 inch//
             ['id' => 15, 'service_id' => '26', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '3570', 'panyacha_type'=>'दुरुस्ती परवानगी(Domestic - 1inch)'],
              ['id' => 16, 'service_id' => '26', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '5570','panyacha_type'=>'दुरुस्ती परवानगी(Commercial - 1inch)'],
                                                                                                                            

              //panyachi dabav skamata 1/2 inch//
              ['id' => 17, 'service_id' => '26', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '2070','panyacha_type'=>'दुरुस्ती परवानगी(Domestic - 1/2inch)'],
              ['id' => 18, 'service_id' => '26', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '3070','panyacha_type'=>'दुरुस्ती परवानगी(Commercial - 1/2inch)'],


            //stanantaran parvangi//
            //panyachi dabav skamata 1 inch//
             ['id' => 19, 'service_id' => '26', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '4540','panyacha_type'=>'स्थानांतरण परवानगी(Domestic - 1inch)'],
              ['id' => 20, 'service_id' => '26', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '7140','panyacha_type'=>'स्थानांतरण परवानगी(Commercial - 1inch)'],

              
              ['id' => 21, 'service_id' => '26', 'type' => 'Domestic', 'sub_type' => '', 'rate' => '3340','panyacha_type'=>'स्थानांतरण परवानगी(Domestic - 1/2inch)'],
              ['id' => 22, 'service_id' => '26', 'type' => 'Commercial', 'sub_type' => '', 'rate' => '4940','panyacha_type'=>'स्थानांतरण परवानगी(Commercial - 1/2inch)'],


               ['id' => 23, 'service_id' => '8922', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '4000','panyacha_type'=>'2'],
               ['id' => 24, 'service_id' => '8922', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '5000','panyacha_type'=>'2'],

               ['id' => 25, 'service_id' => '8922', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '3500','panyacha_type'=>'1.5'],
               ['id' => 26, 'service_id' => '8922', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '5000','panyacha_type'=>'1.5'],

               ['id' => 27, 'service_id' => '8922', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '3000','panyacha_type'=>'1'],
               ['id' => 28, 'service_id' => '8922', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '5000','panyacha_type'=>'1'],

               ['id' => 29, 'service_id' => '8922', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '2000','panyacha_type'=>'0.75'],
               ['id' => 30, 'service_id' => '8922', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '3000','panyacha_type'=>'0.75'],

               ['id' => 31, 'service_id' => '8922', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '1500','panyacha_type'=>'0.5'],
               ['id' => 32, 'service_id' => '8922', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '2500','panyacha_type'=>'0.5'],


               
               ['id' => 33, 'service_id' => '8923', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '4500','panyacha_type'=>'2'],
               ['id' => 34, 'service_id' => '8923', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '8500','panyacha_type'=>'2'],

                 ['id' => 35, 'service_id' => '8923', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '3500','panyacha_type'=>'1.5'],
               ['id' => 36, 'service_id' => '8923', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '6500','panyacha_type'=>'1.5'],

                  ['id' => 37, 'service_id' => '8923', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '3000','panyacha_type'=>'1'],
               ['id' => 38, 'service_id' => '8923', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '5500','panyacha_type'=>'1'],

               ['id' => 39, 'service_id' => '8923', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '2500','panyacha_type'=>'0.75'],
               ['id' => 40, 'service_id' => '8923', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '4500','panyacha_type'=>'0.75'],

                ['id' => 41, 'service_id' => '8923', 'type' => 'निवासी', 'sub_type' => '', 'rate' => '2000','panyacha_type'=>'0.5'],
               ['id' => 42, 'service_id' => '8923', 'type' => 'अनिवासी', 'sub_type' => '', 'rate' => '3500','panyacha_type'=>'0.5'],




        
        
            ];

        foreach ($waterRates as $waterRate) {
            DB::table('water_payments')->updateOrInsert(
                ['id' => $waterRate['id']],
                [
                    'service_id' => $waterRate['service_id'],
                    'type' => $waterRate['type'],
                    'sub_type' => $waterRate['sub_type'],
                    'rate' => $waterRate['rate'],
                    'panyacha_type' => $waterRate['panyacha_type'] ?? null, 
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]
            );
        }
    }
}
