<x-admin.layout>
    <x-slot name="title">No Objection Certificate for water supply system / पाणी पुरवठा व्यवस्थेचा ना हरकत
        दाखला</x-slot>
    <x-slot name="heading">No Objection Certificate for water supply system / पाणी पुरवठा व्यवस्थेचा ना हरकत
        दाखला</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicantname">Applicant Name / अर्जदाराचे नाव<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="applicantname" name="applicantname" type="text"
                                    placeholder="Enter Applicant Name / अर्जदाराचे नाव">
                                <span class="text-danger is-invalid applicantname_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="mobileno">Mobile Number / मोबाईल नंबर<span
                                        class="text-danger">*</span></label>
                                <input class="form-control" id="mobileno" name="mobileno" type="text"
                                    placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}"
                                    title="Please enter exactly 10 digits" required inputmode="numeric"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);">
                                <span class="text-danger is-invalid mobileno_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email">Email ID / ईमेल आयडी<span
                                        class="text-danger"></span></label>
                                <input class="form-control" id="email" name="email" type="email"
                                    placeholder="Enter Email ID / ईमेल ">
                                <span class="text-danger is-invalid email_err"></span>
                            </div>
                        </div>

                        <div class="mb-3 row">
                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="propertyno">Property No/ मालमत्ता क्रमांक <span class="text-danger">*</span></label>
                                <input class="form-control" id="propertyno" name="propertyno" type="text" placeholder="Enter Owner Name / मालकाचे नाव">
                                <span class="text-danger is-invalid propertyno_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="waterconnectionno">Water Connection No / पाणी कनेक्शन क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="waterconnectionno" name="waterconnectionno" type="text" placeholder="Enter Address / पत्ता भरा">
                                <span class="text-danger is-invalid waterconnectionno_err"></span>
                            </div> --}}

                            <div class="mb-3 row">

                                {{-- <div class="col-md-4">
                                <label class="col-form-label" for="adhaarno">Aadhaar Number / आधार क्रमांक</label>
                                <input class="form-control" name="adhaarno" id="adhaarno" placeholder="Enter Aadhaar Number">
                                <span class="text-danger is-invalid adhaarno_err"></span>
                            </div> --}}

                                {{-- <div class="col-md-4">
                                    <label class="col-form-label" for="adhaarno">Aadhaar Number / आधार क्रमांक</label>
                                    <input class="form-control" name="adhaarno" id="adhaarno"
                                        placeholder="Enter Aadhaar Number / आधार क्रमांक" maxlength="12"
                                        oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                    <span class="text-danger is-invalid adhaarno_err"></span>
                                </div> --}}


                                <div class="col-md-4">
                                    <label class="col-form-label" for="applicantaddress">Applicant Full Address /
                                        अर्जदाराचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                    <input class="form-control" id="applicantaddress" name="applicantaddress"
                                        type="text"
                                        placeholder="Enter Applicant Full Address / अर्जदाराचा पूर्ण पत्ता">
                                    <span class="text-danger is-invalid applicantaddress_err"></span>
                                </div>

                                {{-- <div class="col-md-4">
                                <label class="col-form-label" for="survey_no">Survey No. /Hissa No. /C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी क्रमांक.<span class="text-danger">*</span></label>
                                <input class="form-control" id="survey_no" name="survey_no" type="text" placeholder="Enter Address / पत्ता भरा">
                                <span class="text-danger is-invalid survey_no_err"></span>
                            </div> --}}

                                <div class="col-md-4">
                                    <label class="col-form-label" for="survey_no">
                                        Survey No. / Hissa No. / C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी
                                        क्रमांक.
                                        <span class="text-danger">*</span>
                                    </label>
                                    <textarea class="form-control" id="survey_no" name="survey_no" rows="3"
                                        placeholder="Enter Survey No. / Hissa No. / C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी क्रमांक."></textarea>
                                    <span class="text-danger is-invalid survey_no_err"></span>
                                </div>


                                <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span
                                            class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" required>
                                        <option value="">Select Ward Area</option>
                                        @foreach ($wards as $ward)
                                            <option value="{{ $ward->id }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div>
                            </div>


                            <h5 class="text-primary">Documents / कागदपत्रे</h5>
                            <div class="mb-3 row">
                                {{-- <div class="col-md-3">
                                    <label class="col-form-label" for="application_doc">Application form downloaded in the prescribed format/ विहित नमुन्यात डाउनलोड केलेला अर्ज<span class="text-danger">*</span></label>
                                    <input class="form-control" id="application_doc" name="application_doc" type="file" >
                                    <span class="text-danger is-invalid application_doc_err"></span>
                                </div> --}}

                                <div class="col-md-3">
                                    <label class="col-form-label" for="site_photo">Site photo / साइट फोटो<span
                                            class="text-danger"></span></label>
                                    <input class="form-control" id="site_photo" name="site_photo" type="file">
                                    <span class="text-danger is-invalid site_photo_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="cc_oc">C.C / O.C / सी.सी / ओ.सी.<span
                                            class="text-danger"></span></label>
                                    <input class="form-control" id="cc_oc" name="cc_oc" type="file">
                                    <span class="text-danger is-invalid cc_oc_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="blue_print">Blue print / ब्लू प्रिंट<span
                                            class="text-danger"></span></label>
                                    <input class="form-control" id="blue_print" name="blue_print" type="file">
                                    <span class="text-danger is-invalid blue_print_err"></span>
                                </div>

                                <div class="col-md-3">
                                    <label class="col-form-label" for="other_doc">Other relevant Documents / इतर
                                        संबंधित कागदपत्रे<span class="text-danger"></span></label>
                                    <input class="form-control" id="other_doc" name="other_doc" type="file">
                                    <span class="text-danger is-invalid other_doc_err"></span>
                                </div>


                                {{-- <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="uploaded_applications">Upload Application In
                                        Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="uploaded_applications"
                                        name="uploaded_applications" type="file">
                                    <span class="text-danger is-invalid uploaded_applications_err"></span>
                                </div> --}}


                                 <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="application_doc">Upload Application In
                                        Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span
                                            class="text-danger">*</span></label>
                                    <input class="form-control" id="application_doc"
                                        name="application_doc" type="file">
                                    <span class="text-danger is-invalid application_doc_err"></span>
                                </div>


                                

                            </div>

                            {{-- Declaration --}}
                            <div class="mb-3 row">
                                <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="col-md-12">
                                    <div class="form-check d-flex align-items-start">
                                        <input type="checkbox" class="form-check-input mt-1" id="is_correct_info"
                                            name="is_correct_info" value="yes">
                                        <label class="form-check-label ms-2" for="is_correct_info">
                                            "All information provided above is correct and I shall be fully responsible
                                            for any discrepancy. <br>
                                            वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी
                                            पूर्णपणे जबाबदार असेन."
                                        </label>
                                    </div>
                                    <span class="text-danger is-invalid is_correct_info_err"></span>
                                </div>
                            </div>

                        </div>

                        {{-- Footer --}}
                        <div class="form-group" style="text-align: center;">
                            <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and
                                Print</button>
                        </div>
                        <div class="card-footer" id="card-footer" style="display:none;">
                            <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                            <button type="reset" class="btn btn-warning">Reset</button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>



{{-- <script>
document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
    let isValid = true;
    const addContainer = document.getElementById('addContainer');
    if (!addContainer) return;

    const messages = {
        applicantname: 'Applicant Name is required',
        mobileno_required: 'Mobile No is required',
        mobileno_invalid: 'Please enter 10 digit Mobile No',
        email_required: 'Email is required',
        email_invalid: 'Please enter valid Email format',
        applicantaddress: 'Applicant Address is required',
        survey_no: 'Survey No is required',
        ward_area: 'Ward is required',
        adhaarno_required: 'Aadhaar No is required',
        adhaarno_invalid: 'Please enter 12 digit Aadhaar No',
        is_correct_info: 'Please accept the declaration'
    };

    let firstErrorEl = null;

    // Validate fields
    const fields = ['applicantname', 'mobileno', 'email', 'applicantaddress', 'survey_no', 'ward_area', 'adhaarno', 'is_correct_info'];

    fields.forEach(fieldName => {
        const field = addContainer.querySelector(`[name="${fieldName}"]`);
        const errorSpan = addContainer.querySelector(`.${fieldName}_err`);
        if (!field) return;

        const value = field.value.trim();

        // Checkbox validation
        if (fieldName === 'is_correct_info') {
            if (!field.checked) {
                isValid = false;
                if (errorSpan) {
                    errorSpan.textContent = messages[fieldName];
                    errorSpan.style.color = 'red';
                }
                if (!firstErrorEl) firstErrorEl = field;
            } else if (errorSpan) {
                errorSpan.textContent = '';
            }
            return;
        }

        // Required check
        if (!value) {
            isValid = false;
            field.classList.add('is-invalid');
            if (errorSpan) {
                if(fieldName==='mobileno') errorSpan.textContent = messages['mobileno_required'];
                else if(fieldName==='email') errorSpan.textContent = messages['email_required'];
                else if(fieldName==='adhaarno') errorSpan.textContent = messages['adhaarno_required'];
                else errorSpan.textContent = messages[fieldName];
                errorSpan.style.color = 'red';
            }
            if (!firstErrorEl) firstErrorEl = field;
            return;
        } else {
            field.classList.remove('is-invalid');
            if (errorSpan) errorSpan.textContent = '';
        }

        // Mobile length validation
        if (fieldName === 'mobileno' && value.length !== 10) {
            isValid = false;
            field.classList.add('is-invalid');
            if (errorSpan) {
                errorSpan.textContent = messages['mobileno_invalid'];
                errorSpan.style.color = 'red';
            }
            if (!firstErrorEl) firstErrorEl = field;
        }

        // Aadhaar length validation
        if (fieldName === 'adhaarno' && value.length !== 12) {
            isValid = false;
            field.classList.add('is-invalid');
            if (errorSpan) {
                errorSpan.textContent = messages['adhaarno_invalid'];
                errorSpan.style.color = 'red';
            }
            if (!firstErrorEl) firstErrorEl = field;
        }

        // Email format validation
        if (fieldName === 'email') {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(value)) {
                isValid = false;
                field.classList.add('is-invalid');
                if (errorSpan) {
                    errorSpan.textContent = messages['email_invalid'];
                    errorSpan.style.color = 'red';
                }
                if (!firstErrorEl) firstErrorEl = field;
            }
        }
    });

    if (!isValid) {
        if (firstErrorEl) {
            firstErrorEl.scrollIntoView({ behavior: 'smooth', block: 'center' });
            firstErrorEl.focus();
        }
        return;
    }

    // --- Show upload and footer sections ---
    document.getElementById('upload_section').style.display = 'block';
    document.getElementById('card-footer').style.display = 'block';

    // --- Clone container for printing ---
    const printContainerClone = addContainer.cloneNode(true);

    // Remove uploaded file field from PDF
    const uploadField = printContainerClone.querySelector('#upload_section');
    if (uploadField) uploadField.remove();

    // --- PDF styling and generation ---
    printContainerClone.style.fontSize = '16px';
    printContainerClone.style.lineHeight = '1.4';
    printContainerClone.style.padding = '20px';
    printContainerClone.style.margin = '0 auto';
    printContainerClone.style.background = '#fff';
    printContainerClone.style.width = '210mm';
    printContainerClone.style.minHeight = '297mm';
    printContainerClone.style.boxSizing = 'border-box';

    Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
        el.style.fontSize = '16px';
        el.style.margin = '4px 0';
    });

    const printTitle = document.createElement('h2');
    printTitle.style.textAlign = 'center';
    printTitle.style.marginBottom = '18px';
    printTitle.style.fontSize = '18px';
    printTitle.textContent = 'Sewerage line';
    printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);

    Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
    Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
        card.style.background = 'white';
        card.style.boxShadow = 'none';
        card.style.border = '1px solid #ccc';
        card.style.marginBottom = '12px';
        card.style.padding = '12px';
    });
    Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
        div.classList.remove('d-none');
    });

    let printContainer = document.getElementById('printContainer');
    if (!printContainer) {
        printContainer = document.createElement('div');
        printContainer.id = 'printContainer';
        printContainer.style.position = 'fixed';
        printContainer.style.left = '-9999px';
        document.body.appendChild(printContainer);
    }

    printContainer.innerHTML = '';
    printContainer.appendChild(printContainerClone);

    html2canvas(printContainerClone, {
        scrollY: -window.scrollY,
        backgroundColor: '#fff',
        scale: 1,
        useCORS: true,
        allowTaint: true,
        logging: false
    }).then(canvas => {
        const imgData = canvas.toDataURL('image/jpeg', 0.6);
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF('p', 'mm', 'a4');
        const margin = 10;
        pdf.addImage(
            imgData,
            'JPEG',
            margin,
            margin,
            pdf.internal.pageSize.getWidth() - margin * 2,
            pdf.internal.pageSize.getHeight() - margin * 2
        );
        const pdfBlob = pdf.output('blob');
        if (pdfBlob.size > 2 * 1024 * 1024) {
            alert('Warning: PDF size is greater than 2 MB. Please reduce content or try again.');
        }
        pdf.save('Failure_Watersupply.pdf');
        document.getElementById('saveAndPrintBtn').style.display = 'none';
    });
});
</script> --}}


<script>
document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
    let isValid = true;
    const addContainer = document.getElementById('addContainer');
    if (!addContainer) return;

    const messages = {
        applicantname: 'Applicant Name is required',
        mobileno_required: 'Mobile No is required',
        mobileno_invalid: 'Please enter 10 digit Mobile No',
        //email_required: 'Email is required',
        //email_invalid: 'Please enter valid Email format',
        applicantaddress: 'Applicant Address is required',
        survey_no: 'Survey No is required',
        ward_area: 'Ward is required',
        adhaarno_required: 'Aadhaar No is required',
        adhaarno_invalid: 'Please enter 12 digit Aadhaar No',
        is_correct_info: 'Please accept the declaration'
    };

    let firstErrorEl = null;

    const fields = ['applicantname', 'mobileno', 'email', 'applicantaddress','survey_no','ward_area', 'adhaarno', 'is_correct_info'];
    fields.forEach(fieldName => {
        const field = addContainer.querySelector(`[name="${fieldName}"]`);
        const errorSpan = addContainer.querySelector(`.${fieldName}_err`);
        if (!field) return;
        const value = (field.value || '').trim();

        if (fieldName === 'is_correct_info') {
            if (!field.checked) {
                isValid = false;
                if (errorSpan) errorSpan.textContent = messages[fieldName];
                if (!firstErrorEl) firstErrorEl = field;
            } else if (errorSpan) errorSpan.textContent = '';
            return;
        }

        if (!value) {
            isValid = false;
            if (errorSpan) {
                if(fieldName==='mobileno') errorSpan.textContent = messages['mobileno_required'];
                else if(fieldName==='email') errorSpan.textContent = messages['email_required'];
                else if(fieldName==='adhaarno') errorSpan.textContent = messages['adhaarno_required'];
                else errorSpan.textContent = messages[fieldName];
            }
            if (!firstErrorEl) firstErrorEl = field;
            return;
        } else {
            if (errorSpan) errorSpan.textContent = '';
        }

        if (fieldName === 'mobileno' && value.length !== 10) {
            isValid = false;
            if (errorSpan) errorSpan.textContent = messages['mobileno_invalid'];
            if (!firstErrorEl) firstErrorEl = field;
        }

        if (fieldName === 'adhaarno' && value.length !== 12) {
            isValid = false;
            if (errorSpan) errorSpan.textContent = messages['adhaarno_invalid'];
            if (!firstErrorEl) firstErrorEl = field;
        }

        if (fieldName === 'email') {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(value)) {
                isValid = false;
                if (errorSpan) errorSpan.textContent = messages['email_invalid'];
                if (!firstErrorEl) firstErrorEl = field;
            }
        }
    });

    if (!isValid) {
        if (firstErrorEl) firstErrorEl.scrollIntoView({ behavior: 'smooth', block: 'center' });
        return;
    }

    document.getElementById('upload_section').style.display = 'block';
    document.getElementById('card-footer').style.display = 'block';

    const printContainerClone = addContainer.cloneNode(true);
    const uploadField = printContainerClone.querySelector('#upload_section');
    if (uploadField) uploadField.remove();

    // ✅ Ward Area dropdown → text
    const wardSelect = addContainer.querySelector('#ward_area');
    if (wardSelect) {
        const selectedText = wardSelect.options[wardSelect.selectedIndex]?.text || '';
        const wardDisplay = document.createElement('span');
        wardDisplay.textContent = selectedText;
        wardDisplay.style.display = 'inline-block';
        wardDisplay.style.border = '1px solid #ccc';
        wardDisplay.style.padding = '4px 8px';
        wardDisplay.style.borderRadius = '4px';
        wardDisplay.style.minWidth = '150px';
        wardDisplay.style.background = '#fff'; // ✅ white background for PDF

        const cloneSelect = printContainerClone.querySelector('#ward_area');
        if (cloneSelect && cloneSelect.parentNode) {
            cloneSelect.parentNode.replaceChild(wardDisplay, cloneSelect);
        }
    }

    // --- PDF layout ---
    printContainerClone.style.fontSize = '16px';
    printContainerClone.style.background = '#ffffff';  // ✅ pure white background
    printContainerClone.style.width = '210mm';
    printContainerClone.style.minHeight = '297mm';
    printContainerClone.style.margin = '0 auto';
    printContainerClone.style.padding = '20px';
    printContainerClone.style.color = '#000';

    const printTitle = document.createElement('h4');
    printTitle.style.textAlign = 'center';
    printTitle.style.textTransform = 'uppercase';
    printTitle.textContent = 'Failure Water Supply';
    printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);

    Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
    Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
        card.style.background = '#ffffff'; // ✅ make sure inner cards are also white
        card.style.boxShadow = 'none';
        card.style.border = '1px solid #ccc';
    });

    let printContainer = document.getElementById('printContainer');
    if (!printContainer) {
        printContainer = document.createElement('div');
        printContainer.id = 'printContainer';
        printContainer.style.position = 'fixed';
        printContainer.style.left = '-9999px';
        printContainer.style.background = '#ffffff'; // ✅ white bg for container too
        document.body.appendChild(printContainer);
    }
    printContainer.innerHTML = '';
    printContainer.appendChild(printContainerClone);

    html2canvas(printContainerClone, {
        scrollY: -window.scrollY,
        backgroundColor: '#ffffff', // ✅ force white background in capture
        scale: 1.2,
        useCORS: true,
        allowTaint: true
    }).then(canvas => {
        const imgData = canvas.toDataURL('image/jpeg', 1.0);
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF('p', 'mm', 'a4');
        const margin = 10;
        pdf.addImage(imgData, 'JPEG', margin, margin,
            pdf.internal.pageSize.getWidth() - margin * 2,
            pdf.internal.pageSize.getHeight() - margin * 2);
        pdf.save('Failure_Watersupply.pdf');
        document.getElementById('saveAndPrintBtn').style.display = 'none';
    });
});
</script>


























{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);


        // Clear previous errors
        $(".application_doc_err").text('');

        // Client-side check for file
        var fileInput = $("#application_doc")[0].files;
        if ($('#upload_section').is(':visible') && fileInput.length === 0) {
            $(".application_doc_err").text("Please upload the file");
            $("#addSubmit").prop('disabled', false);
            return false;
        }




        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('failure-watersupply.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);

                    // Display server-side error inside the same span
                    if (responseObject.responseJSON.errors.application_doc) {
                        $(".application_doc_err").text(responseObject.responseJSON.errors
                            .application_doc[0]);
                    }
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<script>
    document.getElementById('adhaarno').addEventListener('blur', function() {
        const val = this.value.trim();
        const errSpan = document.querySelector('.adhaarno_err');

        if (val.length === 0) {
            errSpan.textContent = 'Aadhaar number is required';
        } else if (val.length !== 12) {
            errSpan.textContent = 'Please enter exactly 12 digits';
        } else {
            errSpan.textContent = '';
        }
    });
</script>

<script>
document.getElementById("applicantname").addEventListener("input", function (e) {
    // सिर्फ letters (English + Marathi/Devanagari) और spaces allow करो
    this.value = this.value.replace(/[^A-Za-z\u0900-\u097F\s]/g, '');
});
</script>


<script>
document.getElementById("applicantaddress").addEventListener("input", function (e) {
    // ✅ English letters, Marathi/Devanagari letters, numbers और spaces allowed
    this.value = this.value.replace(/[^A-Za-z0-9\u0900-\u097F\s]/g, '');
});
</script>
