<x-admin.layout>
    <x-slot name="title">मलनिःसारण (Sewerage line) वाहिनी जोडणी ना हरकत दाखला</x-slot>
    <x-slot name="heading">मलनिःसारण (Sewerage line) वाहिनी जोडणी ना हरकत दाखला</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>

                    <div class="card-body">
                        <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                            {{-- 1. Applicant Details --}}
                            <h5 class="mb-3">Applicant Details / अर्जदाराची माहिती</h5>
                             <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Full Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" value="{{ $sewerageproperties->applicant_name }}"
                                pattern="^[A-Za-z\s]+$"
                                title="Only letters and spaces are allowed"  disabled readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                         <div class="col-md-4">
                               <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                               <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" value="{{ $sewerageproperties->mobile_no }}" maxlength="10" pattern="\d{10}"
                               title="Please enter exactly 10 digits" required inputmode="numeric"  oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);"  disabled readonly>
                               <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>




                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="property_no">Survey No. /Hissa No. /C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी क्रमांक.<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_no" name="property_no" type="text"  placeholder="Enter Survey No. /Hissa No. /C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी क्रमांक." value="{{ $sewerageproperties->property_no }}"  disabled readonly>
                                <span class="text-danger is-invalid property_no_err"></span>
                            </div> --}}

                            <div class="col-md-4">
    <label class="col-form-label" for="property_no">
        Survey No. / Hissa No. / C T No. / सर्व्हे क्रमांक / हिस्सा क्रमांक / सीटी क्रमांक.
        <span class="text-danger">*</span>
    </label>
    <textarea class="form-control" id="property_no" name="property_no" rows="3" placeholder="Enter Address / पत्ता भरा" disabled readonly>{{ $sewerageproperties->property_no }}</textarea>
    <span class="text-danger is-invalid property_no_err"></span>
</div>





                              <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Full Address/अर्जदाराचा पूर्ण पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा"  value="{{ $sewerageproperties->applicant_address }}"  disabled readonly>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                             {{-- <div class="col-md-4">
                                <label class="col-form-label" for="tax_no">Property Tax Number/मालमत्ता कर क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" name="tax_no" id="tax_no" placeholder="Enter Property Tax Number/मालमत्ता कर क्रमांक"  value="{{ $sewerageproperties->tax_no }}"  disabled readonly>
                                <span class="text-danger is-invalid tax_no_err"></span>
                            </div> --}}

                             <div class="col-md-4">
                                    <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                    <select class="form-select" name="ward_area" id="ward_area" disabled readonly>
                                        <option value="">Select Ward Area</option>
                                        @foreach($wards as $ward)
                                        <option {{ ($sewerageproperties->ward_area == $ward->id) ? 'selected' : '' }} value="{{ $ward->id }}">{{ $ward->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="text-danger is-invalid ward_area_err"></span>
                                </div>

                         {{-- <div class="col-md-3">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone">
                                    <option value="">Select Zone / झोन निवडा</option>
                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}" {{ ($sewerageproperties->zone == $zone->name) ? 'selected' : '' }}>{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div>
                        </div> --}}


                           <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="application_doc">Application form downloaded in the prescribed format/ विहित नमुन्यात डाउनलोड केलेला अर्ज<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="application_doc" name="application_doc" type="file" > --}}
                                @if($sewerageproperties->application_doc)
                                <a href="{{ asset('storage/' . $sewerageproperties->application_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid application_doc_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="bill_doc">Water Bill / Society Registration/Property Tax / Oc & Co / पाणी बिल/सोसायटी नोंदणी/मालमत्ता कर/ओसी अँड कंपनी<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="bill_doc" name="bill_doc" type="file"> --}}
                                @if($sewerageproperties->bill_doc)
                                <a href="{{ asset('storage/' . $sewerageproperties->bill_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid bill_doc_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="site_photo">Site photo / साइट फोटो<span
                                            class="text-danger"></span></label>
                                
                                @if($sewerageproperties->site_photo)
                                <a href="{{ asset('storage/' . $sewerageproperties->site_photo) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid site_photo_err"></span>
                            </div>


                            <div class="col-md-4">
                               <label class="col-form-label" for="blue_print">Blue print / ब्लू प्रिंट<span
                                            class="text-danger"></span></label>
                               
                                @if($sewerageproperties->blue_print)
                                <a href="{{ asset('storage/' . $sewerageproperties->blue_print) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid blue_print_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="other_doc">Other relevant Documents / इतर
                                        संबंधित कागदपत्रे<span class="text-danger"></span></label>
                              
                                @if($sewerageproperties->other_doc)
                                <a href="{{ asset('storage/' . $sewerageproperties->other_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid other_doc_err"></span>
                            </div>

                            <div class="col-md-4">
                                        <label class="col-form-label" for="site_photo">Upload site visit photo / साइट फोटो<span class="text-danger"></span></label>

                                        @if(Auth::check() && Auth::user()->hasRole('sectionengineer'))
                                            <input class="form-control" id="upload_site_photo" name="upload_site_photo" type="file">
                                        @else
                                            @if($sewerageproperties->upload_site_photo)
                                                <a href="{{ asset('storage/' . $sewerageproperties->upload_site_photo) }}" target="_blank" title="View Doc">View Doc</a>
                                            @endif
                                        @endif

                                        <span class="text-danger is-invalid upload_site_photo_err"></span>
                                    </div>

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" maxlength="255" required></textarea>
                            </div>

                        </div>


                         

                            {{-- 5. Declaration --}}
                            {{-- <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                         <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

{{-- update --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);


        var formdata = new FormData(this);
        // var updateUrl = '{{ route('strom-water-drains.edit', $sewerageproperties->id) }}';
        // formdata.append('_method', 'PUT');
        var updateUrl = '{{ route('sewerage-peoperty.update', $sewerageproperties->id) }}'; // 👈 FIXED
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<!--applicant name script -->
<script>
document.getElementById('applicant_name').addEventListener('input', function () {
    
    this.value = this.value.replace(/[^A-Za-z\s]/g, '');
});
</script>
