<x-admin.layout>
    <x-slot name="title">Electric Meter Transfer Certificate (NOC)/ विद्युत मीटर स्थलांतर प्रमाणपत्र (एनओसी)</x-slot>
    <x-slot name="heading">Electric Meter Transfer Certificate (NOC) / विद्युत मीटर स्थलांतर प्रमाणपत्र (एनओसी)</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा" required>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                           <div class="col-md-4">
                               <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                               <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}"
                               title="Please enter exactly 10 digits" required inputmode="numeric" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);">
                               <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                        </div>

                        {{-- Work Details --}}
                        <h5 class="text-primary">Stall Information / स्टॉलची माहिती</h5>
                            <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="stall_place">Stall Place/ स्टॉल पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="stall_place" name="stall_place" type="text" placeholder="Enter Stall Place / पत्ता भरा" required>
                                <span class="text-danger is-invalid stall_place_err"></span>
                            </div>
                          <div class="col-md-4">
                                <label class="col-form-label" for="stall_type">Stall Type / स्टॉल प्रकार <span class="text-danger">*</span></label>
                                <select class="form-control" id="stall_type" name="stall_type" onchange="showRelevantField()"  required>
                                    <option value=""> -- Select Stall Type / स्टॉल प्रकार निवडा --</option>
                                    <option value="Divyang Stall / दिव्यांग स्टॉल">Divyang Stall / दिव्यांग स्टॉल</option>
                                    <option value="Gatai Stall / गटाई स्टॉल">Gatai Stall / गटाई स्टॉल</option>
                                    <option value="Dudh Kendra / दूध केंद्र">Dudh Kendra / दूध केंद्र</option>
                                    <option value="Other / इतर">Other / इतर</option>
                                </select>
                                <span class="text-danger is-invalid stall_type_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label class="col-form-label" for="authorization">Authorization / अधिकृतता <span class="text-danger">*</span> </label>
                                <select class="form-control" id="authorization" name="authorization" required>
                                    <option value=""> -- Select Authorization / अधिकृतता निवडा --</option>
                                    <option value="Yes">Yes / होय</option>
                                    <option value="No">No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div>
{{--

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_order_no">Work Order Number / काम आदेश क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_no" name="work_order_no" type="text" placeholder="Enter Work Order No. / काम आदेश क्रमांक भरा">
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_completition_date">Work Completion Date / काम पूर्ण होण्याची तारीख<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completition_date" name="work_completition_date" type="date">
                                <span class="text-danger is-invalid work_completition_date_err"></span>
                            </div> --}}
                        </div>

                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="mul_parnaga_pics">Primary Licensing Department / मूल परवाना विभाग<span class="text-danger">*</span></label>
                                <input class="form-control" id="mul_parnaga_pics" name="mul_parnaga_pics" type="file" required onchange="displayFileName(this)">
                                <span class="text-danger is-invalid mul_parnaga_pics_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="adhar_card_pics"> Aadhaar Card Department / आधार कार्ड विभाग<span class="text-danger">*</span></label>
                                <input class="form-control" id="adhar_card_pics" name="adhar_card_pics" type="file" required>
                                <span class="text-danger is-invalid adhar_card_pics_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="pics"> Picture / छायाचित्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="pics" name="pics" type="file" required>
                                <span class="text-danger is-invalid pics_err"></span>
                            </div>
                            <div class="col-md-3" id="handicap_pics_div" style="display: none;">
                                <label class="col-form-label" for="handicap_pics">Handicap Picture / दिव्यांग चिन्ह<span class="text-danger">*</span></label>
                                <input class="form-control" id="handicap_pics" name="handicap_pics" type="file" required>
                                <span class="text-danger is-invalid handicap_pics_err"></span>
                            </div>

                            <div class="col-md-3" id="caste_pics_div" style="display: none;">
                                <label class="col-form-label" for="caste_pics">Caste Picture / जात<span class="text-danger">*</span></label>
                                <input class="form-control" id="caste_pics" name="caste_pics" type="file" required>
                                <span class="text-danger is-invalid caste_pics_err"></span>
                            </div>

                            <div class="col-md-3" id="milk_center_pics_div" style="display: none;">
                                <label class="col-form-label" for="milk_center_pics">Milk Center Picture / दुध केंद्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="milk_center_pics" name="milk_center_pics" type="file" required>
                                <span class="text-danger is-invalid milk_center_pics_err"></span>
                            </div>

                            <div class="col-md-3" id="gumasta_license_pics_div" style="display: none;">
                                <label class="col-form-label" for="gumasta_license_pics">Gumasta License Picture / गुमास्ता लायसन्स<span class="text-danger">*</span></label>
                                <input class="form-control" id="gumasta_license_pics" name="gumasta_license_pics" type="file" required>
                                <span class="text-danger is-invalid gumasta_license_pics_err"></span>
                            </div>

                              <div class="col-md-6" id="upload_section" style="display:none;">
                                <div class="col-md-6">
                                    <label class="col-form-label" for="prescribed_docs">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="prescribed_docs" name="prescribed_docs" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा" required>
                                    <span class="text-danger is-invalid prescribed_docs_err"></span>
                                </div>
                            </div>
                        </div>

                        </div>

                        {{-- Declaration --}}
                        <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <div id="is_correct_info_error" style="color: red; font-size: 0.875em; margin-top: 0.25rem; display: none;">
                                    This field is required
                                </div>
                            </div>
                        </div>

                    </div>

                    {{-- Footer --}}
                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit / सादर करा</button>
                        <button type="reset" class="btn btn-warning">Reset / पुन्हा भरा</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</x-admin.layout>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="{{ asset('admin/js/save_print.js') }}"></script>


{{-- Script --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        let formdata = new FormData(this);
        $.ajax({
            url: '{{ route('electric-meter-name.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css({ opacity: '0.5', visibility: 'visible' });
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error) {
                    swal("Successful!", data.success, "success").then(() => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                } else {
                    swal("Error!", data.error, "error");
                }
            },
            statusCode: {
                422: function(response) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(response.responseJSON.errors);
                },
                500: function() {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occurred!", "Something went wrong. Please try again.", "error");
                }
            },
            complete: function() {
                $('#preloader').css({ opacity: '0', visibility: 'hidden' });
            },
        });
    });
</script>


<script>
    function showRelevantField() {
        const selectedValue = document.getElementById("stall_type").value;

        // List of all dependent file inputs
        const dependentFields = [
            document.getElementById("handicap_pics"),
            document.getElementById("caste_pics"),
            document.getElementById("milk_center_pics"),
            document.getElementById("gumasta_license_pics")
        ];

        // 1. Hide all containers and remove 'required' from their inputs
        document.getElementById("handicap_pics_div").style.display = "none";
        document.getElementById("caste_pics_div").style.display = "none";
        document.getElementById("milk_center_pics_div").style.display = "none";
        document.getElementById("gumasta_license_pics_div").style.display = "none";

        dependentFields.forEach(input => {
            if (input) {
                input.removeAttribute('required');
            }
        });

        // 2. Show the relevant container and set its input to 'required'
        let requiredInput = null;

        if (selectedValue === "Divyang Stall / दिव्यांग स्टॉल") {
            document.getElementById("handicap_pics_div").style.display = "block";
            requiredInput = document.getElementById("handicap_pics");
        } else if (selectedValue === "Gatai Stall / गटाई स्टॉल") {
            document.getElementById("caste_pics_div").style.display = "block";
            requiredInput = document.getElementById("caste_pics");
        } else if (selectedValue === "Dudh Kendra / दूध केंद्र") {
            document.getElementById("milk_center_pics_div").style.display = "block";
            requiredInput = document.getElementById("milk_center_pics");
        } else if (selectedValue === "Other / इतर") {
            document.getElementById("gumasta_license_pics_div").style.display = "block";
            requiredInput = document.getElementById("gumasta_license_pics");
        }

        if (requiredInput) {
            requiredInput.setAttribute('required', 'required');
        }
    }
</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
            containerId: 'addContainer',
            printTitle: 'electric-meter-name',
        });
    });
</script>
<script>
    function displayFileName(input) {
        const fileNameDisplay = document.getElementById(input.id.replace('_pics', '_file_name'));
        if (input.files.length > 0) {
            // .name property only provides the file name, not the path
            fileNameDisplay.textContent = 'Selected: ' + input.files[0].name;
            fileNameDisplay.style.color = 'green';
        } else {
            fileNameDisplay.textContent = 'No file selected';
            fileNameDisplay.style.color = 'gray';
        }
    }
</script>
