<x-admin.layout>
    <x-slot name="title">Development Works Quantity-wise Statement / विकास कामांचा प्रमाणानुसार तपशील</x-slot>
    <x-slot name="heading">Development Works Quantity-wise Statement / विकास कामांचा प्रमाणानुसार तपशील</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा"required>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}" title="Please enter exactly 10 digits" required inputmode="numeric" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email ID / ईमेल भरा" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                        </div>

                        {{-- Work Details --}}
                        <h5 class="text-primary">Work Details / कामाची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="company_name">Company Name / कंपनीचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="company_name" name="company_name" type="text" placeholder="Enter Company Name / कंपनीचे नाव भरा" required>
                                <span class="text-danger is-invalid company_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_name">Work Name / कामाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_name" name="work_name" type="text" placeholder="Enter Work Name / कामाचे नाव भरा" required>
                                <span class="text-danger is-invalid work_name_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="work_order_no">Work Order Number / काम आदेश क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_no" name="work_order_no" type="text" placeholder="Enter Work Order No. / काम आदेश क्रमांक भरा" required>
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="work_completition_date">Work Completion Date / काम पूर्ण होण्याची तारीख<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completition_date" name="work_completition_date" type="date" required>
                                <span class="text-danger is-invalid work_completition_date_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward_area" id="ward_area" required>
                                    <option value="">Select Ward Area</option>
                                    @foreach ($options as $ward)
                                        <option value="{{ $ward->id }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>
                        </div>

                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="work_order_docs">Work Order Document / काम आदेशाची प्रत<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_docs" name="work_order_docs" type="file" required>
                                <span class="text-danger is-invalid work_order_docs_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_completition_docs">Completion Certificate (Quantity Details) / पूर्णता प्रमाणपत्र (प्रमाण तपशील)<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completition_docs" name="work_completition_docs" type="file" required>
                                <span class="text-danger is-invalid work_completition_docs_err"></span>
                            </div>

                                <div class="col-md-4" id="upload_section" style="display:none;">
                                    <label class="col-form-label" for="prescribed_doc">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="prescribed_doc" name="prescribed_doc" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा"  >
                                    <span class="text-danger is-invalid prescribed_doc_err"></span>
                                </div>

                        </div>

                        {{-- Declaration --}}
                        <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div>

                    </div>

                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit / सादर करा</button>
                        <button type="reset" class="btn btn-warning">Reset / पुन्हा भरा</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    const validationRules = {

        'applicant_name': {
            required: true,
            message: "Please enter applicant name.",
            pattern: /^[A-Za-zअ-हऀ-ॿ\s]+$/,
            patternMessage: "Only letters and spaces are allowed."
        },

        'applicant_address': {
            required: true,
            message: "Please enter applicant address."
        },

        'mobile_no': {
            required: true,
            message: "Please enter mobile number.",
            pattern: /^\d{10}$/,
            patternMessage: "Mobile number must be exactly 10 digits."
        },

        'email_id': {
            required: true,
            message: "Please enter email ID.",
            pattern: /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
            patternMessage: "Please enter a valid email."
        },

        'company_name': {
            required: true,
            message: "Please enter company name."
        },

        'work_name': {
            required: true,
            message: "Please enter work name."
        },

        'ward_area': {
            required: true,
            message: "Please select ward area."
        },

        // Document validations
        'work_order_docs': {
            required: true,
            message: "Please upload work order document."
        },

        'work_completition_docs': {
            required: true,
            message: "Please upload completion certificate / quantity details."
        },

        // 'prescribed_doc': {
        //     required: function() {
        //         // only required when upload_section is visible
        //         return document.getElementById("upload_section").style.display !== "none";
        //     },
        //     message: "Please upload prescribed format document."
        // },

        'is_correct_info': {
            required: true,
            message: "Please accept the declaration."
        }

    };


    for (const key in validationRules) {
        if (key === 'is_correct_info') continue;
        if (validationRules[key].required) {
            validationRules[key].message = "This field is required";
        }
    }

    // document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
    //     Array.from(document.querySelectorAll('.is-invalid')).forEach(el => el.textContent = '');
    //     let valid = true;

    //     for (const [id, rule] of Object.entries(validationRules)) {
    //         const field = document.getElementById(id);

    //         if (!field) continue;

    //         if (field.type === 'checkbox' && !field.checked) {
    //             valid = false;
    //             document.querySelector(`.${id}_err`).textContent = rule.message;
    //         } else if (field.type === 'radio') {
    //             const radios = document.getElementsByName(field.name);
    //             if (![...radios].some(r => r.checked)) {
    //                 valid = false;
    //                 document.querySelector(`.${id}_err`).textContent = rule.message;
    //             }
    //         } else if (field.type === 'file' && field.files.length === 0) {
    //             valid = false;
    //             document.querySelector(`.${id}_err`).textContent = rule.message;
    //         } else if (rule.required && !field.value.trim()) {
    //             valid = false;
    //             document.querySelector(`.${id}_err`).textContent = rule.message;
    //         } else if (rule.pattern && !rule.pattern.test(field.value.trim())) {
    //             valid = false;
    //             document.querySelector(`.${id}_err`).textContent = rule.patternMessage;
    //         }
    //     }

    //     if (!valid) {
    //         return;
    //     }

    //     document.getElementById('upload_section').style.display = 'block';
    //     document.getElementById('card-footer').style.display = 'block';

    //     generatePDF();
    // });

    //    function generatePDF() {
    //     document.getElementById('upload_section').style.display = 'block';
    //     document.getElementById('card-footer').style.display = 'block';

    //     const addContainer = document.getElementById('addContainer');
    //     if (!addContainer) return;
    //     const printContainerClone = addContainer.cloneNode(true);

    //     Array.from(printContainerClone.querySelectorAll('input, textarea, select')).forEach(el => {
    //         if (!el.value || el.value.trim() === '') {
    //             const parentCol = el.closest('.col-md-4, .col-md-5, .col-md-6');
    //             if (parentCol) parentCol.style.display = 'none';
    //         }
    //     });

    //     Array.from(printContainerClone.querySelectorAll('input[type="radio"]')).forEach(el => {
    //         const name = el.name;
    //         const radioGroup = printContainerClone.querySelectorAll(`input[name="${name}"]`);
    //         const isChecked = Array.from(radioGroup).some(r => r.checked);
    //         if (!isChecked) {
    //             const parentCol = el.closest('.col-md-4, .col-md-5, .col-md-6');
    //             if (parentCol) parentCol.style.display = 'none';
    //         }
    //     });

    //     printContainerClone.style.fontSize = '16px';
    //     printContainerClone.style.lineHeight = '1.4';
    //     printContainerClone.style.padding = '20px';
    //     printContainerClone.style.margin = '0 auto';
    //     printContainerClone.style.background = '#fff';
    //     printContainerClone.style.width = '210mm';
    //     printContainerClone.style.minHeight = '297mm';
    //     printContainerClone.style.boxSizing = 'border-box';
    //     Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
    //         el.style.fontSize = '16px';
    //         el.style.margin = '4px 0';
    //     });
    //     const printTitle = document.createElement('h2');
    //     printTitle.style.textAlign = 'center';
    //     printTitle.style.marginBottom = '18px';
    //     printTitle.style.fontSize = '18px';
    //     printTitle.textContent = 'Development Works Quantity';
    //     printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);
    //     Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
    //     Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
    //         card.style.background = 'white';
    //         card.style.boxShadow = 'none';
    //         card.style.border = '1px solid #ccc';
    //         card.style.marginBottom = '12px';
    //         card.style.padding = '12px';
    //     });

    //     Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
    //         div.classList.remove('d-none');
    //     });

    //     let printContainer = document.getElementById('printContainer');
    //     if (!printContainer) {
    //         printContainer = document.createElement('div');
    //         printContainer.id = 'printContainer';
    //         printContainer.style.position = 'fixed';
    //         printContainer.style.left = '-9999px';
    //         document.body.appendChild(printContainer);
    //     }
    //     printContainer.innerHTML = '';
    //     printContainer.appendChild(printContainerClone);

    //     const prescribedInput = printContainerClone.querySelector('#prescribed_formats');
    //     if (prescribedInput) {
    //         prescribedInput.closest('.col-md-4').style.display = 'none';
    //     }
    //     printContainerClone.querySelectorAll('select').forEach(select => {
    //         const label = select.closest('.col-md-4')?.querySelector('label')?.innerText || 'Selected:';
    //         const selectedText = select.options[select.selectedIndex]?.text || '';
    //         const displayDiv = document.createElement('div');
    //         displayDiv.innerHTML = `<strong>${label}</strong> ${selectedText || 'N/A'}`;
    //         select.parentNode.insertBefore(displayDiv, select);
    //         select.style.display = 'none';
    //     });
    //     html2canvas(printContainerClone, {
    //         scrollY: -window.scrollY,
    //         backgroundColor: '#fff',
    //         scale: 1,
    //         useCORS: true,
    //         allowTaint: true,
    //         logging: false
    //     }).then(canvas => {
    //         const imgData = canvas.toDataURL('image/jpeg', 0.6);
    //         const {
    //             jsPDF
    //         } = window.jspdf;
    //         const pdf = new jsPDF('p', 'mm', 'a4');
    //         const pageWidth = pdf.internal.pageSize.getWidth();
    //         const pageHeight = pdf.internal.pageSize.getHeight();
    //         const margin = 10;
    //         const pdfWidth = pageWidth - margin * 2;
    //         const pdfHeight = pageHeight - margin * 2;
    //         pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);
    //         const pdfBlob = pdf.output('blob');
    //         if (pdfBlob.size > 2 * 1024 * 1024) {
    //             alert('Warning: PDF size is greater than 2 MB. Please reduce content or try again.');
    //         }
            
    //         pdf.save('grant-nursing-license-certificate.pdf');
    //         document.getElementById('saveAndPrintBtn').style.display = 'none';
    //         document.getElementById('card-footer').style.display = 'block';
    //     });
    // };

 
</script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
    attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
        containerId: 'addContainer',
        printTitle: 'Development-Works-Quantity',
    });
});
</script>

{{-- Script --}}
<script>
document.addEventListener('DOMContentLoaded', () => {
    // --- Detect field type for validation ---
    function detectFieldType(input) {
        const s = ((input.name || '') + ' ' + (input.id || '') + ' ' + (input.placeholder || '')).toLowerCase();
        if (/\applicant_name|\bf_name|\bmiddle_name|\bm_name|\blast_name|\bl_name/.test(s)) return 'name';
        if (/\baadhaar|\baadhar|\baadhar_no|\baadhar_num|\baadhar-number/.test(s)) return 'aadhar';
        if (/\bmobile|\bmobile_no|\bcontact|\bcontact_no|\bphone|\btelephone|\btel/.test(s)) return 'phone';
        if (/\bemail|\be-mail|\bmail|\balternate_email|\balternate_email|\bemail_id/.test(s)) return 'email';
        if (/\bpan|\bpancard|\bpan_no|\bpan_number/.test(s)) return 'pan';
        return null;
    }

    // --- Get error span ---
    function getErrorSpan(input) {
        if (input.name) {
            const spanByName = document.querySelector(`.${input.name}_err`);
            if (spanByName) return spanByName;
        }
        if (input.id) {
            const spanById = document.querySelector(`.${input.id}_err`);
            if (spanById) return spanById;
        }
        return input.closest('div')?.querySelector('span.text-danger') || null;
    }

    // --- Validation rules ---
    function validateValueByType(value, type, required) {
        if (type === 'name') {
        if (required && value === '') return 'This field is required';
        if (value && !/^[A-Za-z\s]+$/.test(value)) return 'Only letters and spaces are allowed';
        return '';
        }
        if (type === 'aadhar') {
            if (required && value === '') return 'Aadhaar number is required';
            if (value && !/^\d{12}$/.test(value)) return 'Enter a valid 12-digit Aadhaar number';
            return '';
        }
        if (type === 'phone') {
            if (required && value === '') return 'Mobile number is required';
            if (value && !/^[6-9]\d{9}$/.test(value)) return 'Enter a valid 10-digit mobile number';
            return '';
        }
        if (type === 'email') {
            if (required && value === '') return 'Email is required';
            if (value && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) return 'Enter a valid email address';
            return '';
        }
        if (type === 'pan') {
            if (required && value === '') return 'This field is required';
            if (value && !/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/.test(value.toUpperCase())) return 'Enter a valid PAN number';
            return '';
        }
        return '';
    }

         function validateField(input) {
                if (input.type === "file") {
            const file = input.files[0];
            const span = getErrorSpan(input);

            if (file) {
                if (file.size > 2 * 1024 * 1024) { // > 2MB
                    if (span) {
                        span.textContent = `File must be less than 2MB.`;
                        span.style.display = "block";
                    }
                    input.classList.add("is-invalid");
                    input.setAttribute("aria-invalid", "true");
                    return false;
                } else {
                    if (span) {
                        span.textContent = "";
                        span.style.display = "none";
                    }
                    input.classList.remove("is-invalid");
                    input.removeAttribute("aria-invalid");
                    return true;
                }
            } else if (input.hasAttribute('required')) {
                if (span) {
                    span.textContent = "This file is required";
                    span.style.display = "block";
                }
                input.classList.add("is-invalid");
                input.setAttribute("aria-invalid", "true");
                return false;
            }

            return true;
        }

        // Checkbox validation (must come first)
        if (input.type === 'checkbox' && (input.id === 'is_correct_info' || input.name === 'is_correct_info')) {
            const span = getErrorSpan(input);
            if (!input.checked) {
                if (span) { span.textContent = 'Please accept the declaration.'; span.style.display = 'block'; }
                input.classList.add('is-invalid');
                return false;
            } else {
                if (span) { span.textContent = ''; span.style.display = 'none'; }
                input.classList.remove('is-invalid');
                input.removeAttribute('aria-invalid');
                return true;
            }
        }

        const value = (input.value || '').trim();
        const required = input.hasAttribute('required');
        const type = detectFieldType(input);

        let err = '';
        if (type) err = validateValueByType(value, type, required);
        else if (required && value === '') err = 'This field is required';

        const span = getErrorSpan(input);
        if (span) { span.textContent = err; span.style.display = err ? 'block' : 'none'; }

        if (err) {
            input.classList.add('is-invalid');
            input.setAttribute('aria-invalid', 'true');
        } else {
            input.classList.remove('is-invalid');
            input.removeAttribute('aria-invalid');
        }

        return !err;
    }

    // --- Validate all fields ---
    function validateAllFields(form) {
        let allValid = true;
        const inputs = Array.from(form.querySelectorAll('input, textarea, select'));
        inputs.forEach(input => {
            if (input.offsetParent === null) return; // skip hidden
            if (!validateField(input)) allValid = false;
        });
        return allValid;
    }

    // --- Attach input/blur events ---
    const allInputs = Array.from(document.querySelectorAll('input, textarea, select'));
    allInputs.forEach(input => {
        input.addEventListener('input', () => validateField(input));
        input.addEventListener('blur', () => validateField(input));
    });

    window.validateAllFields = validateAllFields;

    // --- Save & Print button ---
    document.getElementById('saveAndPrintBtn').addEventListener('click', () => {
        const form = document.getElementById('addForm');
        if (!validateAllFields(form)) return;

        // Show footer after validation passes
        document.getElementById('card-footer').style.display = 'block';
    });

});
</script>
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        const fileField = document.getElementById('prescribed_doc');
        if (!fileField || fileField.files.length === 0) {
            // $('.prescribed_formats_err').text("Please upload application in prescribed format.");
            $('.prescribed_doc_err').text("This field is required");
            return false;
        }
        $("#addSubmit").prop('disabled', true);

        let formdata = new FormData(this);
        $.ajax({
            url: '{{ route('development-work-quantity.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css({
                    opacity: '0.5',
                    visibility: 'visible'
                });
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error) {
                    swal("Successful!", data.success, "success").then(() => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                } else {
                    swal("Error!", data.error, "error");
                }
            },
            statusCode: {
                422: function(response) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(response.responseJSON.errors);
                },
                500: function() {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occurred!", "Something went wrong. Please try again.", "error");
                }
            },
            complete: function() {
                $('#preloader').css({
                    opacity: '0',
                    visibility: 'hidden'
                });
            },
        });
    });
</script>
