<!DOCTYPE html>
<html lang="mr">
<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 40px;
            font-size: 18px;
        }
        .header, .footer {
            text-align: center;
        }
        /* .sub-header {
            text-align: right;
            margin-bottom: 20px;
        } */
        .certificate-title {
            font-size: 22px;
            margin: 20px 0;
            text-decoration: underline;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }
        th, td {
            border: 1px solid #333;
            padding: 10px;
            text-align: left;
            vertical-align: top;
        }
        .logos {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logos img {
            height: 120px;
        }
        .logo-center {
            text-align: center;
        }
        .logo-center h2 {
            margin: 10px 0 0 0;
        }
        .signature {
            margin-top: 50px;
            text-align: right;
        }
        .inner-table td {
            border: none;
            padding: 4px 6px;
        }
    </style>
</head>
<body>

<div class="header">
    @php
    $logoData = file_get_contents(public_path('admin/images/favicon.png'));
    $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
    $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
    $base64Logo = base64_encode($logoData);
    $base64Logo2 = base64_encode($logoData2);
    $base641Logo = base64_encode($logoData1);
    @endphp
    {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
    <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
    <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo"  style="float:right;margin-top:35px;" height="150" width="150"> --}}
     {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150"> --}}
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" style="float:left;margin-top:30px;"height="120" width="150">
    <div class="rox">
        <h2>मिरा भाईंदर महानगरपालिका</h2>
        <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
        <p>दूरध्वनी क्र.२८१९२४८</p>
          {{-- <h2>( बांधकाम/विद्युत ) विभाग</h2> --}}
           <h3 style="margin-left: 8rem">( बांधकाम/विद्युत ) विभाग</h3>
    </div>
</div>

<hr>
<hr style="1px solid #000; height:5px; background-color:#000;">

 <div class="sub-header">
        <div class="row d-flex">

        <p>जा.क्र. मनपा/साबां/वि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
&nbsp;
        दि. <span >{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span >{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>

        <h4 style="text-align: center;">विकास कामांचा प्रमाणानुसार तपशील</h4>

<table>
    <tr><th>1</th><td>Name of the work</td><td>{{ $data->work_name}}</td></tr>
    <tr><th>2</th><td>Name of the Contractor Address</td><td>{{ $data->applicant_address}}</td></tr>
    <tr><th>3</th><td>Work Order No./Date</td><td>{{ $data->work_order_no}}</td></tr>
    <tr><th>4</th><td>Contract Period</td><td>14 months</td></tr>
    <tr><th>5</th><td>Original Contract Cost</td><td>Rs. 1,43,65,000/-</td></tr>
    <tr><th>6</th><td>Part Completed Work Cost</td><td>Rs. 1,57,18,22,097/-</td></tr>
    <tr><th>7</th><td>Date of Commencement</td><td>18/08/2023</td></tr>
    <tr><th>8</th><td>Date of Completion as per contract</td><td>17/10/2024</td></tr>
    <tr><th>9</th><td>Status of work</td><td>Work is completed</td></tr>
    <tr><th>10</th><td>Work Completed Date</td><td>{{ $data->work_completition_date}}</td></tr>

    <tr>
        <th>11</th>
        <td>Major Works completed under above contract</td>
        <td>
            <table class="inner-table">
                <tr><td>1.</td><td>Excavation for foundation</td><td>2195.79 CMT</td></tr>
                <tr><td>2.</td><td>Internally or externally lime plaster</td><td>462.56 SMT</td></tr>
                <tr><td>3.</td><td>Soling</td><td>67.74 CMT</td></tr>
                <tr><td>4.</td><td>Concrete in Plinth or for Bedding</td><td>653.31 CMT</td></tr>
                <tr><td>5.</td><td>Trap stone pavement</td><td>1517.40 SMT</td></tr>
                <tr><td>6.</td><td>UCR of trap stone in lime mortar</td><td>2132.49 CMT</td></tr>
                <tr><td>7.</td><td>CR of trap stone in lime mortar</td><td>812.23 CMT</td></tr>
                <tr><td>8.</td><td>Coat of lime to rough plastered surface</td><td>2347.90 SMT</td></tr>
                <tr><td>9.</td><td>Relevant stones for segmental</td><td>26.34 SMT</td></tr>
                <tr><td>10.</td><td>Pointing to stone or brick surface</td><td>599.28 SMT</td></tr>
                <tr><td>11.</td><td>Gently cleaning the surface of the stone masonry</td><td>8438.74 SMT</td></tr>
                <tr><td>12.</td><td>Dismantled materials of stone masonry</td><td>2195.79 CMT</td></tr>
                <tr><td>13.</td><td>Grouting with lime and fine screened</td><td>1627.56 KG</td></tr>
                <tr><td>14.</td><td>Cement / lime pointing from walls</td><td>694.88 SMT</td></tr>
                <tr><td>15.</td><td>Benches of Ashlar rough tooled</td><td>8.00 NOS</td></tr>
                <tr><td>16.</td><td>Removing and refixing stone flooring</td><td>37.54 SQM</td></tr>
            </table>
        </td>
    </tr>

    <tr><th>12</th><td>Scope of Work</td><td>Restoration & Repairing of Ghodbundar Fort</td></tr>
    <tr><th>13</th><td>Remark</td><td>The above-mentioned quantity is Completed by Contractor M/s. M. Devang Construction Co. The performance of the contractor is satisfactory.</td></tr>
</table>

<div class="footer">
    <p>This certificate is issued for M/s. M. Devang Construction Co. request Letter of dated <strong>18/02/2025</strong>.</p>
</div>

<div class="signature">
    <p><strong>(Nitin Mukane)</strong><br>
    Executive Engineer (PWD/Elect.)<br>
    Mira-Bhayandar Municipal Corporation</p>
</div>

</body>
</html>
