<x-admin.layout>
    <x-slot name="title">Path Road Citizenship Certificate (NOC) / पथ रस्ता नाहरकत दाखला (NOC)</x-slot>
    <x-slot name="heading">Path Road Citizenship Certificate (NOC) / पथ रस्ता नाहरकत दाखला (NOC)</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा">
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                           <div class="col-md-4">
                               <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                               <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}"
                               title="Please enter exactly 10 digits" required inputmode="numeric" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);">
                               <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email ID / ईमेल भरा">
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                        </div>

                        {{-- Owner Details --}}
                        <h5 class="text-primary">Owner Details / मालकाची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="property_owner_name">Property Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_owner_name" name="property_owner_name" type="text" placeholder="Enter Owner Name / मालकाचे नाव">
                                <span class="text-danger is-invalid property_owner_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="property_address">Property Address / मालमत्तेचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_address" name="property_address" type="text" placeholder="Enter Address / पत्ता भरा">
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>

                            <div class="col-md-4">
                               <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward" id="ward">
                                <option value="">Select Ward Area</option>
                                    @foreach($wards as $ward)
                                     <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                            <span class="text-danger is-invalid ward_err"></span>
                        </div>


                        </div>

                        {{-- Other Details --}}
                        <h5 class="text-primary">Property & Authorization / मालमत्ता व अधिकृतता</h5>
                        <div class="mb-3 row">

                            <div class="col-md-6">
                                <label class="col-form-label" for="property_type">Property Type / मालमत्तेचा प्रकार<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="property_type" id="property_type" cols="30" rows="2" placeholder="Enter Property Type / मालमत्तेचा प्रकार भरा"></textarea>
                                <span class="text-danger is-invalid property_type_err"></span>
                            </div>

                               <div class="col-md-3">
                                <label class="col-form-label" for="authorization">Authorization / अधिकृतता<span class="text-danger">*</span></label>
                                <select class="form-select" name="authorization" id="authorization">
                                    <option value="" disabled selected>-- Select / निवडा --</option>
                                    <option value="Yes">Yes / होय</option>
                                    <option value="No">No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div>


                            {{-- Uncomment if zone dropdown is used --}}
                            {{-- <div class="col-md-3">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone">
                                    <option value="">Select Zone / झोन निवडा</option>
                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}
                        </div>

                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="plan_copy">Sanctioned Plan Copy / मंजूर प्लान प्रत<span class="text-danger">*</span></label>
                                <input class="form-control" id="plan_copy" name="plan_copys" type="file" placeholder="Enter Plan Copy">
                                <span class="text-danger is-invalid plan_copys_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="side_visit_geotag_pic">Site Visit Geotag Photo / साइट भेट फोटो<span class="text-danger">*</span></label>
                                <input class="form-control" id="side_visit_geotag_pic" name="side_visit_geotag_pics" type="file" placeholder="Enter side visit geotag photo">
                                <span class="text-danger is-invalid side_visit_geotag_pics_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="property_doc">Property Document / मालमत्तेचे दस्तऐवज<span class="text-danger">*</span></label>
                                <input class="form-control" id="property_doc" name="property_docs" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा">
                                <span class="text-danger is-invalid property_docs_err"></span>
                            </div>
                        </div>

                        {{-- Declaration --}}
                        <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div>

                    </div>

                    {{-- Footer --}}
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit / सादर करा</button>
                        <button type="reset" class="btn btn-warning">Reset / पुन्हा भरा</button>
                    </div>

                </form>
            </div>
        </div>
    </div>

</x-admin.layout>




{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('path-road-citizen.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
