<x-admin.layout>
    <x-slot name="title">Path Road Citizenship Certificate (NOC) / पथ रस्ता नाहरकत दाखला (NOC)</x-slot>
    <x-slot name="heading">Path Road Citizenship Certificate (NOC) / पथ रस्ता नाहरकत दाखला (NOC)</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details</h4>
                    </div>

                    <div class="card-body">
                        <div class="mb-3 row">

                            {{-- 1. Applicant Details --}}
                            <h5 class="mb-3">Applicant Details / अर्जदाराची माहिती</h5>
                            <div class="col-md-4">
                                <label for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_name" id="applicant_name" class="form-control" placeholder="Enter applicant name" value="{{ $pathroadcitizen->applicant_name }}">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_address" id="applicant_address" class="form-control" placeholder="Enter applicant address" value="{{ $pathroadcitizen->applicant_address }}">
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>
{{--
                            <div class="col-md-4">
                                <label for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input type="text" name="mobile_no" id="mobile_no" class="form-control" placeholder="Enter mobile number" value="{{ $pathroadcitizen->mobile_no }}">
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div> --}}
                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}"
                                    title="Please enter exactly 10 digits"
                                    required
                                    inputmode="numeric"
                                    value="{{ old('mobile_no', $pathroadcitizen->mobile_no) }}"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);"
                                >
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input type="email" name="email_id" id="email_id" class="form-control" placeholder="Enter email ID" value="{{ $pathroadcitizen->email_id }}">
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            {{-- 2. Owner Details --}}
                            <h5 class="mt-4 mb-3">Owner Details / मालकाची माहिती</h5>
                            <div class="col-md-4">
                                <label for="property_owner_name">Property Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="property_owner_name" id="property_owner_name" class="form-control" placeholder="Enter owner name" value="{{ $pathroadcitizen->property_owner_name }}">
                                <span class="text-danger is-invalid property_owner_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="property_address">Property Address / मालमत्तेचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="property_address" id="property_address" class="form-control" placeholder="Enter property address" value="{{ $pathroadcitizen->property_address }}">
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label for="ward">Ward / प्रभाग<span class="text-danger">*</span></label>
                                <input type="text" name="ward" id="ward" class="form-control" placeholder="Enter ward number" value="{{ $pathroadcitizen->ward }}">
                                <span class="text-danger is-invalid ward_err"></span>
                            </div> --}}

                             <div class="col-md-4">
                             <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                             <select class="form-select" name="ward" id="ward">
                             <option value="">Select Ward Area</option>
                              @foreach($wards as $ward)
                             <option value="{{ $ward->name }}" {{ ($pathroadcitizen->ward == $ward->name) ? 'selected' : '' }}>
                             {{ $ward->name }}
                             </option>
                             @endforeach
                              </select>
                          <span class="text-danger is-invalid ward_err"></span>
                         </div>

                            {{-- 3. Property Details --}}
                            <h5 class="mt-4 mb-3">Property Information / मालमत्तेची माहिती</h5>
                            <div class="col-md-6">
                                <label for="property_type">Property Type / मालमत्तेचा प्रकार<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="property_type" id="property_type" rows="2" placeholder="Enter property type">{{ $pathroadcitizen->property_type }}</textarea>
                                <span class="text-danger is-invalid property_type_err"></span>
                            </div>

                            {{-- <div class="col-md-3">
                                <label for="authorization">Road Type Authorization / रस्त्याचे प्रकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="authorization" id="authorization">
                                    <option value="" disabled selected>-- Select --</option>
                                    <option value="yes" {{ $pathroadcitizen->authorization == 'yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="no" {{ $pathroadcitizen->authorization == 'no' ? 'selected' : '' }}>No</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div> --}}
                            <div class="col-md-3">
                                <label for="authorization">Road Type Authorization / रस्त्याचे प्रकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="authorization" id="authorization">
                                    <option value="" disabled>-- Select --</option>
                                    <option value="Yes" {{ $pathroadcitizen->authorization == 'Yes' ? 'selected' : '' }}>Yes / होय</option>
                                    <option value="No" {{ $pathroadcitizen->authorization == 'No' ? 'selected' : '' }}>No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div>

                            {{-- 4. Documents --}}
                            <h5 class="mt-4 mb-3">Document Uploads / दस्तऐवज अपलोड करा</h5>
                            <div class="col-md-3">
                                <label for="plan_copy">Sanctioned Plan Copy / मंजूर प्लान प्रत<span class="text-danger">*</span></label>
                                <input type="file" name="plan_copy" id="plan_copy" class="form-control" accept="image/*,.pdf">
                               @if($pathroadcitizen->plan_copy)
                               <a href="{{ asset('storage/' . $pathroadcitizen->plan_copy) }}" target="_blank" title="View Plan Copy">View Doc</a>
                               @endif

                                {{-- <a id="plantViewFile" target="_blank" title="View Document">View Doc</a> --}}
                                <span class="text-danger is-invalid plan_copy_err"></span>
                              </div>


                            <div class="col-md-3">
                                <label for="side_visit_geotag_pic">Site Visit Geotag Photo / साईट व्हिजिट फोटो <span class="text-danger">*</span></label>
                                <input type="file" name="side_visit_geotag_pic" id="side_visit_geotag_pic" class="form-control" accept="image/*">
                                {{-- <a id="side_visit_geotag_pic" target="_blank" title="View Document">View Doc</a> --}}
                                @if($pathroadcitizen->side_visit_geotag_pic)
                               <a href="{{ asset('storage/' . $pathroadcitizen->side_visit_geotag_pic) }}" target="_blank" title="side visit geotag pic">View Doc</a>
                               @endif
                                <span class="text-danger is-invalid side_visit_geotag_pic_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label for="property_doc">Property Document / मालमत्तेचे दस्तऐवज<span class="text-danger">*</span></label>
                                <input type="file" name="property_doc" id="property_doc" class="form-control" accept="image/*,.pdf">
                                {{-- <a id="property_doc" target="_blank" title="View Document">View Doc</a> --}}
                                @if($pathroadcitizen->property_doc)
                               <a href="{{ asset('storage/' . $pathroadcitizen->property_doc) }}" target="_blank" title="property doc">View Doc</a>
                               @endif
                                <span class="text-danger is-invalid property_doc_err"></span>
                            </div>

                            {{-- 5. Declaration --}}
                            {{-- <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>



{{-- update --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);


        var formdata = new FormData(this);
        var updateUrl = '{{ route('path-road-citizen.update', $pathroadcitizen->id) }}'; // 👈 FIXED
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
