<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>गटारे, फूटपाथ यावर खाजगी संस्थामार्फत स्लॅब टाकण्यासाठी परवानगी</title>
    <style>
        @media print {
            body {
                margin: 0;
                padding: 20px;
                font-family: 'Mangal', Devanagari, serif;
                font-size: 18px;
                line-height: 1.5;
                text-align: justify;
            }

            .header, .footer {
                text-align: center;
            }

            .rox h2, .rox h3, .rox p {
                margin: 0;
                padding: 0;
            }

            .content, .points, p, li {
                font-family: 'Mangal', Devanagari, serif;
                font-size: 18px;
                line-height: 1.5;
                text-align: justify;
            }

            .points li {
                margin-left: 5%;
            }

            hr {
                border: none;
                height: 2px;
                background-color: #000;
                margin: 10px 0;
            }

            .footer {
                text-align: right;
                margin-top: 40px;
                font-weight: bold;
            }

            .sub-header {
                margin-top: 10px;
            }

            /* Force all content to fit on one page */
            body {
                max-height: 100vh;
                overflow: hidden;
            }
        }

        /* For screen preview */
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
            line-height: 1.5;
            text-align: justify;
        }

        .header, .footer {
            text-align: center;
        }

        .rox h2, .rox h3, .rox p {
            margin: 0;
            padding: 0;
        }

        .content, .points, p, li {
            font-family: 'Mangal', Devanagari, serif;
            font-size: 18px;
            line-height: 1.5;
            text-align: justify;
        }

        .points li {
            margin-left: 5%;
            margin-bottom: 10px;
        }

        hr {
            border: none;
            height: 2px;
            background-color: #000;
            margin: 10px 0;
        }

        .footer {
            text-align: right;
            margin-top: 40px;
            font-weight: bold;
        }

        .sub-header {
            margin-top: 10px;
        }
    </style>
</head>

<body>
     @php
        $logoData = file_get_contents(public_path('admin/images/favicon.png'));
        $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
        $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
        $base64Logo = base64_encode($logoData);
        $base64Logo2 = base64_encode($logoData2);
        $base641Logo = base64_encode($logoData1);
    @endphp

    <div class="header">
        {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/jpeg;base64,{{ $base641Logo }}" alt="Left Logo" style="float:left; margin-top:35px;" height="150" width="150">
        <img src="data:image/jpeg;base64,{{ $base64Logo2 }}" alt="Right Logo" style="float:right;margin-top:35px;" height="150" width="150"> --}}
         {{-- <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150"> --}}
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" style="float:left;margin-top:30px;"height="120" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व. इंदिरा गांधी भवन, मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.), ता. ठाणे - ४०११०१</p>
            <p>दूरध्वनी क्र.: २८१९२४८</p>
            {{-- <h2>( बांधकाम/विद्युत ) विभाग</h2> --}}
            <h3 style="margin-left: 8rem">( बांधकाम/विद्युत ) विभाग</h3>
        </div>
    </div>

    <hr>

    <p>जा.क्र. मनपा/साबां/वि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    @php $paymentDate = optional($payment)->created_at; @endphp
    @if($paymentDate)
        दि. <span>{{ \Carbon\Carbon::parse($paymentDate)->format('d/m/Y') }}</span>
    @endif
    </p>

    <h4 style="text-align: center;">गटारे, फूटपाथ यावर खाजगी संस्थामार्फत स्लॅब टाकण्यासाठी परवानगी व डिझाईन देणे / खाजगी संस्थांना स्वखर्चाने गटारे, नाले, रस्ते बांधण्यास परवानगी देणे</h4>

    <p><b>प्रति,</b><br>
        &nbsp;&nbsp;&nbsp;&nbsp;{{ $data->applicant_name }} <br>
        &nbsp;&nbsp;&nbsp;&nbsp;{{ $data->applicant_address }}
    </p>

    <p><strong>विषय :</strong> {{ $data->survey_number }}या जागेसमोर स्वखर्चाने नाल्यावर पुल बांधणेस परवानगी मिळणेबाबत...</p>

    <div class="sub-header">
        <p><strong>संदर्भ :</strong> आपल्याकडील दिनांक : <span>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span>/<span>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }} रोजीचे पत्र.</span></p>
    </div>

    <div class="content">
        उपरोक्त विषयान्वये मिरा-भाईंदर महानगरपालिका क्षेत्रातील {{ $data->survey_number }} या जागेसमोर स्वखर्चाने नाल्यावर पुल बांधण्यास परवानगी संदर्भिय पत्रान्वये मागितलेली आहे. 
        तरी सोबत जोडलेल्या क्रॉस सेक्शननुसार व नमुद केल्यानुसार नाल्यावर/गटारावर/फूटपाथवर स्वखर्चाने स्लॅब टाकून पुल बांधणेसाठी मनपाच्या देखरेखीखाली खालील अटीशर्तीस अधीन राहुन परवानगी देण्यात येत आहे.
    </div>

    <div class="content" style="margin-left:10px;">
        <strong>अटीशर्ती :-</strong><br>
        1) महानगरपालिकेने मंजूर केलेल्या नकाशानुसार महानगरपालिकेच्या संबंधित कनिष्ठ / शाखा अभियंता यांचे देखरेखीखाली काम करावे.<br>
        2) सदर नाल्याचे काम करणेपूर्वी महानगरपालिकेकडून Level तपासुन त्यानुसारच काम करावे.<br>
        3) सदर ठिकाणी जागेच्या मालकी हक्काबाबत वाद निर्माण झाल्यास सर्वस्वी जबाबदारी आपणांवर राहिल,<br>
        4) सदर काम विहीत मुदतीत व माप दंडकानुसार करुन द्यावे लागेल.<br>
        5) सदर काम सुरु केल्यानंतर 15 दिवसात पुर्ण करावे. व साईटवर आजुबाजूला पडलेले मटेरियल साफसफाई तातडीने करुन घेण्याची जबाबदारी आपली राहिल.<br>
        6) सदर कामाच्या ठिकाणी सुरक्षेच्या दृष्टीने योग्य ती उपाययोजना करण्याची जबाबदारी आपली राहील.<br>
        7) सदर अटीशर्तीचे भंग केल्यास परवानगी रद्द करुन चुकीचे काम तोडण्यात येईल यांची नोंद घ्यावी.<br>
        8) सदर पुल बांधकामामुळे पुरसदृष्य परिस्थिती निर्माण झाल्यास सदर पुलाचे बांधकाम स्वखर्चाने काढून घेण्याची जवाबदारी आपली राहिल.
    </div>

    <div class="footer">
        <strong>(नितिन मुकणे)<br>
        कार्यकारी अभियंता ( साबां / वि.)<br>
        मिरा-भाईंदर महानगरपालिका</strong>
    </div>
</body>

</html>
