<x-admin.layout>
    <x-slot name="title">Granting permission and design approval for private organizations to install slabs on gutters and footpaths / Granting permission to private organizations to construct gutters, drains, and roads at their own expense./ गटारे, फूटपाथ यावर खाजगी संस्थामार्फत स्लॅब टाकण्यासाठी परवानगी व डिझाईन देणे / खाजगी संस्थांना स्वखर्चाने गटारे, नाले, रस्ते बांधण्यास परवानगी देणे.</x-slot>
    <x-slot name="heading">Granting permission and design approval for private organizations to install slabs on gutters and footpaths / Granting permission to private organizations to construct gutters, drains, and roads at their own expense./ गटारे, फूटपाथ यावर खाजगी संस्थामार्फत स्लॅब टाकण्यासाठी परवानगी व डिझाईन देणे / खाजगी संस्थांना स्वखर्चाने गटारे, नाले, रस्ते बांधण्यास परवानगी देणे.</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">View Details</h4>
                    </div>

                    <div class="card-body">
                        <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">
                            {{-- 1. Applicant Details --}}
                            <h5 class="mb-3">Applicant Details / अर्जदाराची माहिती</h5>
                            <div class="col-md-4">
                                <label for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_name" id="applicant_name" class="form-control" placeholder="Enter applicant name" value="{{ $privateinfrastructure->applicant_name }}" readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_address" id="applicant_address" class="form-control" placeholder="Enter applicant address" value="{{ $privateinfrastructure->applicant_address }}" readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>
                            <div class="col-md-4">
                               <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}"
                                    title="Please enter exactly 10 digits"
                                    required
                                    inputmode="numeric"
                                    value="{{ old('mobile_no', $privateinfrastructure->mobile_no) }}"
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);"
                                readonly="" disabled="">
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input type="email" name="email_id" id="email_id" class="form-control" placeholder="Enter email ID" value="{{ $privateinfrastructure->email_id }}" readonly="" disabled="">
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            {{-- 2. Owner Details --}}
                            <h5 class="mt-4 mb-3">Owner Details / मालकाची माहिती</h5>
                            <div class="col-md-4">
                                <label for="property_owner_name">Property Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="property_owner_name" id="property_owner_name" class="form-control" placeholder="Enter owner name" value="{{ $privateinfrastructure->property_owner_name }}" readonly="" disabled="">
                                <span class="text-danger is-invalid property_owner_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="property_address">Property Address / मालमत्तेचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="property_address" id="property_address" class="form-control" placeholder="Enter property address" value="{{ $privateinfrastructure->property_address }}" readonly="" disabled="">
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label class="col-form-label" for="survey_number">Survey Number<span class="text-danger">*</span></label>
                                <input class="form-control" id="survey_number" name="survey_number" type="text" placeholder="Enter Servey Number" value="{{ $privateinfrastructure->survey_number }}" readonly="" disabled="">
                                <span class="text-danger is-invalid survey_number_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label for="ward">Ward / प्रभाग<span class="text-danger">*</span></label>
                                <input type="text" name="ward" id="ward" class="form-control" placeholder="Enter ward number" value="{{ $privateinfrastructure->ward }}">
                                <span class="text-danger is-invalid ward_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                             <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                             <select class="form-select" name="ward_area" id="ward_area" readonly="" disabled="">
                             <option value="">Select Ward Area</option>
                              @foreach($wards as $ward)
                             <option value="{{ $ward->id }}" {{ ($privateinfrastructure->ward_area == $ward->id) ? 'selected' : '' }} readonly="" disabled="">
                             {{ $ward->name }}
                           </option>
                            @endforeach
                          </select>
                          <span class="text-danger is-invalid ward_area_err"></span>
                        </div>

                                    {{-- <div class="col-md-4">
                               <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward" id="ward">
                                <option value="">Select Ward Area</option>
                                    @foreach($wards as $ward)
                                     <option value="{{ $ward->name }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                            <span class="text-danger is-invalid ward_err"></span>
                        </div> --}}
                            {{-- 3. Property Details --}}
                            <h5 class="mt-4 mb-3">Property Information / मालमत्तेची माहिती</h5>
                            <div class="col-md-6">
                                <label for="property_type">Property Type / मालमत्तेचा प्रकार<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="property_type" id="property_type" rows="2" placeholder="Enter property type" readonly="" disabled="">{{ $privateinfrastructure->property_type }}</textarea>
                                <span class="text-danger is-invalid property_type_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label for="authorization">Authorization / अधिकृतता<span class="text-danger">*</span></label>
                                <select class="form-select" name="authorization" id="authorization" readonly="" disabled="">
                                    <option value="" disabled>-- Select --</option>
                                    <option value="Yes" {{ $privateinfrastructure->authorization == 'Yes' ? 'selected' : '' }}>Yes / होय</option>
                                    <option value="No" {{ $privateinfrastructure->authorization == 'No' ? 'selected' : '' }}>No / नाही</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div>

                            {{-- 4. Documents --}}
                            <h5 class="mt-4 mb-3">Document Uploads / दस्तऐवज अपलोड करा</h5>
                            <div class="col-md-3">
                                <label class="col-form-label" for="plan_copy">Sanctioned Plan Copy / मंजूर प्लान प्रत<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="plan_copy" id="plan_copy" class="form-control" accept="image/*,.pdf" readonly> --}}
                               @if($privateinfrastructure->plan_copy)
                               <a href="{{ asset('storage/' . $privateinfrastructure->plan_copy) }}" target="_blank" title="View Plan Copy">View Doc</a>
                               @endif

                                {{-- <a id="plantViewFile" target="_blank" title="View Document">View Doc</a> --}}
                                <span class="text-danger is-invalid plan_copy_err"></span>
                              </div>

                        {{-- @if ((Auth::check() && Auth::user()->hasRole('DeputyEngineer')) || Auth::user()->hasRole('JuniorEngineer')) --}}
                            <div class="col-md-3">
                                <label class="col-form-label" for="side_visit_geotag_pic">Site Visit Geotag Photo / साईट व्हिजिट फोटो <span class="text-danger">*</span></label>
                                {{-- <input type="file" name="side_visit_geotag_pic" id="side_visit_geotag_pic" class="form-control" accept="image/*" readonly> --}}
                                @if($privateinfrastructure->side_visit_geotag_pic)
                                <a href="{{ asset('storage/' . $privateinfrastructure->side_visit_geotag_pic) }}" target="_blank" title="side visit geotag pic">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid side_visit_geotag_pic_err"></span>
                            </div>
                        {{-- @endif --}}

                            <div class="col-md-3">
                                <label class="col-form-label" for="property_doc">Property Document / मालमत्तेचे दस्तऐवज<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="property_doc" id="property_doc" class="form-control" accept="image/*,.pdf" readonly> --}}
                                @if($privateinfrastructure->property_doc)
                                <a href="{{ asset('storage/' . $privateinfrastructure->property_doc) }}" target="_blank" title="property_doc">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid property_doc_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="prescribed_doc">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <a href="{{ asset('storage/' . $privateinfrastructure->prescribed_doc) }}" target="_blank" title="property_doc">View Doc</a>
                                        {{-- <input class="form-control" id="prescribed_doc" name="prescribed_doc" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा" required> --}}
                                <span class="text-danger is-invalid prescribed_doc_err"></span>
                            </div>

                             <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" maxlength="255" required></textarea>
                            </div>

                                @php
                            $currentUser = Auth::user();
                        @endphp

                        @if(!$currentUser->hasRole('clerk'))
                            <div>
                                @foreach($approvaldata as $approval)
                                    @if(!is_null($approval->remark))
                                        <div class="mb-3 p-2 border rounded bg-light">
                                            <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                            <p><strong>Approver Time:</strong> {{ $approval->updated_at?? 'N/A' }}</p>

                                            @if($approval->approver_user_id == Auth::user()->id)
                                                <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                            @else
                                            @endif

                                            <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif

                            {{-- 5. Declaration --}}
                            {{-- <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                         <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
