<x-admin.layout>
    <x-slot name="title">Certificate of good condition of air, access roads, and buildings/खेळती हवा, पोहोच रस्ते, व इमारती सुस्थितीत प्रमाणपत्र</x-slot>
    <x-slot name="heading">Certificate of good condition of air, access roads, and buildings/खेळती हवा, पोहोच रस्ते, व इमारती सुस्थितीत प्रमाणपत्र</x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf
                    <div class="card-header">
                        <h4 class="card-title">View Details</h4>
                    </div>
                    <div class="card-body">
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" value="{{ $data->applicant_name }}" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" value="{{ $data->applicant_address }}" type="text" placeholder="Enter Address / पत्ता भरा"  readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" value="{{ $data->mobile_no }}" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" maxlength="10" pattern="\d{10}" title="Please enter exactly 10 digits" required inputmode="numeric" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);"  readonly="" disabled="">
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" value="{{ $data->email_id }}" placeholder="Enter Email ID / ईमेल भरा"  readonly="" disabled="">
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                        </div>

                        {{-- Owner Details --}}
                        <h5 class="text-primary">Owner Details / मालकाची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="owner_name">Name of School / Institute / शाळा / संस्था नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="owner_name" name="owner_name" value="{{ $data->owner_name }}" type="text" placeholder="Enter School/Institute Name / शाळा/संस्थेचे नाव"  readonly="" disabled="">
                                <span class="text-danger is-invalid owner_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="owner_address">School/Institute Address / शाळा/संस्थेचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="owner_address" name="owner_address" value="{{ $data->owner_address }}" type="text" placeholder="Enter Address / पत्ता भरा"  readonly="" disabled="">
                                <span class="text-danger is-invalid owner_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="prabhag_samiti">Prabhag Samiti / प्रभाग समिती<span class="text-danger">*</span></label>
                                <input class="form-control" id="prabhag_samiti" value="{{ $data->prabhag_samiti }}" name="prabhag_samiti" type="text" placeholder="Enter Prabhag Samiti / प्रभाग समिती भरा"  readonly="" disabled="">
                                <span class="text-danger is-invalid prabhag_samiti_err"></span>
                            </div>
                        </div>

                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="cc_oc_certificate">CC and OC Certificate / CC आणि OC प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->cc_oc_certificates)
                                    <a href="{{ asset('storage/' . $data->cc_oc_certificates) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="cc_oc_certificate" name="cc_oc_certificate" type="file" required> --}}
                                <span class="text-danger is-invalid cc_oc_certificate_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="fire_noc">Fire NOC / अग्निशमन प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->fire_nocs)
                                    <a href="{{ asset('storage/' . $data->fire_nocs) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="fire_noc" name="fire_noc" type="file" required> --}}
                                <span class="text-danger is-invalid fire_noc_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="solid_waste_noc">Solid Waste Department NOC / ठोस कचरा विभागाचे प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->solid_waste_nocs)
                                    <a href="{{ asset('storage/' . $data->solid_waste_nocs) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="solid_waste_noc" name="solid_waste_noc" type="file" required> --}}
                                <span class="text-danger is-invalid solid_waste_noc_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="structural_stability_certificate">Structural Stability Certificate / संरचनात्मक स्थिरता प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->structural_stability_certificates)
                                    <a href="{{ asset('storage/' . $data->structural_stability_certificates) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="structural_stability_certificate" name="structural_stability_certificate" type="file" required> --}}
                                <span class="text-danger is-invalid structural_stability_certificate_err"></span>
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="electrical_safety_certificate">Electrical Safety Certificate / विद्युत सुरक्षा प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->electrical_safety_certificates)
                                    <a href="{{ asset('storage/' . $data->electrical_safety_certificates) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="electrical_safety_certificate" name="electrical_safety_certificate" type="file" required> --}}
                                <span class="text-danger is-invalid electrical_safety_certificate_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="water_supply_sewage_noc">Water Supply and Sewage NOC / पाणी पुरवठा आणि मलनिस्सारण प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->water_supply_sewage_nocs)
                                    <a href="{{ asset('storage/' . $data->water_supply_sewage_nocs) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="water_supply_sewage_noc" name="water_supply_sewage_noc" type="file" required> --}}
                                <span class="text-danger is-invalid water_supply_sewage_noc_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="prabhag_office_noc">Prabhag Office NOC / प्रभाग कार्यालय प्रमाणपत्र<span class="text-danger">*</span></label>
                                @if ($data->prabhag_office_nocs)
                                    <a href="{{ asset('storage/' . $data->prabhag_office_nocs) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="prabhag_office_noc" name="prabhag_office_noc" type="file" required> --}}
                                <span class="text-danger is-invalid prabhag_office_noc_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="school_gps_photo">School GPS Photo / शाळेचे GPS फोटो<span class="text-danger">*</span></label>
                                @if ($data->school_gps_photos)
                                    <a href="{{ asset('storage/' . $data->school_gps_photos) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                {{-- <input class="form-control" id="school_gps_photo" name="school_gps_photo" type="file" required> --}}
                                <span class="text-danger is-invalid school_gps_photo_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label class="col-form-label" for="mul_parnaga_pic">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                {{-- <input type="file" name="mul_parnaga_pic" id="mul_parnaga_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($data->upload_prescribeds)
                                 <br>
                                    <a href="{{ asset('storage/' . $data->upload_prescribeds) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid mul_parnaga_pic_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" maxlength="255" rows="4" required></textarea>
                            </div>
                         @php
                            $currentUser = Auth::user();
                        @endphp

                        @if(!$currentUser->hasRole('clerk'))
                            <div>
                                @foreach($approvaldata as $approval)
                                    @if(!is_null($approval->remark))
                                        <div class="mb-3 p-2 border rounded bg-light">
                                            <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                            <p><strong>Approver Time:</strong> {{ $approval->updated_at?? 'N/A' }}</p>

                                            @if($approval->approver_user_id == Auth::user()->id)
                                                <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                            @else
                                            @endif

                                            <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif

                        </div>



                        {{-- Declaration --}}
                        {{-- <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy."
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div> --}}

                    </div>

                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button type="button" id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
