<x-admin.layout>
    <x-slot name="title">PWD Electrical for Vibhagakade Thakbaki Naslyache Pramanpatra/ विभागाकडे थकबाकी नसल्याचे प्रमाणपत्र</x-slot>
    <x-slot name="heading">PWD Electrical for Vibhagakade Thakbaki Naslyache Pramanpatra/ विभागाकडे थकबाकी नसल्याचे प्रमाणपत्र</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">View Details</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" pattern="^[A-Za-zअ-हऀ-ॿ\s]+$" title="Only letters and spaces are allowed. No numbers or special characters." onkeypress="return isLetterOrSpace(event)" value="{{ $vibhagThakbakiNaslyachePramanpatra->applicant_name }}" readonly>

                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा" value="{{ $vibhagThakbakiNaslyachePramanpatra->applicant_address }}" readonly>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" value="{{ $vibhagThakbakiNaslyachePramanpatra->mobile_no }}" readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email ID / ईमेल भरा" value="{{ $vibhagThakbakiNaslyachePramanpatra->email_id }}" readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>

                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र <span class="text-danger">*</span></label>
                                <select name="ward_area" id="ward_area" class="form-select" readonly>
                                    @foreach ($options as $option)
                                        <option {{ $vibhagThakbakiNaslyachePramanpatra->ward_area == $option->id ? 'selected' : '' }} value="{{ $option->id }}">{{ $option->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>

                              <div class="col-md-3">
                                <label for="adhaar_card" class="col-form-label">Upload Adhaar Card<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="adhaar_card" id="adhaar_card" class="form-control" accept="image/*" readonly> --}}
                                @if ($vibhagThakbakiNaslyachePramanpatra->adhaar_cards)
                                    <a href="{{ asset('storage/' . $vibhagThakbakiNaslyachePramanpatra->adhaar_cards) }}" target="_blank" title="side visit geotag pic">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid adhaar_card_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label for="prescribed_doc">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                {{-- <input type="file" name="prescribed_doc" id="prescribed_doc" class="form-control" accept="image/*" readonly> --}}
                                @if ($vibhagThakbakiNaslyachePramanpatra->prescribed_docs)
                                    <a href="{{ asset('storage/' . $vibhagThakbakiNaslyachePramanpatra->prescribed_docs) }}" target="_blank" title="side visit geotag pic">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid prescribed_doc_err"></span>
                            </div>

                             @if (Auth::check() && Auth::user()->hasRole('JuniorEngineer') || Auth::user()->hasRole('ExecutiveEngineer') ||Auth::user()->hasRole('DeputyEngineer'))
                                @if(empty($vibhagThakbakiNaslyachePramanpatra->geotags))
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="geotag">Upload Geo Tag Photo<span class="text-danger">*</span></label>
                                    <span style="color:red;">please upload photo</span>
                                    <input class="form-control" id="geotag" name="geotag" type="file" required>
                                    <span class="text-danger is-invalid geotag_err"></span>
                                </div>
                            @else
                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="geotag">Upload Geo Tag Photo<span class="text-danger">*</span></label>
                                    {{-- <input type="file" name="upload_photo" id="upload_photo" class="form-control" accept="image/*" > --}}
                                    <small><a href="{{ asset('storage/' . $vibhagThakbakiNaslyachePramanpatra->geotags) }}" target="_blank">View Document</a></small>
                                    <span class="text-danger is-invalid geotag_err"></span>
                                </div>
                            @endif
                              @endif

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" maxlength="255"></textarea>
                            </div>

                             @php
                            $currentUser = Auth::user();
                        @endphp

                        @if(!$currentUser->hasRole('clerk'))
                            <div>
                                @foreach($approvaldata as $approval)
                                    @if(!is_null($approval->remark))
                                        <div class="mb-3 p-2 border rounded bg-light">
                                            <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                            <p><strong>Approver Time:</strong> {{ $approval->updated_at?? 'N/A' }}</p>

                                            @if($approval->approver_user_id == Auth::user()->id)
                                                <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                            @else
                                            @endif

                                            <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif
                        </div>



                        {{-- Declaration --}}
                        {{-- <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" checked readonly>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div> --}}

                    </div>

                    {{-- Footer --}}
                    <div class="card-footer">
                         <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button type="button"  id="btnCancel" class="btn btn-warning">Cancel</button>
                         @if (Auth::check() && Auth::user()->hasRole('Clerk') || Auth::user()->hasRole('JuniorEngineer') )
                        <button type="submit" class="btn btn-secondary" id="addSubmit">Update</button>
                    @endif
                    </div>

                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });

    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('vibhag-thakbaki.update', $vibhagThakbakiNaslyachePramanpatra->id) }}';
        formdata.append('_method', 'PUT');
        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated Sucessfully!',
                    text: response.message,
                    confirmButtonText: 'OK'
                }).then(() => {
                    window.location.href = "{{ route('pendinglist') }}";
                });
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>

<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>
