<x-admin.layout>
    <x-slot name="title">Vikas Kamacha Gopniy Dakhla / विकास कामाचा गोपनिय दाखला</x-slot>
    <x-slot name="heading"> Vikas Kamacha Gopniy Dakhla / विकास कामाचा गोपनिय दाखला</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details / माहिती भरा</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" pattern="^[A-Za-zअ-हऀ-ॿ\s]+$" title="Only letters and spaces are allowed. No numbers or special characters." onkeypress="return isLetterOrSpace(event)" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" required>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा" required>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email ID / ईमेल भरा" required>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                        </div>

                        {{-- Owner Details --}}
                        <h5 class="text-primary">Work Details/ कामाची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="company_name">Company Name / कंपनीचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="company_name" name="company_name" type="text" placeholder="Enter Company Name / कंपनीचे नाव" required>
                                <span class="text-danger is-invalid company_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_name"> Work Name / कामाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_name" name="work_name" type="text" placeholder="Enter Work Name /  कामाचे नाव" required>
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Work Order No.">Work Order No. / कामाचा आदेश क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_no" name="work_order_no" type="test" placeholder="Enter Work Order No.. / कामाचा आदेश क्रमांक" required>
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Work Completion Date.">Work Completion Date . / काम पूर्ण झाल्याची तारीख<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completion_date" name="work_completion_date" type="date" placeholder="Work Completion Date.. / काम पूर्ण झाल्याची तारीख" required>
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="ward">Ward Area / प्रभाग क्षेत्र<span class="text-danger">*</span></label>
                                <select class="form-select" name="ward" id="ward" required>
                                    <option value="">Select Ward Area</option>
                                    @foreach ($options as $ward)
                                        <option value="{{ $ward->id }}">{{ $ward->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_err"></span>
                                <div class="selected-value d-none" id="ward"></div>
                            </div>
                        </div>



                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="work_order_docs">Work Order / कामाचा आदेश<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_docs" name="work_order_docs" type="file" placeholder="Enter Work Order / कामाचा आदेश" required>
                                <span class="text-danger is-invalid work_order_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="side_visit_geotag_pics">Work Completion Certificate / काम पूर्णतेचा प्रमाणपत्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completion_docs" name="work_completion_docs" type="file" placeholder="Enter Work Completion Certificate / काम पूर्णतेचा प्रमाणपत्र" required>
                                <span class="text-danger is-invalid work_completion_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="property_docs">To certify the certificates issued by this office/ या कार्यालयातुन निर्गमित केलेले दाखले प्रमाणीत करणे.<span class="text-danger">*</span></label>
                                <input class="form-control" id="nigarmit_docs" name="nigarmit_docs" type="file" placeholder="Enter To certify the certificates issued by this office/ या कार्यालयातुन निर्गमित केलेले दाखले प्रमाणीत करणे" required>
                                <span class="text-danger is-invalid nigarmit_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="company_registration_docs">Company Registration / कंपनीचे नोंदणी<span class="text-danger">*</span></label>
                                <input class="form-control" id="company_registration_docs" name="company_registration_docs" type="file" placeholder="Company Registration / कंपनीचे नोंदणी" required>
                                <span class="text-danger is-invalid company_registration_docs_err"></span>
                            </div>



                            <div class="col-md-6" id="upload_section" style="display:none;">
                                <div class="col-md-3">
                                    <label class="col-form-label" for="prescribed_doc">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="prescribed_doc" name="prescribed_doc" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा" required>
                                    <span class="text-danger is-invalid prescribed_doc_err"></span>
                                </div>
                            </div>


                        </div>

                        {{-- Declaration --}}
                        <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div>

                    </div>

                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit / सादर करा</button>
                        <button type="reset" class="btn btn-warning">Reset / पुन्हा भरा</button>
                    </div>

                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    document.getElementById('saveAndPrintBtn').addEventListener('click', function() {
        document.getElementById('upload_section').style.display = 'block';
        document.getElementById('card-footer').style.display = 'block';

        // var select = document.getElementById('authorization');
        // var selectedDiv = document.getElementById('authorization_selected');
        // if (!selectedDiv) {
        //     selectedDiv = document.createElement('div');
        //     selectedDiv.id = 'authorization_selected';
        //     selectedDiv.className = 'selected-value';
        //     select.parentNode.appendChild(selectedDiv);
        // }
        // var selectedText = select.options[select.selectedIndex] ? select.options[select.selectedIndex].text : '';
        // selectedDiv.textContent = 'Selected: ' + selectedText;
        // selectedDiv.classList.remove('d-none');
        // select.style.display = 'none';

        const addContainer = document.getElementById('addContainer');
        if (!addContainer) return;
        const printContainerClone = addContainer.cloneNode(true);
        printContainerClone.style.fontSize = '16px';
        printContainerClone.style.lineHeight = '1.4';
        printContainerClone.style.padding = '20px';
        printContainerClone.style.margin = '0 auto';
        printContainerClone.style.background = '#fff';
        printContainerClone.style.width = '210mm';
        printContainerClone.style.minHeight = '297mm';
        printContainerClone.style.boxSizing = 'border-box';
        Array.from(printContainerClone.querySelectorAll('*')).forEach(el => {
            el.style.fontSize = '16px';
            el.style.margin = '4px 0';
        });
        const printTitle = document.createElement('h2');
        printTitle.style.textAlign = 'center';
        printTitle.style.marginBottom = '18px';
        printTitle.style.fontSize = '18px';
        printTitle.textContent = 'Vikas Kamacha Gopniy Dakhla';
        printContainerClone.insertBefore(printTitle, printContainerClone.firstChild);
        Array.from(printContainerClone.querySelectorAll('button')).forEach(btn => btn.remove());
        Array.from(printContainerClone.querySelectorAll('.card')).forEach(card => {
            card.style.background = 'white';
            card.style.boxShadow = 'none';
            card.style.border = '1px solid #ccc';
            card.style.marginBottom = '12px';
            card.style.padding = '12px';
        });
        Array.from(printContainerClone.querySelectorAll('input[type="file"]')).forEach(input => {
            const parent = input.parentNode;
            const fileName = input.files && input.files.length > 0 ? input.files[0].name : 'No file chosen';
            const fileInfo = document.createElement('div');
            fileInfo.textContent = 'Selected file: ' + fileName;
            parent.appendChild(fileInfo);
            input.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('select')).forEach(select => {
            const selected = select.options[select.selectedIndex];
            const info = document.createElement('div');
            info.textContent = 'Selected: ' + (selected ? selected.text : '');
            select.parentNode.appendChild(info);
            select.style.display = 'none';
        });

        Array.from(printContainerClone.querySelectorAll('.selected-value')).forEach(div => {
            div.classList.remove('d-none');
        });

        Array.from(printContainerClone.querySelectorAll('input[type="checkbox"]')).forEach(checkbox => {
            const info = document.createElement('div');
            info.textContent = checkbox.checked ? 'Checked' : 'Not checked';
            checkbox.parentNode.appendChild(info);
            checkbox.style.display = 'none';
        });
        let printContainer = document.getElementById('printContainer');
        if (!printContainer) {
            printContainer = document.createElement('div');
            printContainer.id = 'printContainer';
            printContainer.style.position = 'fixed';
            printContainer.style.left = '-9999px';
            document.body.appendChild(printContainer);
        }
        printContainer.innerHTML = '';
        printContainer.appendChild(printContainerClone);
        html2canvas(printContainerClone, {
            scrollY: -window.scrollY,
            backgroundColor: '#fff',
            scale: 1,
            useCORS: true,
            allowTaint: true,
            logging: false
        }).then(canvas => {
            const imgData = canvas.toDataURL('image/jpeg', 0.6);
            const {
                jsPDF
            } = window.jspdf;
            const pdf = new jsPDF('p', 'mm', 'a4');
            const pageWidth = pdf.internal.pageSize.getWidth();
            const pageHeight = pdf.internal.pageSize.getHeight();
            const margin = 10;
            const pdfWidth = pageWidth - margin * 2;
            const pdfHeight = pageHeight - margin * 2;
            pdf.addImage(imgData, 'JPEG', margin, margin, pdfWidth, pdfHeight);
            const pdfBlob = pdf.output('blob');
            if (pdfBlob.size > 2 * 1024 * 1024) {
                alert('Warning: PDF size is greater than 2 MB. Please reduce content or try again.');
            }
            pdf.save('Vikas-Kamacha-Gopniy-Dakhla.pdf');
            document.getElementById('saveAndPrintBtn').style.display = 'none';
        });
    });

    // function updateSelectedValue(selectId) {
    //     var select = document.getElementById(selectId);
    //     var selectedText = select.options[select.selectedIndex] ? select.options[select.selectedIndex].text : '';
    //     var selectedDiv = document.getElementById(selectId + '_selected');
    //     if (!selectedDiv) {
    //         selectedDiv = document.createElement('div');
    //         selectedDiv.id = selectId + '_selected';
    //         selectedDiv.className = 'selected-value';
    //         select.parentNode.appendChild(selectedDiv);
    //     }
    //     selectedDiv.textContent = 'Selected: ' + selectedText;
    //     selectedDiv.classList.remove('d-none');
    // }

    // document.getElementById('authorization').addEventListener('change', function() {
    //     updateSelectedValue('authorization');
    // });

    // updateSelectedValue('authorization');
</script>


{{-- Add --}}
<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('vikas-kamacha-gopniy-dakhla.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>
<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>
