<x-admin.layout>
    <x-slot name="title">PWD Electrical for Vikas Kamacha Gopniy Dakhla / विकास कामाचा गोपनिय दाखला</x-slot>
    <x-slot name="heading">PWD Electrical for Vikas Kamacha Gopniy Dakhla / विकास कामाचा गोपनिय दाखला</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">View Details</h4>
                    </div>

                    <div class="card-body">

                        {{-- Applicant Details --}}
                        <h5 class="text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                        <div class="mb-3 row">
                            <input type="hidden" model-id="id" value="{{ $status->id }}">

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" pattern="^[A-Za-zअ-हऀ-ॿ\s]+$" title="Only letters and spaces are allowed. No numbers or special characters." onkeypress="return isLetterOrSpace(event)" type="text" placeholder="Enter Applicant Name / अर्जदाराचे नाव भरा" value="{{ $vikaskamachagopniydakhala->applicant_name }}" readonly>
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_address" name="applicant_address" type="text" placeholder="Enter Address / पत्ता भरा" value="{{ $vikaskamachagopniydakhala->applicant_address }}" readonly>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" value="{{ $vikaskamachagopniydakhala->mobile_no }}" readonly>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email_id">Email ID / ईमेल आयडी<span class="text-danger">*</span></label>
                                <input class="form-control" id="email_id" name="email_id" type="email" placeholder="Enter Email ID / ईमेल भरा" value="{{ $vikaskamachagopniydakhala->email_id }}" readonly>
                                <span class="text-danger is-invalid email_id_err"></span>
                            </div>
                        </div>

                        {{-- Owner Details --}}
                        <h5 class="text-primary">Work Details/ कामाची माहिती</h5>
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="company_name">Company Name / कंपनीचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="company_name" name="company_name" type="text" placeholder="Enter Company Name / कंपनीचे नाव" value="{{ $vikaskamachagopniydakhala->company_name }}" readonly>
                                <span class="text-danger is-invalid company_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="work_name"> Work Name / कामाचे नाव<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_name" name="work_name" type="text" placeholder="Enter Work Name /  कामाचे नाव" value="{{ $vikaskamachagopniydakhala->work_name }}" readonly>
                                <span class="text-danger is-invalid property_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Work Order No.">Work Order No. / कामाचा आदेश क्रमांक<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_order_no" name="work_order_no" type="text" placeholder="Enter Work Order No.. / कामाचा आदेश क्रमांक" value="{{ $vikaskamachagopniydakhala->work_order_no }}" readonly>
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="Work Completion Date.">Work Completion Date . / काम पूर्ण झाल्याची तारीख<span class="text-danger">*</span></label>
                                <input class="form-control" id="work_completion_date" name="work_completion_date" type="text" placeholder="Work Completion Date.. / काम पूर्ण झाल्याची तारीख" value="{{ $vikaskamachagopniydakhala->work_completion_date }}" readonly>
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div>
                        </div>



                        {{-- Documents --}}
                        <h5 class="text-primary">Documents / कागदपत्रे</h5>
                        <div class="mb-3 row">
                            <div class="col-md-3">
                                <label class="col-form-label" for="work_order_docs">Work Order / कामाचा आदेश<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="work_order_docs" name="work_order_docs" type="file" placeholder="Enter Work Order / कामाचा आदेश" readonly> --}}
                                @if ($vikaskamachagopniydakhala->work_order_doc)
                                    <a href="{{ asset('storage/' . $vikaskamachagopniydakhala->work_order_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid work_order_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="work_completion_docs">Work Completion Certificate / काम पूर्णतेचा प्रमाणपत्र<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="work_completion_docs" name="work_completion_docs" type="file" placeholder="Enter Work Completion Certificate / काम पूर्णतेचा प्रमाणपत्र" readonly> --}}
                                @if ($vikaskamachagopniydakhala->work_completion_doc)
                                    <a href="{{ asset('storage/' . $vikaskamachagopniydakhala->work_completion_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid work_completion_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="property_docs">To certify the certificates issued by this office/ या कार्यालयातुन निर्गमित केलेले दाखले प्रमाणीत करणे.<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="nigarmit_docs" name="nigarmit_docs" type="file" placeholder="Enter To certify the certificates issued by this office/ या कार्यालयातुन निर्गमित केलेले दाखले प्रमाणीत करणे" readonly> --}}
                                @if ($vikaskamachagopniydakhala->nigarmit_doc)
                                    <a href="{{ asset('storage/' . $vikaskamachagopniydakhala->nigarmit_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid nigarmit_docs_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="company_registration_docs">Company Registration / कंपनीचे नोंदणी<span class="text-danger">*</span></label>
                                {{-- <input class="form-control" id="company_registration_docs" name="company_registration_docs" type="file" placeholder="Company Registration / कंपनीचे नोंदणी" readonly> --}}
                                @if ($vikaskamachagopniydakhala->company_registration_doc)
                                    <a href="{{ asset('storage/' . $vikaskamachagopniydakhala->company_registration_doc) }}" target="_blank" title="View Plan Copy">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid company_registration_docs_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" class="form-control" rows="4" required></textarea>
                            </div>

                                @php
                            $currentUser = Auth::user();
                        @endphp

                        @if(!$currentUser->hasRole('clerk'))
                            <div>
                                @foreach($approvaldata as $approval)
                                    @if(!is_null($approval->remark))
                                        <div class="mb-3 p-2 border rounded bg-light">
                                            <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                            <p><strong>Approver Time:</strong> {{ $approval->updated_at?? 'N/A' }}</p>

                                            @if($approval->approver_user_id == Auth::user()->id)
                                                <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                            @else
                                            @endif

                                            <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif


                        </div>

                        {{-- Declaration --}}
                        {{-- <div class="mb-3 row">
                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" checked>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती अचूक आहे व त्यामध्ये कोणतीही चूक आढळल्यास मी पूर्णपणे जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>
                        </div> --}}

                    </div>

                    {{-- Footer --}}
                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel" class="btn btn-warning">Cancel</button>
                    </div>

                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.getElementById('btnCancel').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
</script>
<script>
    $(document).ready(function() {
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark.trim() !== '') {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>

<script>
    function isLetterOrSpace(e) {
        const char = String.fromCharCode(e.which || e.keyCode);
        const regex = /^[A-Za-zअ-हऀ-ॿ\s]+$/;
        return regex.test(char);
    }
</script>
