<x-admin.layout>
    <x-slot name="title">सोलार पॉवर / सोलार वॉटर हिटिंग ना हरकत दाखला / Solar Power / Solar Water Heating No Objection Certificate</x-slot>
    <x-slot name="heading">सोलार पॉवर / सोलार वॉटर हिटिंग ना हरकत दाखला / Solar Power / Solar Water Heating No Objection Certificate</x-slot>

    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Edit Details / माहिती संपादित करा</h4>
                    </div>

                    <div class="card-body">
                        <div class="mb-3 row">

                            {{-- 1. Applicant Details --}}
                            <h5 class="mb-3 text-primary">Applicant Details / अर्जदाराची माहिती</h5>
                            <div class="col-md-4">
                                <label for="applicant_name">Applicant Name / अर्जदाराचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_name" id="applicant_name" class="form-control" placeholder="Enter applicant name" value="{{ $electricmetertransfer->applicant_name }}" readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="applicant_address">Applicant Address / अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="applicant_address" id="applicant_address" class="form-control" placeholder="Enter applicant address" value="{{ $electricmetertransfer->applicant_address }}" readonly="" disabled="">
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="" for="mobile_no"> Mobile Number / मोबाईल नंबर<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" placeholder="Enter Mobile No. / मोबाईल नंबर भरा" readonly="" disabled="" maxlength="10" pattern="\d{10}" title="Please enter exactly 10 digits" required inputmode="numeric" value="{{ old('mobile_no', $electricmetertransfer->mobile_no) }}" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);">
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>



                            <div class="col-md-4 mb-2">
                                <label class="col-form-label" for="ward_area">Ward Area / प्रभाग क्षेत्र <span class="text-danger">*</span></label>
                                <select name="ward_area" id="ward_area" class="form-select" readonly="" disabled="">
                                    @foreach ($wards as $option)
                                        <option {{ $electricmetertransfer->ward_area == $option->id ? 'selected' : '' }} value="{{ $option->id }}">{{ $option->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid ward_area_err"></span>
                            </div>


                            {{-- 2. Owner Details --}}
                            <h5 class="text-primary">Stall Information / स्टॉलची माहिती</h5>
                            {{-- <div class="col-md-4">
                                <label for="company_name">Property Owner Name / मालकाचे नाव<span class="text-danger">*</span></label>
                                <input type="text" name="company_name" id="company_name" class="form-control" placeholder="Enter owner name" value="{{ $completitioncertificate->company_name }}">
                                <span class="text-danger is-invalid company_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="work_name">Property Address / मालमत्तेचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="work_name" id="work_name" class="form-control" placeholder="Enter property address" value="{{ $completitioncertificate->work_name }}">
                                <span class="text-danger is-invalid work_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label for="work_order_no">Work Order No / कार्य आदेश क्रमांक<span class="text-danger">*</span></label>
                                <input type="text" name="work_order_no" id="work_order_no" class="form-control" placeholder="Enter work order number" value="{{ $completitioncertificate->work_order_no }}">
                                <span class="text-danger is-invalid work_order_no_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label for="stall_place">Stall Place/ अर्जदाराचा पत्ता<span class="text-danger">*</span></label>
                                <input type="text" name="stall_place" id="stall_place" class="form-control" placeholder="Enter stall place" value="{{ $electricmetertransfer->stall_place }}" readonly="" disabled="">
                                <span class="text-danger is-invalid stall_place_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label for="stall_type">Stall Type / स्टॉल प्रकार<span class="text-danger">*</span></label>
                                <select class="form-select" name="stall_type" id="stall_type" onchange="showRelevantField()" readonly="" disabled="">
                                    <option value="" disabled>-- Select --</option>
                                    <option value="Divyang Stall / दिव्यांग स्टॉल" {{ $electricmetertransfer->stall_type == 'Divyang Stall / दिव्यांग स्टॉल' ? 'selected' : '' }}>Divyang Stall / दिव्यांग स्टॉल</option>
                                    <option value="Gatai Stall / गटाई स्टॉल" {{ $electricmetertransfer->stall_type == 'Gatai Stall / गटाई स्टॉल' ? 'selected' : '' }}>Gatai Stall / गटाई स्टॉल</option>
                                    <option value="Dudh Kendra / दूध केंद्र" {{ $electricmetertransfer->stall_type == 'Dudh Kendra / दूध केंद्र' ? 'selected' : '' }}>Dudh Kendra / दूध केंद्र</option>
                                    <option value="Other / इतर" {{ $electricmetertransfer->stall_type == 'Other / इतर' ? 'selected' : '' }}>Other / इतर</option>
                                </select>
                                <span class="text-danger is-invalid stall_type_err"></span>
                            </div>


                            <div class="col-md-3">
                                <label for="authorization">Authorization / अधिकृतता<span class="text-danger">*</span></label>
                                <select class="form-select" name="authorization" id="authorization" readonly="" disabled="">
                                    <option value="" disabled>-- Select --</option>
                                    <option value="yes" {{ $electricmetertransfer->authorization == 'yes' ? 'selected' : '' }}>yes</option>
                                    <option value="no" {{ $electricmetertransfer->authorization == 'no' ? 'selected' : '' }}>no</option>
                                </select>
                                <span class="text-danger is-invalid authorization_err"></span>
                            </div>

                            {{-- 4. Document Uploads --}}
                            <h5 class="mt-4 mb-3 text-primary">Document Uploads / दस्तऐवज अपलोड करा</h5>
                            <div class="col-md-3">
                                <label class="col-form-label" for="mul_parnaga_pic">Primary Licensing Department / मूल परवाना विभाग<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="mul_parnaga_pic" id="mul_parnaga_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->mul_parnaga_pic)
                                 <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->mul_parnaga_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid mul_parnaga_pic_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="adhar_card_pic">Aadhaar Card Department / आधार कार्ड विभाग<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="adhar_card_pic" id="adhar_card_pic" class="form-control" accept="image/*"> --}}
                                @if ($electricmetertransfer->adhar_card_pic)
                                 <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->adhar_card_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid adhar_card_pic_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="pic">Picture / छायाचित्र<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="pic" id="pic" class="form-control" accept="image/*,.pdf"> --}}

                                    @if ($electricmetertransfer->pic)
                                        <br>
                                        <a href="{{ asset('storage/' . $electricmetertransfer->pic) }}" target="_blank">View Doc</a>
                                    @endif


                                <span class="text-danger is-invalid pic_err"></span>
                            </div>


                            <div class="col-md-3" id="handicap_pic_div" style="display:none">
                                <label for="handicap_pic">Handicap Photo / दिव्यांग चिन्ह<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="handicap_pic" id="handicap_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->handicap_pic)
                                <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->handicap_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid handicap_pic_err"></span>
                            </div>

                            <div class="col-md-3" id="caste_pic_div" style="display:none">
                                <label for="caste_pic">Caste photo / जात<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="caste_pic" id="caste_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->caste_pic)
                                <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->caste_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid caste_pic_err"></span>
                            </div>

                            <div class="col-md-3" id="milk_center_pic_div" style="display:none">
                                <label for="milk_center_pic">Milk Center Photo / दुध केंद्र<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="milk_center_pic" id="milk_center_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->milk_center_pic)
                                <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->milk_center_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid milk_center_pic_err"></span>
                            </div>

                            <div class="col-md-3" id="gumasta_license_pic_div" style="display:none">
                                <label for="gumasta_license_pic">Gumasta License Photo / गुमास्ता लायसन्स<span class="text-danger">*</span></label>
                                {{-- <input type="file" name="gumasta_license_pic" id="gumasta_license_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->gumasta_license_pic)
                                <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->gumasta_license_pic) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid gumasta_license_pic_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="mul_parnaga_pic">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                {{-- <input type="file" name="mul_parnaga_pic" id="mul_parnaga_pic" class="form-control" accept="image/*,.pdf"> --}}
                                @if ($electricmetertransfer->prescribed_doc)
                                 <br>
                                    <a href="{{ asset('storage/' . $electricmetertransfer->prescribed_doc) }}" target="_blank">View Doc</a>
                                @endif
                                <span class="text-danger is-invalid mul_parnaga_pic_err"></span>
                            </div>

                              <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-4">
 <label for="remark">Remark<span class="text-danger">*</span></label>
                                <textarea id="Remark" name="remark" maxlength="255" class="form-control" rows="4" required></textarea>
                                    </div>
                                </div>

                            </div>

                            @php
                                $currentUser = Auth::user();
                            @endphp

                            @if (!$currentUser->hasRole('clerk'))
                                <div>
                                    @foreach ($approvaldata as $approval)
                                        @if (!is_null($approval->remark))
                                            <div class="mb-3 p-2 border rounded bg-light">
                                                <p><strong>Approver Name:</strong> {{ $approval->approver->name ?? 'N/A' }}</p>
                                                <p><strong>Approver Time:</strong> {{ $approval->updated_at ?? 'N/A' }}</p>

                                                @if ($approval->approver_user_id == Auth::user()->id)
                                                    <p><strong>Matched Auth User:</strong> {{ $name }}</p>
                                                @else
                                                @endif

                                                <p><strong>Remark:</strong> {{ $approval->remark }}</p>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            @endif

                            {{-- 5. Declaration --}}
                            {{-- <div class="col-md-12 mt-4">
                                <label for="is_correct_info">Declaration / घोषणापत्र:</label>
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" checked value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br>
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div> --}}

                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="button" class="btn btn-primary approveBtn" data-id="{{ $status->id }}">Approve</button>
                        <button type="button" class="btn btn-danger rejectBtn" data-id="{{ $status->id }}">Reject</button>
                        <button id="btnCancel1" class="btn btn-warning">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

{{-- AJAX Update Script --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        var updateUrl = '{{ route('solarpower-heater.update', $electricmetertransfer->id) }}';
        formdata.append('_method', 'PUT');

        $.ajax({
            url: updateUrl,
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then(() => window.location.href = '{{ route('my-application') }}');
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(response) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(response.responseJSON.errors);
                },
                500: function() {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occurred!", "Something went wrong, please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });
    });
</script>


<script>
     document.getElementById('btnCancel1').addEventListener('click', function() {
        window.location.href = "{{ route('pendinglist') }}";
    });
    function showRelevantField() {
        const selectedValue = document.getElementById("stall_type").value;

        document.getElementById("handicap_pic_div").style.display = "none";
        document.getElementById("caste_pic_div").style.display = "none";
        document.getElementById("milk_center_pic_div").style.display = "none";
        document.getElementById("gumasta_license_pic_div").style.display = "none";

        if (selectedValue === "Divyang Stall / दिव्यांग स्टॉल") {
            document.getElementById("handicap_pic_div").style.display = "block";
        } else if (selectedValue === "Gatai Stall / गटाई स्टॉल") {
            document.getElementById("caste_pic_div").style.display = "block";
        } else if (selectedValue === "Dudh Kendra / दूध केंद्र") {
            document.getElementById("milk_center_pic_div").style.display = "block";
        } else if (selectedValue === "Other / इतर") {
            document.getElementById("gumasta_license_pic_div").style.display = "block";
        }
    }
</script>
<script>
    $(document).ready(function() {
        showRelevantField();
        $('.approveBtn').on('click', function() {
            let statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark) {
                $.ajax({
                    url: '/approve-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });


    $(document).ready(function() {
        $('.rejectBtn').on('click', function() {
            var statusId = $(this).data('id');
            let remark = $('#Remark').val();

            if (remark !== null && remark.trim() !== '') {
                $.ajax({
                    url: '/reject-item/' + statusId,
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        remark: remark
                    },
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.href = response.redirect_url;
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Error: ' + xhr.responseText,
                            confirmButtonText: 'OK'
                        });
                    }
                });
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning!',
                    text: 'Please Add Remark',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
</script>
