<x-admin.layout>
    <x-slot name="title">Approval Request Hierarchies </x-slot>
    <x-slot name="heading">Approval Request Hierarchies</x-slot>

    @php
            $userAuth =auth()->user();
            $canCreate = $userAuth->can('approval-request-hierarchies.create');
            $canEdit = $userAuth->can('approval-request-hierarchies.edit');
            $canDelete = $userAuth->can('approval-request-hierarchies.delete');
    @endphp

    <!-- Add Form -->

    @include('admin.approval_request.create')


    {{-- Edit Form --}}


    @include('admin.approval_request.edit')

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="">
                                @if($canCreate)
                                <button id="addToTable" class="btn btn-primary">Add <i class="fa fa-plus"></i></button>
                                @endif
                                <button id="btnCancel" class="btn btn-danger" style="display:none;">Cancel</button>
                            </div>
                        </div>
                    </div>
                </div>
               <div class="card-body">
                    <div class="table-responsive">
                        <table id="buttons-datatables" class="table table-bordered nowrap align-middle" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Sr No</th>
                                    <th>Requester Department</th>
                                    <th>Requester Service</th>
                                    <th>Approvers (Department - Designation)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($approval_request_hierarchies as $approval_request_hierarchie)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $approval_request_hierarchie->requesterDepartment->name ?? 'Not Selected' }}
                                        </td>
                                        <td>{{ $approval_request_hierarchie->requestserviceName->service_name ?? 'Not Selected' }}
                                        </td>

                                        {{-- Combined Approver Department & Designation --}}
                                        <td>
                                            @php
                                                $approvers = [
                                                    ['department' => $approval_request_hierarchie->firstApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->firstApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->secondApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->secondApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->thirdApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->thirdApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->fourthApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->fourthApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->fiveApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->fiveApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->sixApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->sixApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->sevenApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->sevenApproverDesignations->name ?? null],
                                                    ['department' => $approval_request_hierarchie->eightApproverDepartment->name ?? null, 'designation' => $approval_request_hierarchie->eightApproverDesignations->name ?? null],
                                                ];
                                                $approvers = array_filter($approvers, fn($a) => $a['department'] || $a['designation']);
                                            @endphp

                                            @if (count($approvers))
                                                <ul class="mb-0 ps-3">
                                                    @foreach ($approvers as $index => $approver)
                                                        <li>
                                                            <strong>Approver {{ $index + 1 }}:</strong>
                                                            <strong>{{ $approver['department'] ?? 'No Department' }}</strong>
                                                            - <em>{{ $approver['designation'] ?? 'No Designation' }}</em>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @else
                                                Not Selected
                                            @endif
                                        </td>

                                        <td>
                                            {{-- <a href="{{ url('approver_check/' . $approval_request_hierarchie->id) }}"
                                                class="btn text-danger px-2 py-1 " title="View Persons">
                                                View Persons
                                            </a> --}}

                                           @if($canEdit)
                                                <button class="edit-element btn text-secondary px-2 py-1" title="Edit"
                                                    data-id="{{ $approval_request_hierarchie->id }}">
                                                    <i data-feather="edit"></i>
                                                </button>
                                            @endif
                                            @if($canDelete)
                                                <button class="btn text-danger rem-element px-2 py-1" title="Delete"
                                                    data-id="{{ $approval_request_hierarchie->id }}">
                                                    <i data-feather="trash-2"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>




</x-admin.layout>






<!-- Delete -->
<script>
    $("#buttons-datatables").on("click", ".rem-element", function(e) {
        e.preventDefault();
        swal({
                title: "Are you sure to delete this Approval Request Hierarchies?",
                icon: "info",
                buttons: ["Cancel", "Confirm"]
            })
            .then((justTransfer) => {
                if (justTransfer) {
                    var model_id = $(this).attr("data-id");
                    var url = "{{ route('approval-request-hierarchies.destroy', ':model_id') }}";

                    $.ajax({
                        url: url.replace(':model_id', model_id),
                        type: 'POST',
                        data: {
                            '_method': "DELETE",
                            '_token': "{{ csrf_token() }}"
                        },
                        success: function(data, textStatus, jqXHR) {
                            if (!data.error && !data.error2) {
                                swal("Success!", data.success, "success")
                                    .then((action) => {
                                        window.location.reload();
                                    });
                            } else {
                                if (data.error) {
                                    swal("Error!", data.error, "error");
                                } else {
                                    swal("Error!", data.error2, "error");
                                }
                            }
                        },
                        error: function(error, jqXHR, textStatus, errorThrown) {
                            swal("Error!", "Something went wrong", "error");
                        },
                    });
                }
            });
    });

    $('#add_service_name').change(function() {
        let serviceName = $('#add_service_name option:selected').text();
        $('#deptServiceId').val(serviceName)
    })


</script>
