<x-admin.layout>
    <style>
        .wrap-text {
    white-space: normal !important;
    word-wrap: break-word;
}
    </style>
    <x-slot name="title">Service Report</x-slot>
    <x-slot name="heading">Service Report</x-slot>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">

                {{-- 🔹 Filter Section --}}
                <div class="card-header">
                    <div class="row align-items-center w-100">
                        <div class="col-md-3">
                            <h4 class="mb-0">Service Reports</h4>
                        </div>

                        <div class="col-md-9">
                            <form action="" method="GET" class="row g-3 justify-content-end align-items-end">

                                {{-- Department Filter --}}
                                <div class="col-md-4">
                                    <label for="department_id" class="form-label fw-semibold">Department</label>
                                    <select name="department_id" id="department_id" class="form-control select2">
                                        <option value="">-- All --</option>
                                        @foreach ($services as $service)
                                            <option value="{{ $service->id }}"
                                                {{ request('department_id') == $service->id ? 'selected' : '' }}>
                                                {{ $service->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                {{-- From Date --}}
                                <div class="col-md-3">
                                    <label for="from_date" class="form-label fw-semibold">From Date</label>
                                    <input type="date" name="from_date" id="from_date" class="form-control"
                                        value="{{ request('from_date') }}">
                                </div>

                                {{-- To Date --}}
                                <div class="col-md-3">
                                    <label for="to_date" class="form-label fw-semibold">To Date</label>
                                    <input type="date" name="to_date" id="to_date" class="form-control"
                                        value="{{ request('to_date') }}">
                                </div>

                                {{-- Buttons --}}
                                <div class="col-md-2 d-flex gap-2">
                                    <button type="submit" class="btn btn-primary w-100">Search</button>
                                    <a href="{{ url()->current() }}" class="btn btn-secondary w-100">Reset</a>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>

                {{-- 🔹 Report Table --}}
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="buttons-datatables" class="table table-bordered table-striped align-middle nowrap"
                            style="width:100%">
                            <thead class="table-light">
                                <tr>
                                    <th>Sr No</th>
                                    <th>Department Name</th>
                                    <th>Service Name</th>
                                    <th>Total Count</th>
                                    <th>Approved</th>
                                    <th>Rejected</th>
                                    <th>Pending</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reportData as $key => $data)
                                @php

                                @endphp
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ @$data['department_name'] }}</td>
                                        <td class="wrap-text">{{ $data['service_name'] }}</td>
                                        <td style="text-align: center">{{ $data['total'] ?? 0 }}</td>
                                        <td style="text-align: center">{{ $data['approved'] ?? 0 }}</td>
                                        <td style="text-align: center">{{ $data['rejected']  ?? 0 }}</td>
                                        <td style="text-align: center">{{ $data['pending']  ?? 0 }}</td>
                                    </tr>
                                @empty
                                    <tr align="center">
                                        <td colspan="7">No Data Found </td>
                                    </tr>
                                @endforelse
                            </tbody>
                            {{-- <tfoot>
                                <tr>
                                    <th>Total:</th>
                                    <th></th>
                                    <th></th>
                                    <th>{{ $grandTotal }}</th>
                                    <th>{{ $totalApproved }}</th>
                                    <th>{{ $totalInProcess }}</th>
                                    <th>{{ $totalRejected }}</th>
                                </tr>
                            </tfoot> --}}
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                // Initialize Select2
                $('#department_id').select2();
            });
        </script>
    @endpush

</x-admin.layout>
