<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Page</title>
    <link rel="shortcut icon" href="{{ asset('admin/images/login3.png') }}">
    <link href="{{ asset('admin/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            background-color: #f0f8ff;
            overflow-x: hidden;
        }

        .bg-img {
            /* background-image: url('{{ asset('admin/images/login/desktop-curve-image.jpg') }}'); */
            background-image: url('{{ asset('admin/images/login/bhiwandi-image.jpg') }}');
            background-repeat: no-repeat;
            background-position: 0%;
            background-size: cover;
            content: "";
            height: 100vh;
        }

        .right-content-div {
            background: #284db2;
            color: #fff;
            padding: 3% 2%;
            text-align: center;
            margin: 0% 10%;
            font-size: 18px;
            font-weight: 800;
            border-radius: 10px;
        }

        .custompadding {
            padding: 5% 10%;
        }

        .form-control {
            padding: 10px;
            border: 1px solid #2b5de4;
        }



        @media only screen and (min-width: 1200px) {
            .bg-img {
                background-position: 1%;
            }
        }

        @media only screen and (max-width: 1999px) {
            .bg-img {
                background-position: 1%;
            }
        }

        @media only screen and (max-width: 1115px) {
            .bg-img {
                background-position: 16%;
            }
        }

        @media only screen and (max-width: 1060px) {
            .bg-img {
                background-position: 24%;
            }
        }

        @media only screen and (max-width: 992px) {
            .bg-img {
                background-position: 30%;
            }
        }

        @media only screen and (max-width: 767px) {
            .bg-img {
                background-image: none;
                background-color: #fff;
                height: auto;
                display: flex: justify-content: center;
            }

            .mobile-view-bgcolor {
                /* background-color: #234cb3; */
            }

            .mobile-view-bgcolor,
            body {
                background-color: #234cb3 !important;
            }

            .form-control {
                padding: 10px;
                background-color: #fff;
                border: 1px solid #fff;
            }

            .form-label,
            .form-check-label {
                color: #fff;
            }

            #loginForm_submit {
                background-color: #fff;
                color: #234cb3;
                font-weight: 900;
                font-size: 18px;
                width: 50% !important;
            }

            .textSignup,p {
                color: #fff !important;
            }
        }
    </style>
    <!--kishori otp code-->
    <style>
        .otp-input {
            width: 2.5rem;
            /* smaller width */
            height: 2.5rem;
            /* smaller height */
            font-size: 1.5rem;
            /* smaller font */
            font-weight: 600;
            border-radius: 0.375rem;
            border: 1px solid #ced4da;
            text-align: center;
            /* horizontal center */
            line-height: 2.5rem;
            /* vertical center */
            padding: 0;
            /* remove default padding */
            box-sizing: border-box;
        }
    </style>
</head>

<body>
    {{-- <section class=""> --}}
        <div class="container-flud">
            <div class="row">
                <div class="bg-img col-lg-6 col-md-6 col-12 d-flex justify-content-center">
                    <img class="d-md-none d-lg-none d-xl-none d-sm-block d-block mt-4" src="{{ asset('admin/images/login/login2.png') }}" style="width: 300px;">
                </div>
                <div class="col-lg-6 col-md-6 col-12 d-md-none d-lg-none d-xl-none d-sm-block d-block mobile-view-bgcolor">
                    <img src="{{ asset('admin/images/login/mobile.png') }}" style="width: 100%" alt="">
                </div>
                <div class="col-lg-6 col-md-6 col-12 mobile-view-bgcolor" style="background-color:#fff;">
                    <div class="d-flex justify-content-center mt-3">
                        <img class="d-md-block d-lg-block d-xl-block d-sm-none d-none" src="{{ asset('admin/images/login/login2.png') }}" style="width: 300px;">
                    </div>
                    <div class="container custompadding">
                        <form id="loginForm">
                            <input type="hidden" id="step" name="step" value="1" />
                            @csrf
                            <div class="mb-3">
                                <label for="username" class="form-label">Username (वापरकर्तानाव)</label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="Enter username">
                                <span class="text-danger is-invalid username_err"></span>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="password-input">Password (पासवर्ड)</label>
                                <div class="position-relative auth-pass-inputgroup mb-3">
                                    <input type="password" class="form-control pe-5 password-input" placeholder="Enter password" id="password" name="password">
                                    <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted password-addon" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                </div>
                                <span class="text-danger is-invalid password_err"></span>
                            </div>



                            <div id="otpSection" style="display:none; margin-top: 20px;">
                                <div style="text-align: right; margin-bottom: 1rem;">
                                    <a href="#" class="text-danger" id="resendOtp">Resend OTP</a>
                                </div>

                                <label class="form-label" for="otp">OTP (ओटीपी)</label>
                                <div class="d-flex gap-2 justify-content-start">
                                    <input type="text" maxlength="1" class="form-control otp-input text-center" id="otp" name="otp[]" autocomplete="off" inputmode="numeric" pattern="[0-9]*" />
                                    <input type="text" maxlength="1" class="form-control otp-input text-center" id="otp" name="otp[]" autocomplete="off" inputmode="numeric" pattern="[0-9]*" />
                                    <input type="text" maxlength="1" class="form-control otp-input text-center" id="otp" name="otp[]" autocomplete="off" inputmode="numeric" pattern="[0-9]*" />
                                    <input type="text" maxlength="1" class="form-control otp-input text-center" id="otp" name="otp[]" autocomplete="off" inputmode="numeric" pattern="[0-9]*" />
                                </div>
                                <span class="text-danger is-invalid otp_err"></span>
                            </div>
                            </br>








                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="" id="remember_me" name="remember_me">
                                <label class="form-check-label" for="remember_me">Remember me</label>
                            </div>

                            <div class="mt-4 text-center">
                                <button class="btn btn-primary w-50" type="submit" id="loginForm_submit">Sign In</button>
                            </div>

                            <div class="mt-4 text-center">
                                <p class="mb-0">Don't have an account ? <a href="{{ route('register') }}" class="fw-semibold text-primary text-decoration-underline textSignup"> Signup </a> </p>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    {{-- </section> --}}

    <script src="{{ asset('admin/js/jquery.min.js') }}" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="{{ asset('admin/js/sweetalert.min.js') }}" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    {{-- <script>
            $("#loginForm").submit(function(e) {
                e.preventDefault();
                $("#loginForm_submit").prop('disabled', true);
                var formdata = new FormData(this);
                $.ajax({
                    url: '{{ route('signin') }}',
                    type: 'POST',
                    data: formdata,
                    contentType: false,
                    processData: false,
                    beforeSend: function()
                    {
                        $('#preloader').css('opacity', '0.5');
                        $('#preloader').css('visibility', 'visible');
                    },
                    success: function(data) {
                        if (!data.error && !data.error2) {
                                window.location.href = '{{ route('dashboard') }}';
                        } else {
                            if (data.error2) {
                                swal("Error!", data.error2, "error");
                                $("#loginForm_submit").prop('disabled', false);
                            } else {
                                $("#loginForm_submit").prop('disabled', false);
                                resetErrors();
                                printErrMsg(data.error);
                            }
                        }
                    },
                    error: function(error) {
                        $("#loginForm_submit").prop('disabled', false);
                    },
                    statusCode: {
                        422: function(responseObject, textStatus, jqXHR) {
                            $("#addSubmit").prop('disabled', false);
                            resetErrors();
                            printErrMsg(responseObject.responseJSON.errors);
                        },
                        500: function(responseObject, textStatus, errorThrown) {
                            $("#addSubmit").prop('disabled', false);
                            swal("Error occured!", "Something went wrong please try again", "error");
                        }
                    },
                    complete: function() {
                        $('#preloader').css('opacity', '0');
                        $('#preloader').css('visibility', 'hidden');
                    },
                });

                function resetErrors() {
                    var form = document.getElementById('loginForm');
                    var data = new FormData(form);
                    for (var [key, value] of data) {
                        console.log(key, value)
                        $('.' + key + '_err').text('');
                        $('#' + key).removeClass('is-invalid');
                        $('#' + key).addClass('is-valid');
                    }
                }

                function printErrMsg(msg) {
                    $.each(msg, function(key, value) {
                        console.log(key);
                        $('.' + key + '_err').text(value);
                        $('#' + key).addClass('is-invalid');
                    });
                }

            });
        </script> --}}

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    {{-- <script>
$(document).ready(function() {
    $('#loginForm').on('submit', function(e) {
        e.preventDefault();


        $('.username_err, .password_err, .otp_err').text('');


        let step = $('#step').val();


        let formData = $(this).serialize();

        $.ajax({
            url: "{{ route('signin') }}",
            method: 'POST',
            data: formData,
            success: function(response) {
                if (response.success && step == '1') {

                    $('#step').val('2');
                    $('#otpSection').show();
                    $('#passwordDiv').hide();
                    $('#loginForm_submit').text('Verify OTP');
                    alert('OTP sent to your registered mobile.');

                    $('.otp-input').first().focus();
                }
                else if (response.success && step == '2') {

                    alert('Login successful!');
                    window.location.href = "{{ route('dashboard') }}";
                }
                else if (response.error) {
                    // Show validation errors
                    $.each(response.error, function(key, val) {
                        $('.' + key + '_err').text(val[0]);
                    });
                    $('#otpSection').hide();
                }
                else if (response.error2) {
                    alert(response.error2);
                }
            },
            error: function() {
                alert('Something went wrong. Please try again.');
            }
        });
    });

    // Resend OTP click handler (optional)
    $('#resendOtp').click(function(e) {
        e.preventDefault();
        alert('Resend OTP functionality is not implemented yet.');

    });
});
</script> --}}

    <script>
        $(document).ready(function() {
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();

                $('.username_err, .password_err, .otp_err').text('');
                let step = $('#step').val();
                let formData = $(this).serialize();

                $.ajax({
                    url: "{{ route('signin') }}",
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success && step == '1') {
                            $('#step').val('2');
                            $('#otpSection').show();
                            $('#passwordDiv').hide();
                            $('#loginForm_submit').text('Verify OTP');

                            Swal.fire({
                                icon: 'success',
                                title: 'OTP Sent',
                                text: 'OTP sent to your registered mobile.',
                                confirmButtonText: 'OK'
                            });

                            $('.otp-input').first().focus();
                        } else if (response.success && step == '2') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Login Successful!',
                                text: 'Redirecting to dashboard...',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                window.location.href = "{{ route('dashboard') }}";
                            });
                        } else if (response.error) {
                            $.each(response.error, function(key, val) {
                                $('.' + key + '_err').text(val[0]);
                            });
                            $('#otpSection').hide();
                        } else if (response.error2) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: response.error2,
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: 'Something went wrong. Please try again.',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            });

            // $('#resendOtp').click(function(e) {
            //     e.preventDefault();
            //     Swal.fire({
            //         icon: 'info',
            //         title: 'Info',
            //         text: 'Resend OTP functionality is not implemented yet.',
            //         confirmButtonText: 'OK'
            //     });
            // });
        });
    </script>

    <!--arrow forward script-->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('.otp-input');
            inputs.forEach((input, idx) => {
                input.addEventListener('input', () => {
                    if (input.value.length === 1 && idx < inputs.length - 1) {
                        inputs[idx + 1].focus();
                    }
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === "Backspace" && input.value === '' && idx > 0) {
                        inputs[idx - 1].focus();
                    }
                });
            });
        });
    </script>

    <!--hide and show script-->
    <script>
        $(document).ready(function() {
            $('#loginForm_submit').click(function() {

                // $('#otpSection').show();
            });


            $('#resendOtp').click(function(e) {
                e.preventDefault();
                //alert('OTP resend');
                //alert('OTP resend request bheji gayi');

            });
        });
    </script>

    <!--resend otp function-->
    <script>
        $('#resendOtp').click(function(e) {
            e.preventDefault();
            let username = $('#loginForm input[name="username"]').val();

            if (!username) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Warning',
                    text: 'Please enter username first',
                    confirmButtonText: 'OK'
                });
                return;
            }

            // Disable the link
            $(this).addClass('disabled').css('pointer-events', 'none').text('Resend in 30s');
            let countdown = 30;
            let interval = setInterval(() => {
                countdown--;
                $('#resendOtp').text('Resend in ' + countdown + 's');
                if (countdown <= 0) {
                    clearInterval(interval);
                    $('#resendOtp').removeClass('disabled').css('pointer-events', 'auto').text('Resend OTP');
                }
            }, 1000);

            $.ajax({
                url: "{{ route('resend.otp') }}",
                method: 'POST',
                data: {
                    username: username,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'OTP Sent',
                            text: 'A new OTP has been sent to your registered mobile.',
                            confirmButtonText: 'OK'
                        });
                        $('.otp-input').first().focus();
                    } else if (response.error2) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: response.error2,
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Something went wrong. Please try again.',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });
    </script>
</body>

</html>
