<div class="app-menu navbar-menu" style="">
    <!-- LOGO -->
    <div class="navbar-brand-box">
        <a href="{{ route('dashboard') }}" class="logo logo-dark">
            <span class="logo-sm">
                <img src="{{ asset('admin/images/logo-light.png') }}" alt="" height="22" />
            </span>
            <span class="logo-lg">
                <img src="{{ asset('admin/images/logo-light.png') }}" alt="" height="26" />
            </span>
        </a>
        <a href="{{ route('dashboard') }}" class="logo logo-light">
            <span class="logo-sm">
                <img src="{{ asset('admin/images/logo-light.png') }}" alt="" height="22" />
            </span>
            <span class="logo-lg">
                <img src="{{ asset('admin/images/logo-light.png') }}" alt="" height="26" />
            </span>
        </a>
        <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
            <i class="fa fa-circle"></i>
        </button>
    </div>

    <div id="scrollbar">
        <div class="container-fluid">
            <div id="two-column-menu"></div>
            <ul class="navbar-nav" id="navbar-nav">

                <li class="menu-title"><span>Menu</span></li>

                {{-- Dashboard --}}
                @can('dashboard.view')
                    <li class="nav-item">
                        <a class="nav-link menu-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                            <i class="fa fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                @endcan

                {{-- User Management --}}

                @canany(['users.view', 'roles.view'])
                    <li class="nav-item">
                        <a class="nav-link menu-link" href="#userManagementDropdown" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="userManagementDropdown">
                            <i class="fa fa-users"></i>
                            <span>User Management</span>
                        </a>
                        <div class="collapse menu-dropdown" id="userManagementDropdown">
                            <ul class="nav nav-sm flex-column">
                                @can('users.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}">Users</a>
                                    </li>
                                @endcan
                                @can('roles.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('roles.index') }}" class="nav-link {{ request()->routeIs('roles.*') ? 'active' : '' }}">Roles</a>
                                    </li>
                                @endcan
                            </ul>
                        </div>
                    </li>
                @endcanany

                {{-- Masters --}}
                @canany(['wards.view', 'fees.view', 'signature.view', 'nature-business.view'])
                    <li class="nav-item">
                        <a class="nav-link menu-link" href="#mastersDropdown" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="mastersDropdown">
                            <i class="fa fa-cogs"></i>
                            <span>Masters</span>
                        </a>
                        <div class="collapse menu-dropdown" id="mastersDropdown">
                            <ul class="nav nav-sm flex-column">
                                @can('wards.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('ward.index') }}" class="nav-link {{ request()->routeIs('ward.*') ? 'active' : '' }}">Ward</a>
                                    </li>
                                @endcan
                                @can('zones.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('zone.index') }}" class="nav-link {{ request()->routeIs('zone.*') ? 'active' : '' }}">Zone</a>
                                    </li>
                                @endcan
                                @can('fees.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('fees.index') }}" class="nav-link {{ request()->routeIs('fees.*') ? 'active' : '' }}">Fees</a>
                                    </li>
                                @endcan
                                @can('signature.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('signature.index') }}" class="nav-link {{ request()->routeIs('signature.*') ? 'active' : '' }}">Signature</a>
                                    </li>
                                @endcan
                                @can('nature-business.view')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('nature-business.index') }}" class="nav-link {{ request()->routeIs('nature-business.*') ? 'active' : '' }}">Nature of Business</a>
                                    </li>
                                @endcan
                            </ul>
                        </div>
                    </li>
                @endcanany

                {{-- Approval Request Hierarchies --}}
                @can('approval-request-hierarchies.view')
                    <li class="nav-item">
                        <a class="nav-link menu-link {{ request()->routeIs('approval-request-hierarchies.*') ? 'active' : '' }}" href="{{ route('approval-request-hierarchies.index') }}">
                            <i class="fa fa-tasks"></i>
                            <span>Approval Request Hierarchies</span>
                        </a>
                    </li>
                @endcan

                {{-- Applications (Pending / Approval / Rejected / My Application) --}}
                {{-- Pending List --}}
                @can('application.pending-list')
                    <li class="nav-item">
                        <a href="{{ route('pendinglist') }}" class="nav-link menu-link {{ request()->routeIs('pendinglist') ? 'active' : '' }}">
                            <i class="fa fa-hourglass-half"></i>
                            <span>Pending List</span>
                        </a>
                    </li>
                @endcan

                {{-- Approval List --}}
                @can('application.approval-list')
                    <li class="nav-item">
                        <a href="{{ route('approvelist') }}" class="nav-link menu-link {{ request()->routeIs('approvelist') ? 'active' : '' }}">
                            <i class="fa fa-check-circle"></i>
                            <span>Approved List</span>
                        </a>
                    </li>
                @endcan

                {{-- Rejected List --}}
                @can('application.rejected-list')
                    <li class="nav-item">
                        <a href="{{ route('rejectedlist') }}" class="nav-link menu-link {{ request()->routeIs('rejectedlist') ? 'active' : '' }}">
                            <i class="fa fa-times-circle"></i>
                            <span>Rejected List</span>
                        </a>
                    </li>
                @endcan

                @can('application.verify_offline_reciept')
                    <li class="nav-item">
                        <a href="{{ route('verify-payment-reciept.index') }}"
                        class="nav-link menu-link {{ request()->routeIs('verify-payment-reciept.*') ? 'active' : '' }}">
                            <i class="fa fa-receipt"></i>
                            <span>Verify Offline Payment Receipts</span>
                        </a>
                    </li>
                @endcan
                {{-- My Application --}}
                @can('application.my-application')
                    <li class="nav-item">
                        <a href="{{ route('my-application') }}" class="nav-link menu-link {{ request()->routeIs('my-application') ? 'active' : '' }}">
                            <i class="fa fa-file-alt"></i>
                            <span>My Application</span>
                        </a>
                    </li>
                @endcan


                @can('mandap-entry.create')
                    <li class="nav-item"> <a class="nav-link menu-link {{ request()->routeIs('trade-noc-mandap.create') ? 'active' : '' }}" href="{{ route('trade-noc-mandap.create') }}"> <i class="fa fa-file-alt"></i> <span>Mandap Data Entry Suit</span> </a> </li>
                @endcan
                {{-- Reports --}}
                @canany(['report.marriage-report', 'report.services-report'])
                    <li class="nav-item">
                        <a class="nav-link menu-link" href="#reportsDropdown" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="reportsDropdown">
                            <i class="fa fa-chart-bar"></i>
                            <span>Reports</span>
                        </a>
                        <div class="collapse menu-dropdown" id="reportsDropdown">
                            <ul class="nav nav-sm flex-column">

                                @can('report.marriage-report')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('marriage-report.marriagereport') }}" class="nav-link {{ request()->routeIs('marriage-report.marriagereport') ? 'active' : '' }}">Marriage Report</a>
                                    </li>
                                @endcan
                                @can('report.services-report')
                                    <li class="nav-item-sub">
                                        <a href="{{ route('all-report') }}" class="nav-link {{ request()->routeIs('all-report') ? 'active' : '' }}">Services Report</a>
                                    </li>
                                @endcan
                            </ul>
                        </div>
                    </li>
                @endcanany



                {{-- User Role Menus --}}
                @if (Auth::user()->hasRole('User'))
                    @can('users.user-profile')
                        <li class="nav-item">
                            <a class="nav-link menu-link {{ request()->routeIs('user.profile') ? 'active' : '' }}" href="{{ route('user.profile') }}">
                                <i class="fa fa-user"></i>
                                <span>My Profile</span>
                            </a>
                        </li>
                    @endcan

                    @can('other.rts-guideline')
                        <li class="nav-item">
                            <a href="javascript:void(0)" class="nav-link menu-link   ">
                                <i class="fa fa-book"></i>
                                <span>RTS Guideline</span>
                            </a>
                        </li>
                    @endcan

                    {{-- Important Link --}}
                    @can('other.important-link')
                        <li class="nav-item">
                            <a href="javascript:void(0)" class="nav-link menu-link  ">
                                <i class="fa fa-link"></i>
                                <span>Important Link</span>
                            </a>
                        </li>
                    @endcan

                    {{-- Contact --}}
                    @can('other.contact')
                        <li class="nav-item">
                            <a href="javascript:void(0)" class="nav-link menu-link  ">
                                <i class="fa fa-phone"></i>
                                <span>Contact</span>
                            </a>
                        </li>
                    @endcan
                @endcanany

                {{-- Track Application (All Users) --}}
                @can('application.track-application')
                    <li class="nav-item">
                        <a class="nav-link menu-link {{ request()->routeIs('track-application.index') ? 'active' : '' }}" href="{{ route('track-application.index') }}">
                            <i class="fa fa-search"></i>
                            <span>Track Application</span>
                        </a>
                    </li>
                @endcan

        </ul>
    </div>
</div>

<div class="sidebar-background"></div>
</div>

<div class="vertical-overlay"></div>
