<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
            /* Ensure borders collapse to a single line */
        }

        th,
        td {
            padding: 8px 12px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            /* Add a light grey background to header */
        }

        /* Border style only for the second table */
        .bordered-table th,
        .bordered-table td {
            border: 1px solid #000;
            /* Adding border to cells */
        }

        .sub-header {
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left;" height="150" width="150">
        <div class="rox">
            <h2>MIRA BHAINDAR MUNICIPAL CORPORATION</h2>
            <p>Indira Gandhi Bhavan, Chattrapati Shivaji Maharaj Marg, Bhayandar(W), Dist -Thane </p>
            <p>Tel Nos. 022-28192828/ 28193028/ 28181183/ 28181353/ 28145985.</p>
            {{-- <h3>( बांधकाम/विद्युत ) विभाग</h3> --}}
             <h3>(PWD/Elect) Department</h3>
        </div>
    </div>

    <hr style="1px solid #000; height:5px; background-color:#000;">
    <h2 style="text-align: center;">Demand Note</h2>
    {{-- <div class="row d-flex">
        <h5>MBMC/PWD/Elect/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/2025-26 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;


        Date:{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}</h5>
    </div> --}}
    <div class="row d-flex justify-content-between align-items-center">
    <h5 class="mb-0">
        MBMC/PWD/Elect/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/2025-26
    </h5>
   
    <h5 class="mb-0">
    Date: {{ $approval_date ? \Carbon\Carbon::parse($approval_date->updated_at)->format('d/m/Y') : 'N/A' }}
   </h5>
</div>
    <br>
    <p>To,<br>
        {{ $data->company_name }}<br>
        {{ $data->applicant_full_address }},<br>

    </p>

    <p style="margin-left:20%;"><strong>Sub :- Trench On : {{ $data->no_of_location }}</strong></p>
    <p style="margin-left:20%;"><strong>Ref:- {{  $data->application_no }} Date :-{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }} </strong></p>

    <br>


    <div class="content">
        <p>Sir, </p>
        <p>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;With reference to your above referred letter, the above mentioned site was visited & your request
            to take trench has been accepted on certain terms & condition and subject to payment of charges as
            calculated and shown in annexure A and B.<br><br>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;You shall make payment within seven days from receipt of this demand note, failing which this
            demand note shall become invalid. On making payment of all charges and taxes, you shall present the
            copy of receipt with the corporation so that necessary permission can be issued to you.<br><br>
            Further, it is to mention that payment of reinstatement charges does not guaranteed the grant of
            permission.
        </p>
        <br>
        <br>
      


    </div>
<br>
<br>
<br>
<br>

 {{-- @php
    $grossTotal = 0;
    $roadTypeCounter = 0;  
@endphp

@foreach ($groupedData as $roadtypeId => $group)
    @php
        $roadTypeCounter++;

        
        $effectiveChamberFee = ($roadTypeCounter == 1) ? $chamberfee : 0;

        $groupTotalChamberFee = 0;
        $groupTotalLength = 0;
        $groupTotalRi = 0;
        $groupTotalCgst = 0;
        $groupTotalSgst = 0;
        $groupTotalLandRent = 0;
        $groupTotalBeforeGst = 0;
        $groupTotalDeposit = 0;
        $groupTotalGst = 0;
        $groupGrandTotal = 0;
    @endphp

    <h3>Road Type: {{ $group['roadtype']->road_type }}</h3>
    <table border="1" width="100%" cellspacing="0" cellpadding="5">
        <thead>
            <tr>
                <th>Sr.No</th>
                <th>Start Point</th>
                <th>End Point</th>
                <th>Length in Mt.DLP</th>
                <th>RM Rate in Rs.</th>
                <th>Multiplication Factor</th>
                <th>RI Charges</th>
                <th>Land Rent</th>
                <th>Chamber Fee</th>
                <th>Security Deposit 10% (Refundable)</th>
                <th>Total RI Charges</th>
                <th>CGST @9%</th>
                <th>SGST @9%</th>
                <th>Total GST</th>
                <th>Grand Total</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($group['items'] as $index => $item)
                @php
                    $length = $item['length'] ?? 0;
                    $ri = $item['ri_charge'] ?? 0;
                    $landrent = $item['landrent'] ?? 0;

                   
                    $totalBeforeGst = $ri + $landrent + $effectiveChamberFee;

                    $cgst = $totalBeforeGst * 0.09;
                    $sgst = $totalBeforeGst * 0.09;
                    $gstTotal = $cgst + $sgst;
                    $deposit = $ri * 0.10;
                    $grandTotal = $totalBeforeGst + $gstTotal + $deposit;

                  
                    $groupTotalLength += $length;
                    $groupTotalRi += $ri;
                    $groupTotalLandRent += $landrent;
                    $groupTotalBeforeGst += $totalBeforeGst;
                    $groupTotalDeposit += $deposit;
                    $groupTotalGst += $gstTotal;
                    $groupGrandTotal += $grandTotal;

                    $groupTotalSgst += $sgst;
                    $groupTotalCgst += $cgst;

                    
                    $groupTotalChamberFee += $effectiveChamberFee;
                @endphp

                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item['startpoint'] }}</td>
                    <td>{{ $item['endpoint'] }}</td>
                    <td>{{ number_format($length) }}</td>
                    <td>{{ number_format($item['rate']) }}</td>
                    <td>{{ $item['year'] }}</td>
                    <td>{{ number_format($ri) }}</td>
                    <td>{{ number_format($landrent) }}</td>

                   
                    <td>{{ number_format($effectiveChamberFee) }}</td>

                    <td>{{ number_format($deposit) }}</td>
                    <td>{{ number_format($totalBeforeGst) }}</td>
                    <td>{{ number_format($cgst) }}</td>
                    <td>{{ number_format($sgst) }}</td>
                    <td>{{ number_format($gstTotal) }}</td>
                    <td>{{ number_format($grandTotal) }}</td>
                </tr>
            @endforeach
        </tbody>

        <tbody>
            <tr>
                <th colspan="3">Total</th>
                <th>{{ number_format($groupTotalLength) }}</th>
                <th></th>
                <th></th>
                <th>{{ number_format($groupTotalRi) }}</th>
                <th>{{ number_format($groupTotalLandRent) }}</th>

                
                <th>{{ number_format($groupTotalChamberFee) }}</th>

                <th>{{ number_format($groupTotalDeposit) }}</th>
                <th>{{ number_format($groupTotalBeforeGst) }}</th>
                <th>{{ number_format($groupTotalCgst) }}</th>
                <th>{{ number_format($groupTotalSgst) }}</th>
                <th>{{ number_format($groupTotalGst) }}</th>
                <th>{{ number_format($groupGrandTotal) }}</th>
            </tr>
        </tbody>
    </table>

    @php
        $grossTotal += $groupGrandTotal;
    @endphp

    <br><br>
@endforeach --}}


@php
    $grossTotal = 0;
    $chamberApplied = false; // ✔ Chamber Fee will be applied only ONCE globally
@endphp

@foreach ($groupedData as $roadtypeId => $group)
    @php
        $groupTotalChamberFee = 0;
        $groupTotalLength = 0;
        $groupTotalRi = 0;
        $groupTotalCgst = 0;
        $groupTotalSgst = 0;
        $groupTotalLandRent = 0;
        $groupTotalBeforeGst = 0;
        $groupTotalDeposit = 0;
        $groupTotalGst = 0;
        $groupGrandTotal = 0;
    @endphp

    <h3>Road Type: {{ $group['roadtype']->road_type }}</h3>

    <table border="1" width="100%" cellspacing="0" cellpadding="5">
        <thead>
            <tr>
                <th>Sr.No</th>
                <th>Start Point</th>
                <th>End Point</th>
                <th>Length in Mt.DLP</th>
                <th>RM Rate in Rs.</th>
                <th>Multiplication Factor</th>
                <th>RI Charges</th>
                <th>Land Rent</th>
                <th>Chamber Fee</th>
                <th>Security Deposit 10% (Refundable)</th>
                <th>Total RI Charges</th>
                <th>CGST @9%</th>
                <th>SGST @9%</th>
                <th>Total GST</th>
                <th>Grand Total</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($group['items'] as $index => $item)
                @php
                    $length = $item['length'] ?? 0;
                    $ri = $item['ri_charge'] ?? 0;
                    $landrent = $item['landrent'] ?? 0;

                    // ✔ Chamber Fee — apply ONLY ONCE globally (first row of first roadtype)
                    if (!$chamberApplied) {
                        $effectiveChamberFee = $chamberfee;
                        $chamberApplied = true;  // prevent from applying again
                    } else {
                        $effectiveChamberFee = 0;
                    }

                    // Normal calculations
                    $totalBeforeGst = $ri + $landrent + $effectiveChamberFee;

                    $cgst = $totalBeforeGst * 0.09;
                    $sgst = $totalBeforeGst * 0.09;
                    $gstTotal = $cgst + $sgst;
                    $deposit = $ri * 0.10;
                    $grandTotal = $totalBeforeGst + $gstTotal + $deposit;

                    // group totals
                    $groupTotalLength += $length;
                    $groupTotalRi += $ri;
                    $groupTotalLandRent += $landrent;
                    $groupTotalBeforeGst += $totalBeforeGst;
                    $groupTotalDeposit += $deposit;
                    $groupTotalGst += $gstTotal;
                    $groupGrandTotal += $grandTotal;

                    $groupTotalSgst += $sgst;
                    $groupTotalCgst += $cgst;

                    // chamber fee group total
                    $groupTotalChamberFee += $effectiveChamberFee;
                @endphp

                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item['startpoint'] }}</td>
                    <td>{{ $item['endpoint'] }}</td>
                    <td>{{ number_format($length) }}</td>
                    <td>{{ number_format($item['rate']) }}</td>
                    <td>{{ $item['year'] }}</td>
                    <td>{{ number_format($ri) }}</td>
                    <td>{{ number_format($landrent) }}</td>

                    {{-- Chamber Fee --}}
                    <td>{{ number_format($effectiveChamberFee) }}</td>

                    <td>{{ number_format($deposit) }}</td>
                    <td>{{ number_format($totalBeforeGst) }}</td>
                    <td>{{ number_format($cgst) }}</td>
                    <td>{{ number_format($sgst) }}</td>
                    <td>{{ number_format($gstTotal) }}</td>
                    <td>{{ number_format($grandTotal) }}</td>
                </tr>
            @endforeach
        </tbody>

        <tbody>
            <tr>
                <th colspan="3">Total</th>
                <th>{{ number_format($groupTotalLength) }}</th>
                <th></th>
                <th></th>
                <th>{{ number_format($groupTotalRi) }}</th>
                <th>{{ number_format($groupTotalLandRent) }}</th>

                {{-- Chamber Fee Total --}}
                <th>{{ number_format($groupTotalChamberFee) }}</th>

                <th>{{ number_format($groupTotalDeposit) }}</th>
                <th>{{ number_format($groupTotalBeforeGst) }}</th>
                <th>{{ number_format($groupTotalCgst) }}</th>
                <th>{{ number_format($groupTotalSgst) }}</th>
                <th>{{ number_format($groupTotalGst) }}</th>
                <th>{{ number_format($groupGrandTotal) }}</th>
            </tr>
        </tbody>
    </table>

    @php
        $grossTotal += $groupGrandTotal;
    @endphp

    <br><br>
@endforeach







<h3 style="text-align:right;">Overall Gross Total: ₹{{ number_format($grossTotal) }}</h3>





    <br><br>
    <div style="float: right">
        <strong><p>&nbsp;&nbsp;&nbsp;Executive Engineer (PWD/Elect)</p>
        <p>Mira Bhainder Municipal Corporation</p></strong>
    </div>
    <br>
<br>
<div>
    <p><b>Note : </b> This is Computer generated demand note signature/stamp not required</p>
</div>
</body>
</html>
