<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Payment Mode</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .payment-box {
            border: 2px solid #007bff;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease-in-out;
        }

        .payment-box:hover {
            background-color: #e9f5ff;
            box-shadow: 0 0 10px rgba(0, 123, 255, 0.3);
        }
    </style>
</head>

<body class="container py-5">
    <h2 class="text-center mb-4">Select Payment Mode</h2>
    <div class="row justify-content-center g-4">
        <div class="col-md-4">
            <div class="payment-box" onclick="submitPaymentForm()">
                <h4>Online Payment</h4>
                <p>Pay using Net Banking, UPI or Card</p>
            </div>
        </div>

        <div class="col-md-4">
            <div class="payment-box" data-bs-toggle="modal" data-bs-target="#offlineModal">
                <h4>Offline Payment</h4>
                <p>Upload receipt if paid manually</p>
            </div>
        </div>
    </div>

    <form method="post" name="customerData" action="{{ route('redirect-payment') }}" id="paymentForm" style="display:none;">
        @csrf
        <input type="hidden" name="serviceid" id="serviceid" value="{{ $serviceId }}"/>
        <input type="hidden" name="id" id="id" value="{{ $id }}"/>
        <input type="text" name="tid" id="tid" />
        <input type="hidden" name="merchant_id" value="{{ config('payment.merchant_id') }}" />
        <input type="hidden" name="order_id" value="{{ $order_id }}" />
        @if ($serviceId == 187)
            <input type="hidden" name="amount" value="{{ $item?->amount ?? '' }}" />
        @else
            <input type="hidden" name="amount" value="{{ $amount ?? '' }}" />
        @endif
        <input type="hidden" name="currency" value="INR" />
        {{-- <input type="hidden" name="redirect_url" value="{{ route('success-payment') }}" /> --}}

        <input type="hidden" name="redirect_url" value="{{ route('success-payment') }}" />

        {{-- <input type="hidden" name="cancel_url" value="{{ route('success-payment') }}" /> --}}
        <input type="hidden" name="cancel_url" value="{{ route('cancel-payment') }}" />

        <input type="hidden" name="language" value="EN"/>
        <input type="hidden" name="billing_name" value="{{ $userdata->name }}" />
        <input type="hidden" name="billing_address" value="Room no 1101, near Railway station Ambad" />
        <input type="hidden" name="billing_city" value="Indore" />
        <input type="hidden" name="billing_state" value="MP" />
        <input type="hidden" name="billing_zip" value="425001" />
        <input type="hidden" name="billing_country" value="India" />
        <input type="hidden" name="billing_tel" value="9876543210" />
        <input type="hidden" name="billing_email" value="{{ $userdata->email }}" />
        <input type="hidden" name="delivery_name" value="Chaplin" />
        <input type="hidden" name="delivery_address" value="room no.701 near bus stand" />
        <input type="hidden" name="delivery_city" value="Hyderabad" />
        <input type="hidden" name="delivery_state" value="Andhra" />
        <input type="hidden" name="delivery_zip" value="425001" />
        <input type="hidden" name="delivery_country" value="India" />
        <input type="hidden" name="delivery_tel" value="9876543210" />
        <input type="hidden" name="merchant_param1" value="additional Info." />
        <input type="hidden" name="merchant_param2" value="additional Info." />
        <input type="hidden" name="merchant_param3" value="additional Info." />
        <input type="hidden" name="merchant_param4" value="additional Info." />
        <input type="hidden" name="merchant_param5" value="additional Info." />
        <input type="hidden" name="promo_code" value="" />
        <input type="hidden" name="customer_identifier" value="" />
    </form>

    <div class="modal fade" id="offlineModal" tabindex="-1" aria-labelledby="offlineModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form id="uploadForm" method="POST" enctype="multipart/form-data" action="{{ route('upload', [$id]) }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="offlineModalLabel">Upload Payment Receipt</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="statusId" id="statusId" value="{{ $id }}">
                        <input type="hidden" name="serviceId" id="serviceId" value="{{ $serviceId }}">
                        <div class="mb-3">
                            <label>Document Upload<span class="text-danger">*</span></label>
                            <input type="file" class="form-control" name="document_upload" required>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        window.onload = function() {
            var d = new Date().getTime();
            document.getElementById("tid").value = d;
        };
    </script>
    <script>
    function submitPaymentForm() {
        document.getElementById('paymentForm').submit();
    }
</script>
    <script>
        $('#uploadForm').on('submit', function(e) {
            e.preventDefault();

            let formData = new FormData(this);
            let statusId = $('#statusId').val();
            let serviceId = $('#serviceId').val();

            $.ajax({
                url: `/upload-document/${statusId}`,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                headers: {
                    'X-CSRF-TOKEN': $('input[name="_token"]').val()
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        window.location.href = response.redirect_url;
                    } else {
                        alert(response.message || 'Upload failed.');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        alert(Object.values(errors).join('\n'));
                    } else {
                        alert('Something went wrong!');
                    }
                }
            });
        });
    </script>

</body>

</html>
