<x-admin.layout>
    <x-slot name="title">On Demand Safai / घर स्वच्छ करणे</x-slot>
    <x-slot name="heading">On Demand Safai / घर स्वच्छ करणे</x-slot>
    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Applicant Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 row">
                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_name">Applicant Name<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_name" name="applicant_name" type="text" placeholder="Enter Applicant Name">
                                <span class="text-danger is-invalid applicant_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_mobile">Applicant Mobile No<span class="text-danger">*</span></label>
                                <input class="form-control" id="applicant_mobile" name="applicant_mobile" type="text" placeholder="Enter Applicant Mobile">
                                <span class="text-danger is-invalid applicant_mobile_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="pin_code">Pin Code<span class="text-danger">*</span></label>
                                <input class="form-control" id="pin_code" name="pin_code" type="text" placeholder="Enter Pin Code">
                                {{-- <textarea class="form-control" name="pin_code" id="pin_code" cols="30" rows="2" placeholder="Enter Address" ></textarea> --}}
                                <span class="text-danger is-invalid pin_code_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email">
                                    Email ID<span class="text-danger">*</span>
                                </label>
                                <input class="form-control" id="email" name="email" type="text" maxlength="10" 
                                    minlength="10" placeholder="Enter Mobile Number" oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                <span class="text-danger is-invalid email_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="applicant_address"> Applicant Address<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="applicant_address" id="applicant_address" cols="30" rows="2" placeholder="Enter Applicant Address" ></textarea>
                                <span class="text-danger is-invalid applicant_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="within_mbmc">
                                    Landmark <span class="text-danger">*</span>
                                </label>
                               
                                <textarea class="form-control" name="within_mbmc" id="landmark" cols="30" rows="2" placeholder="Enter Landmark" ></textarea>
                                <span class="text-danger is-invalid within_mbmc_err"></span>
                            </div>


                             <div class="col-md-4">
                                <label class="col-form-label" for="aadhar">Aadhar Card No<span class="text-danger">*</span></label>
                                <input class="form-control" id="aadhar" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,12)" maxlength="12" name="aadhar" type="email" placeholder="Enter Aadhar Card No" >
                                <span class="text-danger is-invalid aadhar_err"></span>
                            </div>
                            
                            <div class="col-md-4">
                            <label class="col-form-label" for="education_qualification">Ward / Prabhag</label>
                            <select class="form-control" name="ward" id="ward">
                            <option value="">--Select Ward--</option>
                            <option value="1">Ward 1</option>
                            <option value="2">Ward 2</option>
                            <option value="3">Ward 3</option>
                            <option value="4">Ward 4</option>
                            <option value="5">Ward 5</option>
                            <option value="6">Ward 6</option>
                        </select>
                                <span class="text-danger is-invalid ward_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="election_ward">Election Ward / Prabhag</label>
                                <input class="form-control"  type="number" name="election_ward" id="election_ward" min="1" placeholder="Enter Election Ward" max="999"/>
                                <span class="text-danger is-invalid election_ward_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="usage_type">Property Usage Type<span class="text-danger">*</span></label>
                                
                                        <select name="usage_type" id="usage_type" class="form-control">
                                                <option value="">-- Select Usage Type --</option>
                                            
                                            </select>
                                        <span class="text-danger is-invalid usage_type_err"></span>
                            </div>

                            <div class="col-md-4">
                            <label class="col-form-label" for="sub_usage_type">
                               Sub-Usage Type<span class="text-danger">*</span>
                            </label>
                            <select name="sub_usage_type" id="sub_usage_type" class="form-control">
                                <option value="">-- Select Sub-Usage Type --</option>
                            </select>
                            <span class="text-danger is-invalid sub_usage_type_err"></span>
                        </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="wet_mt">Waste Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="wet_mt" id="wet_mt">
                                    <option value="">Select option</option>
                                    <option value="C & D Waste">C & D Waste</option>
                                    <option value="Wet Waste">Wet Waste</option>
                                    <option value="Dry Waste">Dry Waste</option>
                                    <option value="Mix Waste">Mix Waste</option>
                                    <option value="Sanitary Waste">Sanitary Waste</option>
                                    <option value="Bio Hazard Waste">Bio Hazard Waste</option>
                                </select>
                                <span class="text-danger is-invalid wet_mt_err"></span>
                            </div>
                            
                           


                             <div class="col-md-4">
                                <label class="col-form-label" for="have_experience">Vehicle Details as per waste collection <span class="text-danger">*</span></label>
                               <select class="form-select" name="dry_mt" id="dry_mt">
                                    <option value="">-- Select --</option>
                                    <option value="1 Ton">1 Ton</option>
                                    <option value="1.5 Ton">1.5 Ton</option>
                                    <option value="3 Ton">3 Ton</option>
                                </select>
                                <span class="text-danger is-invalid dry_mt_err"></span>
                            </div>


                           


                             <div class="col-md-4">
                                <label class="col-form-label" for="cleaning_type">Cleaning Type<span class="text-danger">*</span></label>
                               <select class="form-select" name="cleaning_type" id="cleaning_type">
                                   <option value="">-- Select --</option>
                                   <option value="dry">Dry</option>
                                   <option value="wet">Wet</option>
                                </select>
                               <span class="text-danger is-invalid cleaning_type_err"></span>
                            </div>


                             <div class="col-md-4">
                                <label class="col-form-label" for="expected_waste">Expected Garbage Waste</label>
                                <input class="form-control" id="expected_waste" name="expected_waste" type="text" placeholder="Enter Expected Waste">
                                <span class="text-danger is-invalid expected_waste_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="requirement">Cleaning Requirement<span class="text-danger">*</span></label>
                                    <select class="form-select" name="requirement" id="requirement">
                                        <option value="">-- Select --</option>
                                        <option value="daily">Daily</option>
                                        <option value="weekly">Weekly</option>
                                        <option value="monthly">Monthly</option>
                                    </select>
                                </select>
                                <span class="text-danger is-invalid requirement_err"></span>
                            </div>



                             <div class="col-md-4">
                                <label class="col-form-label" for="cleaning_date">Cleaning Date</label>
                                <input class="form-control" id="cleaning_date" name="cleaning_date" type="text" placeholder="Enter Cleaning Date" autocomplete="off" placeholder="dd-mm-yyyy" >
                                <span class="text-danger is-invalid cleaning_date_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="cleaning_time">Cleaning Timing Slot</label>
                                <input class="form-control" id="cleaning_time" name="cleaning_time" type="time" placeholder="Enter Cleaning Time">
                                <span class="text-danger is-invalid cleaning_time_err"></span>
                            </div>
                            

                            <div class="col-md-4">
                                <label class="col-form-label" for="upload_receipt">Upload Receipt(Only JPG, JPEG, PNG, PDF | Max 5 MB)<span class="text-danger">*</span></label>
                                <input class="form-control" id="upload_receipt" name="upload_receipt" type="file" >
                                <span class="text-danger is-invalid upload_receipt_err"></span>
                            </div>


                            <div class="col-3 offset-9" id="amount_div" style="display:none;"> 
                                <div class="col-md-4">
                                    <label>Pay Amount:</label>
                                    <input type="text" id="amount" name="amount" readonly>
                                </div>
                            </div>

                            <div class="col-md-4" id="upload_section" style="display:none;">
                                <label class="col-form-label" for="application_documents">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                <input class="form-control" id="application_documents" name="application_documents" type="file" >
                                <span class="text-danger is-invalid application_documents_err"></span>
                            </div>


                          <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes">
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. /
                                        वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार असेन."
                                    </label>
                                </div>
                                <!-- ✅ error message will appear here -->
                            <span class="text-danger is-invalid is_correct_info_err d-block mt-1"></span>
                        </div>
                    </div>
                    </div>
                    
                    <div class="form-group" style="text-align: center;">
                            <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                        </div>
                        <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit</button>
                        <button type="reset" class="btn btn-warning">Reset</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin.layout>

























