<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 15px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
        <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo" style="float:right;margin-top:35px;" height="150" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            <h3>( बांधकाम/विद्युत ) विभाग</h3>
        </div>
    </div>
    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
            <p>जा.क्र. मनपा/साबा/वि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/ 2025-2026
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                दि. <span>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>
    <br>
    <h3 style="text-align: center;">रस्ता खोदाई परवाना देणे</h3>

    <p>प्रति,<br>
        {{ $data->company_name }}<br>
        {{ $data->applicant_full_address }},<br>

    </p>

    <p style="margin-left:20%;"><strong>विषय :</strong> खंदक / रस्ता खोदाई कामास परवानगी देणे बाबत.</p>
    <p style="margin-left:20%;"><strong>संदर्भ :</strong> आपला अर्ज दि.{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y') }}रोजी प्राप्त.</p>

    <br>
    1)सुरुवातीचे ठिकाण:_________<br>

    2)शेवटचे ठिकाणः__________<br>

    3)खंदकाची लांबी:&nbsp;&nbsp;{{ $combinedTotallength}}  &nbsp;मीटर.<br>

    4)काम सुरू होण्याची तारीख :- --/-- /2025<br>

    5)काम पूर्ण होण्याची तारीख :- --/--/2025<br>

    <div class="content">
        <p>वरील मोजमापाप्रमाणे खालील अटींच्या अधीन राहुन परवानगी देण्यात येत आहे :-</p>

        <ul class="points">
            <p style=" margin-left:5%;">1) सदर खोदाई काम सुरु करण्यापुर्वी वाहतुक विभागाची परवानगी घेणे बंधनकारक राहील.</p>
            <p style=" margin-left:5%;">2) महानगरपालिकेकडून परवानगी आदेश मिळाल्याच्या तारखेपासून दोन दिवसांच्या आत परवानगी
                पत्रानुसार खंदकाचे काम सुरू करावे लागेल.</p>
            <p style=" margin-left:5%;">3) खंदक कामाची सुरुवात व काम पूर्ण होण्याची तारीख, खंदकाच्या प्रारंभाचे व शेवटचे ठिकाण,
                खंदकाचे मोजमाप या मध्ये बदल करता येणार नाही.</p>
            <p style=" margin-left:5%;">4) खोदकाम सुरू करण्यापूर्वी सुरक्षेची उपाययोजना करण्यात यावी.</p>
            <p style=" margin-left:5%;">5)सेवा वाहीनी संस्थेने खंदकाच्या सुरुवातीस व शेवटच्या बाजुस फलक लावण्यात यावा, खोदाई
                कामाची लांबी 100 मीटर पेक्षा जास्त असल्यास मधोमध व जंक्शनवर देखिल फलक लावण्यात
                यावा. सदर फलकावर अ) काम करणाऱ्या संस्थेचे नाव ब) काम सुरू होण्याची तारीख क) काम
                पूर्ण होण्याची दिनांक ड) साईट इंजिनिअरचे नांव ई) संपर्क क्रमांक (मोबाईल नं.) फ) गैरसोयीबद्दल
                दिलगीर आहोत, तसेच रस्ता काम झाल्यावर पूर्वी प्रमाणे दुरुस्ती करण्यात येईल असा मजकुर
                लिहिण्यात यावा.</p>
            <p style=" margin-left:5%;">6) कामाच्या ठिकाणी पूरेसे सुरक्षा रक्षक आणि ट्रॅफिक वॉर्डन नेमण्यात यावेत.</p>
            <p style=" margin-left:5%;">7) खंदकाच्या कामात पाण्याचे व्हॉल्व्ह फिटींग व चेंबर असल्यास ते झाकण्यात यावे, जलवाहीनी
                खोदाई केलेली माती त्यामध्ये पडणार नाही.</p>
            <p style=" margin-left:5%;">8) आपल्या पर्यवेक्षकामार्फत कंदकाची स्थिती ,कामाची प्रगती ,रस्त्यावरील वाहने व पादचारी यांच्या वाहतुकीबाबत दैनंदिन अहवाल महानगरपालिकेस सादर करावा लागेल . </p>
            <p style=" margin-left:5%;">9) खंदकाच्या ठिकाणी आवश्यकतेनुसार वाहनांना आणि पादचारी यांना जाण्यासाठी स्टील प्लेट टाकण्यात याव्यात.</p>
            <p style=" margin-left:5%;">10) खंदकाच्या लांबीमध्ये दिशादर्शक चिन्ह लावण्यात यावेत.</p>
            <p style=" margin-left:5%;">11) जर खंदक 100 मीटरपेक्षा जास्त असेल तर फक्त 100 मी. खंदक एकाच वेळी खोदावे आणि
                रहदारी सुरळीत करण्यासाठी आणि वाहतुकीसाठी रस्ता मोकळा करून त्यानंतर पुढील खंदकाचे
                काम करण्यात यावे.
            </p>
            <p style=" margin-left:5%;">12) एकाच खंदकात अनेक सेवावाहीन्या संस्थांना सेवावाहीन्या टाकावयाच्या असल्यास व सर्वांनी
                परवानगी घेतली असल्यास अशा परिस्थितीत एकमेकांशी समन्वय साधून सहकार्य करुन काम
                करावे.
            </p>
            <p style=" margin-left:5%;">13) सर्व खोदकाम केलेली माती माहनगरपालिका अभियंत्यानी मान्यता दिलेल्या ठिकाणी वाहतुक करुन
                टाकण्यात यावी. दररोज माती उचलून रस्ता साफ ठेवणे बंधनकारक राहील.</p>
            <p style=" margin-left:5%;">14) खंदकाचे काम मुख्य रस्त्यावर क्रॉस करण्याचे असल्यास कमीत कमी 300 मीटर व्यासाचे
                एन.पी.2 दर्जाचे दोन हयूम पाईप 1:2:4 काँक्रीट मध्ये इनकेसिंग करुन भविष्यातील सेवे करीता
                टाकण्यात यावे. सदर पाईप मधुन आवश्यकेतेनूसार आपणांस आपल्या वाहीन्या टाकण्याची मूभा
                राहील.
            </p>
            <p style=" margin-left:5%;">15) त्याचबरोबर मनपा नियुक्ती केलेल्या रस्ता दुरुस्ती करणाऱ्या कंत्राटदारास कामाचे आदेश देण्यात
                आलेले असून त्यांच्यामार्फत रस्ता दुरुस्तीचे काम आपले काम संपल्याच्या दिनांकापासुन सुरू
                करण्यात येईल. वरील अट क्र.10 नूसार सदर काम करण्यात येईल.
            </p>
            <p style=" margin-left:5%;">16) काम सुरू असतांना आपल्यामार्फत नेमलेला साईट इंजिनिअर पूर्ण वेळ कामावर हजर असणे
                बंधनकारक राहील.</p>
            <p style=" margin-left:5%;">17) परवानगी मिळाल्यावर आपण त्वरीत इतर सेवावाहीन्या संस्थांशी संपर्क करुन काम करीत
                असल्याची त्यांना माहीती द्यावी व सदर काम सर्व सुविधांसह वेळेत पूर्ण करण्यात यावे.</p>
            <p style=" margin-left:5%;">18) महानगरपालिकेने दिलेल्या परवानगी पेक्षा जास्त मोजमापाचे रस्ता खोदकाम केल्यास आपण
                महानगरपालिकेकडे रस्ता दुरुस्तीसाठी जमा केलेल्या रक्कमेच्या तीन पट इतका दंड आकारण्यात
                येईल.
            </p>
            <p style=" margin-left:5%;">19) कंत्राटदाराच्या दुर्लक्षामुळे काम पूर्ण करण्यास उशीर झाल्यास प्रतिदिन रु.5000/- इतका दंड वसुल
                करण्यात येईल. व लगेचच काम थांबविण्यात येईल.
            </p>
            <p style=" margin-left:5%;">20) खोदलेली माती व इतर साहित्य हे दररोज उचलण्यात यावे. तसेच काम पूर्ण झाल्यानंतर साईट
                पुर्ण साफ करण्यात यावी. सदर कामे न केल्यास व कामकाजाच्या सुरक्षेच्या उपाययोजना केल्या
                नसल्यास तो पर्यंत प्रतीदिन रु.10,000/- दंड वसुल करण्यात येईल.</p>
            <p style=" margin-left:5%;">21)कामाच्या दरम्यान झालेल्या प्रत्येक नुकसानीच्या दुरुस्ती खर्चासाठी जसे जलवाहीनी, पर्जन्य
                जलवाहीनी किंवा कोणतेही सार्वजनिक नुकसान केल्यास रु.20,000/- दंड आकारून परवानगी रद्द
                करण्यात येईल.</p>
            <p style=" margin-left:5%;">22) खंदकाची परवानगी देण्यापूर्वी सुरक्षा अनामत 10% प्रमाणे जमा करावी.
            </p>
            <p style=" margin-left:5%;">23)कोणत्याही परिस्थितीत दिलेल्या परवानगीनुसार आपण खंदक करण्यास असमर्थ असल्यास आपण
                महानगरपालिकेशी संपर्क साधून सदर बाब लक्षात आणून द्यावी अन्यथा सदर कामाकरीता
                भविष्यात तीच परवानगी दिली जाणार नाही. याची नोंद घ्यावी.</p>
            <p style=" margin-left:5%;">24)सिमेंट काँक्रीट मास्टिक अॅसफाल्टच्या पृष्ठभागांमध्ये खंदकाचे काम प्रस्तावित करु नये अथवा
                खंदक करण्यात येऊ नये.
            </p>
            <p style=" margin-left:5%;">25)जिथे जिथे विद्यमान फिनिशिंग पेव्हर ब्लॉक किंवा कलर पेव्हर ब्लॉक असेल तेथे आपण खंदक
                करताना हे ब्लॉक्स फोडू अथवा नुकसान करू नये. सदर ब्लॉक 100% अखंड हटविण्यात येऊन
                पालिका अभियंता यांच्या ताब्यात देण्यात यावेत.</p>
            <p style=" margin-left:5%;">26) परवानगी संदर्भात कोणतीही तक्रार असल्यास किंवा ताब्यात घेतलेल्या जमिनीसंदर्भात वादग्रस्त
                क्षेत्राबाबत किंवा अर्जासोबत दिलेली माहिती चुकीची / खोटी असल्याचे आढळल्यास
                महानगरपालिकेने दिलेली परवानगी रद्द समजण्यात यावी.</p>
            <p style=" margin-left:5%;">27) ज्या ठिकाणी खंदकाचे काम प्रस्तावित आहे, त्या जागेच्या मालकाकडून आवश्यक नाहरकत
                परवानगी घेण्याची जबाबदारी आपली व आपल्या कंपनीची असेल.
            </p>
            <p style=" margin-left:5%;">28) महानगपालिकेच्या ट्रॅचिंग पॉलिसी मार्गदर्शक सूचनांच्या नियमांनुसार सेवावाहीन्या संस्थांनी
                काटेकोरपणे पालन करणे बंधनकारक आहे.
            </p>

        </ul>
    </div>
    <br>
    <br>

    <div class="footer" style="float:right;">
        <p><strong>कार्यकारी अभियंता (साबां/वि)</strong><br>
            मिरा-भाईंदर महानगरपालिका</p>
    </div>
    <br>
    <br>
    <br>
    <p>
        प्रत :-<br>
        1) वरीष्ठ पोलीस निरीक्षक, वाहतुक विभाग, काशिमिरा पोलीस स्टेशन.<br>
        2) पाणीपुरवठा विभाग.<br>
        3) आरोग्य विभाग.<br>
        4) सहायक आयुक्त, प्रभाग समिती क्र. <br>
        5) संबंधित स्वच्छता निरिक्षक.<br>
        6) संबंधित उप/शाखा/कनिष्ठ अभियंता ( बांधकाम/विद्युत )<br>
        7) सिस्टिम अॅनालिस्ट सी.सी.टि.व्ही विभाग<br>
        8) मे. श्री गजानन कन्स्ट्रक्शन कंत्राटदार (रस्ता दुरुस्ती)<br>
        परवानगी मध्ये नमुद रस्ता खोदाई काम झाल्यावर त्वरीत दुरुस्ती करण्यात यावा.<br>
    </p>

</body>

</html>
