<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>नागरिक प्रमाणपत्र</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        /* .sub-header {
            text-align: right;
        } */
        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 15px;
        }

         table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
            padding: 8px;
        }

        .container {
            width: 80%;
            margin: 0 auto;
            font-family: Arial, sans-serif;
            font-size: 16px;
        }

        input[type="text"] {
            border: none;
            /* border-bottom: 1px solid black; */
            width: 100%;
        }

        .text-line {
            display: inline-block;
            border-bottom: 1px solid black;
            min-width: 200px;
        }

        .signature {
            margin-top: 60px;
            text-align: right;
        }

        .date {
            margin-top: 40px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData = file_get_contents(public_path('admin/images/favicon.png'));
            $logoData1 = file_get_contents(public_path('admin/images/RajyabhishekLogo.jpeg'));
            $logoData2 = file_get_contents(public_path('admin/images/13.jpeg'));
            $base64Logo = base64_encode($logoData);
            $base64Logo2 = base64_encode($logoData2);
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base64Logo }}" alt="Logo" height="75" width="75">
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left; margin-top:35px;" height="150" width="150">
        <img src="data:image/png;base64,{{ $base64Logo2 }}" alt="Logo" style="float:right;margin-top:35px;" height="150" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>स्व.इंदिरा गांधी भवन,मुख्य कार्यालय, छत्रपती शिवाजी महाराज मार्ग, भाईंदर (प.),ता.ठाणे-४०११०१</p>
            <p>दूरध्वनी क्र.२८१९२४८</p>
            <h3>जाहिरात विभाग</h3>
        </div>
    </div>
    <hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
            <p>जा.क्र. मनपा/जाहिरात/वि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/2025-2026
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                दि. <span>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>
    <br>
    <h3 style="text-align: center;">नवीन जाहिरात परवाना /आकाशचिन्ह परवाना</h3>



        <p><strong>License No.:</strong> {{ $data->application_no }}</p>
        @php
            use Carbon\Carbon;

            $date = Carbon::parse('31 March 2025');
            $startYear = $date->month >= 4 ? $date->year : $date->year - 1;
            $shortEndYear = substr($startYear + 1, -4);
            $financialYear =  $shortEndYear;
        @endphp


        <p>
            M/s {{ $data->f_name }} Res.  {{  $data->full_address}} <br><br>
            is hereby authorized to erect Sky-sign as detailed below subject to the compliance of provision of the Maharashtra Municipal Corporations (regulating and control the display of sky-signs and advertisement) Rules, 2022 for the period from
            <span ><strong>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</strong></span> to <span ><strong>31 MARCH {{ $financialYear }}</strong></span>
        </p>

        <table style="width: 100%; margin-top: 20px;">
            <tr style="background-color: #d3e3f0;">
                <th>Nature of<br>Sky-sign</th>
                <th>Place of<br>Sky-sign</th>
                <th>Size and Area of<br>Sky-sign</th>
                <th colspan="2">Period of Display</th>
            </tr>
            <tr style="background-color: #d3e3f0;">
                <th colspan="3"></th>
                <th>From</th>
                <th>To</th>
            </tr>
            <tr>
                <td><input type="text" >{{ $data->chowk }}</td>
                <td><input type="text" >{{ $data->full_address }}</td>
                <td><input type="text" >{{ $data->bussiness_hoarding }}</td>
                <td><input type="text" >{{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }}</td>
                <td><input type="text" >31/03/ {{ $financialYear }}</td>
            </tr>
        </table>

        <p style="margin-top: 30px;">
            The Applicant has paid fee of Rs. <span><strong>{{ $totalrate}}</strong></span>
            <em>vide</em> challan No. <span ><strong>{{ @$paymentdata->orderno}}</strong></span> dated <span ><strong>{{ @$paymentdata->created_at ? \Carbon\Carbon::parse(@$paymentdata->created_at)->format('d/m/y') : '' }}</strong></span>
            as per rate prescribed by the Municipal Corporation.
        </p>

        <div class="date">
            <strong>Date:</strong> <span>{{ \Carbon\Carbon::today()->format('d/m/Y') }}</span>
        </div>

        <div class="signature">
            <p><strong>Competent Authority</strong><br>Mira Bhiyandar Municipal Corporation </p>
        </div>
    </div>

   @php
    $url = route('hoarding-permission.hoardingdetails', ['id' => $data->id]);
    @endphp

    <div>
        {!! QrCode::size(150)->generate($url) !!}
        {{-- <p><a href="{{ $url }}" target="_blank">View Hoarding Details</a></p> --}}
    </div>



</body>
</html
