<x-admin.layout>
    <x-slot name="title">Hoarding Permission / होर्डिंग-परवानगी</x-slot>
    <x-slot name="heading">Hoarding Permission /होर्डिंग-परवानगी </x-slot>

    <!-- Add Form -->
    <div class="row" id="addContainer">
        <div class="col-sm-12">
            <div class="card">
                <form class="theme-form" name="addForm" id="addForm" enctype="multipart/form-data">
                    @csrf

                    <div class="card-header">
                        <h4 class="card-title">Add Details</h4>
                    </div>

                    <div class="card-body">

                        <div class="mb-4 row">
                            <div class="alert alert-warning fw-bold" role="alert">
                                Applicant Details
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="f_name">Name Of Applicant<span class="text-danger">*</span></label>
                                <input class="form-control" id="f_name" name="f_name" type="text" placeholder="Enter Applicant Name" required>
                                <span class="text-danger is-invalid f_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="m_name">Name of Agency</label>
                                <input class="form-control" id="m_name" name="m_name" type="text" placeholder="Enter Name Of Agency" required>
                                <span class="text-danger is-invalid m_name_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="hoarding_address">होर्डिंग उभारण्याचे ठिकाण <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="hoarding_address" name="hoarding_address" type="text" placeholder="Enter  Hoarding Place" required></textarea>
                                <span class="text-danger is-invalid hoarding_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="hoardingplace">होर्डिंग लावणेची जागा (खाजगी) <span class="text-danger">*</span></label>
                                <select name="hoardingplace" id="hoardingplace" class="form-select" required>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="इमारतीवर / इमारतीच्या परिसरात">इमारतीवर / इमारतीच्या परिसरात</option>
                                    <option value="मोकळ्या जागेवर">मोकळ्या जागेवर </option>
                                </select>
                                <span class="text-danger is-invalid hoardingplace_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="typeofhoarding">होर्डिंगचा प्रकार <span class="text-danger">*</span></label>
                                <select name="typeofhoarding" id="typeofhoarding" class="form-select"  required>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="प्रकाशित (Lite)">प्रकाशित (Lite)</option>
                                    <option value="अप्रकाशित (Without Lite) ">अप्रकाशित (Without Lite) </option>
                                </select>
                                <span class="text-danger is-invalid typeofhoarding_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="title">Status<span class="text-danger">*</span></label>
                                <select name="title" id="title" class="form-select" required>
                                    <option value="" disabled selected> -- Select -- </option>
                                    <option value="Proprietary firm">Proprietary firm</option>
                                    <option value="Company">Company</option>
                                    <option value="Charitable">Charitable </option>
                                </select>
                                <span class="text-danger is-invalid title_err"></span>
                            </div>


                            {{-- <div class="col-md-3">
                                <label class="col-form-label" for="l_name">Last Name (आडनाव ) <span class="text-danger">*</span></label>
                                <input class="form-control" id="l_name" name="l_name" type="text" placeholder="Enter Last Name" >
                                <span class="text-danger is-invalid l_name_err"></span>
                            </div> --}}


                            <div class="col-md-4">
                                <label class="col-form-label" for="full_address">Address of Applicant/ Agency (अर्जदाराचा / एजेन्सीचा पत्ता)<span class="text-danger">*</span></label>
                                <textarea class="form-control" name="full_address" id="full_address" cols="30" rows="2" placeholder="Enter Applicant Address" required></textarea>
                                <span class="text-danger is-invalid full_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="mobile_no">Mobile Number (मोबाईल नंबर)<span class="text-danger">*</span></label>
                                <input class="form-control" id="mobile_no" name="mobile_no" type="text" oninput="this.value = this.value.replace(/\D/g, '')" maxlength="10" minlength="10" placeholder="Enter Mobile Number" required>
                                <span class="text-danger is-invalid mobile_no_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="email">Email Id (ई - मेल आयडी)</label>
                                <input class="form-control" id="email" name="email" type="email" placeholder="Enter Email" required>
                                <span class="text-danger is-invalid email_err"></span>
                            </div>

                        </div>


                        <div class="mb-4 row">
                            <div class="alert alert-warning fw-bold" role="alert">
                                Site Details of Hoardings
                            </div>



                            <div class="col-md-4">
                                <label class="col-form-label" for="type_hoarding">Medium of advertisements applied for<span class="text-danger">*</span> </label>
                                <select name="type_hoarding" id="type_hoarding" class="form-select" required>
                                    <option value="">Select Advertisement Types</option>
                                    @foreach ($advertisement as $option)
                                        <option value="{{ $option->id }}">{{ $option->item }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid type_hoarding_err"></span>
                            </div>

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="advertisement_place">Place of advertisement (जाहिरातीचे ठिकाण)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="advertisement_place" id="advertisement_place">
                                    <option value="">--Select--</option>
                                    <option value="1">Bhavsingpura Ramabai Chowk </option>
                                    <option value="2"> Bhavsingpura Amen Chowk </option>
                                    <option value="3">Bhavsingpura Ambedkar Chowk </option>
                                    <option value="4"> Opposite Bhavsingpura Municipal School </option>
                                    <option value="5">Behind the Bhavsingpura Sanchi Arch </option>
                                    <option value="6"> Chinar Garden Chowk </option>
                                    <option value="7">Dirt road in front of Vani Complex </option>
                                    <option value="8"> Dirt road in front of Punjabi Bhavan </option>
                                </select>
                                <span class="text-danger is-invalid advertisement_place_err"></span>
                            </div> --}}

                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="zone">Zone / झोन<span class="text-danger">*</span></label>
                                <select class="form-select" name="zone" id="zone" >
                                    <option value="">Select Zone</option>
                                    @foreach ($zones as $zone)
                                        <option value="{{ $zone->name }}">{{ $zone->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger is-invalid zone_err"></span>
                            </div> --}}


                            {{-- <div class="col-md-4">
                                <label class="col-form-label" for="chowk">Nature of advertisement applied </label>
                                <input class="form-control" id="chowk" name="chowk" type="text" placeholder="Nature of advertisement">
                                <span class="text-danger is-invalid chowk_err"></span>
                            </div> --}}

                            <div class="col-md-4">
                                <label class="col-form-label" for="plot_no">Length/In tt/sq.ft <span class="text-danger">*</span></label>
                                <input class="form-control" id="plot_no" name="plot_no" type="number" placeholder="Enter Length" required>
                                <span class="text-danger is-invalid plot_no_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="size_hoarding">Width/In tt/sq.ft <span class="text-danger">*</span></label>
                                <input class="form-control" name="size_hoarding" id="size_hoarding" type="number" placeholder="Enter Width" required>
                                <span class="text-danger is-invalid size_hoarding_err"></span>
                            </div>


                            <div class="col-md-4">
                                <label class="col-form-label" for="bussiness_hoarding">Total Area/In tt/sq.ft <span class="text-danger">*</span></label>
                                <input class="form-control" id="bussiness_hoarding" name="bussiness_hoarding" type="number" placeholder="Enter Total Area" readonly>
                                <span class="text-danger is-invalid bussiness_hoarding_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="format_advertisement">No Of Board<span class="text-danger">*</span> </label>
                                <input class="form-control" name="format_advertisement" type="number" id="format_advertisement" placeholder="Enter No of Board" required>
                                <span class="text-danger is-invalid format_advertisement_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="detail_address">Name of the Landlord / Society:<span class="text-danger">*</span></label>
                                <input class="form-control" id="detail_address" name="detail_address" type="text" placeholder="Enter Name of the Landlord / Society" required>
                                <span class="text-danger is-invalid detail_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="behalf">NOC of the Landlord / Society submitted<span class="text-danger">*</span> </label>
                                <select class="form-select" name="behalf" id="behalf" required>
                                    <option value="">--Select--</option>
                                    <option value="yes">yes</option>
                                    <option value="no">no</option>
                                </select>
                                <span class="text-danger is-invalid behalf_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="land_propertie">गाव नमुना सात (७/१२) उतारा<span class="text-danger">*</span></label>
                                <input class="form-control" id="land_propertie" name="land_propertie" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा" required>
                                <span class="text-danger is-invalid land_propertie_err"></span>
                            </div>
                            <div class="col-md-4">
                                <label class="col-form-label" for="stability_certificate">जागा मालक ना हरकत दाखला<span class="text-danger">*</span></label>
                                <input class="form-control" id="stability_certificate" name="stability_certificate" type="file" placeholder="जागा मालक ना हरकत दाखला" required>
                                <span class="text-danger is-invalid stability_certificate_err"></span>
                            </div>
                            <div class="col-md-3">
                                <label class="col-form-label" for="photograph">दुकाने आस्थापना नोंदणी प्रमाणपत्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="photograph" name="photograph" type="file" placeholder="दुकाने आस्थापना नोंदणी प्रमाणपत्र" required>
                                <span class="text-danger is-invalid photograph_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label class="col-form-label" for="tax_registration">सेवा कर नोंदणी प्रमाणपत्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="tax_registration" name="tax_registration" type="file" placeholder="सेवा कर नोंदणी प्रमाणपत्र" required>
                                <span class="text-danger is-invalid tax_registration_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="agreement_copy">दोन्ही पक्षकार करारनामा प्रत<span class="text-danger">*</span></label>
                                <input class="form-control" id="agreement_copy" name="agreement_copy" type="file" placeholder="दोन्ही पक्षकार करारनामा प्रत" required>
                                <span class="text-danger is-invalid agreement_copy_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="stamppaper">१००/- रु स्टम्प पेपरवर निक्षतीपूर्ती प्रमाणपत्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="stamppaper" name="stamppaper" type="file" placeholder="१००/- रु स्टम्प पेपरवर निक्षतीपूर्ती प्रमाणपत्र" required>
                                <span class="text-danger is-invalid stamppaper_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label class="col-form-label" for="locationphoto">लोकेशन फोटो व नकाशा<span class="text-danger">*</span></label>
                                <input class="form-control" id="locationphoto" name="locationphoto" type="file" placeholder="लोकेशन फोटो व नकाशा" required>
                                <span class="text-danger is-invalid locationphoto_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="trafficnoc">वाहतूक पोलीस NOC<span class="text-danger">*</span></label>
                                <input class="form-control" id="trafficnoc" name="trafficnoc" type="file" placeholder="वाहतूक पोलीस NOC" required>
                                <span class="text-danger is-invalid trafficnoc_err"></span>
                            </div>

                             <div class="col-md-3">
                                <label class="col-form-label" for="layout_certificate">स्ट्रक्चर डिझाईन स्टॅबिलीटी मांडणी व आराखडा प्रमाणपत्र<span class="text-danger">*</span></label>
                                <input class="form-control" id="layout_certificate" name="layout_certificate" type="file" placeholder="स्ट्रक्चर डिझाईन स्टॅबिलीटी मांडणी व आराखडा प्रमाणपत्र" required>
                                <span class="text-danger is-invalid layout_certificate_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="Adhaar_card">आधारकार्ड / पॅनकार्ड<span class="text-danger">*</span></label>
                                <input class="form-control" id="Adhaar_card" name="Adhaar_card" type="file" placeholder="आधारकार्ड / पॅनकार्ड" required>
                                <span class="text-danger is-invalid Adhaar_card_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="plan_certificate">भाडेपट्टी करारनामा<span class="text-danger">*</span></label>
                                <input class="form-control" id="plan_certificate" name="plan_certificate" type="file" placeholder="स्ट्रक्चर डिझाईन स्टॅबिलीटी मांडणी व आराखडा प्रमाणपत्र" required>
                                <span class="text-danger is-invalid plan_certificate_err"></span>
                            </div>

                            <div class="col-md-3">
                                <label class="col-form-label" for="other_doc">इतर कागदपत्रे<span class="text-danger">*</span></label>
                                <input class="form-control" id="other_doc" name="other_doc" type="file" placeholder="स्ट्रक्चर डिझाईन स्टॅबिलीटी मांडणी व आराखडा प्रमाणपत्र" required>
                                <span class="text-danger is-invalid other_doc_err"></span>
                            </div>

                            <div class="col-md-6" id="upload_section" style="display:none;">
                                <div class="col-md-6">
                                    <label class="col-form-label" for="upload_prescribed_formats">Upload Application In Prescribed Format / विहित नमुन्यातील अर्ज अपलोड करा <span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file" placeholder="Enter Document No. / दस्तऐवज क्रमांक भरा" required>
                                    <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                                </div>
                            </div>



                            {{-- <div class="col-md-4" style="margin-top: 20px">
                                <label class="col-form-label" for="structure">Details of structure (संरचनेचा तपशील)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="structure" id="structure" style="margin-top: 20px">
                                    <option value="">--Select--</option>
                                    <option value="Timber/लाकूड">Timber/लाकूड</option>
                                    <option value="Steel/पोलाद"> Steel/पोलाद</option>
                                    <option value="Other/इतर"> Other/इतर</option>

                                </select>
                                <span class="text-danger is-invalid structure_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="open_populated">The location of the sky sign is an open space or a populated area(मालमत्तेचे स्थान)<span class="text-danger">*</span> </label>
                                <select class="form-select" name="open_populated" id="open_populated" style="margin-top: 20px">
                                    <option value="">--Select--</option>
                                    <option value="Open Space/मोकळी जागा">Open Space/मोकळी जागा</option>
                                    <option value="Populated Area/लोकवस्तीचे क्षेत्र">Populated Area/लोकवस्तीचे क्षेत्र</option>
                                </select>
                                <span class="text-danger is-invalid open_populated_err"></span>
                            </div>






                            <div class="col-md-6">
                                <label class="col-form-label" for="detail_property">land on which the structure is to be erected owned by applicant ? Details of property should be provided along with proof(ज्या जमिनीवर संरचना उभारावयाची आहे ती अर्जदाराच्या मालकीची आहे?पुराव्यासहित मालमत्तेचा तपशील द्याव) <span class="text-danger">*</span></label>
                                <input class="form-control" id="detail_property" name="detail_property" type="text" placeholder="Enter" >
                                <span class="text-danger is-invalid detail_property_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="detail_property_images"></label>
                                <input class="form-control" id="detail_property_images" name="detail_property_images" type="file" accept="image/*"  style="margin-top:60px">
                                <span class="text-danger is-invalid detail_property_images_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="postal_address">If the land is owned by a person other than the applicant, the name and postal address of the land owner (जमीन अर्जदाराव्यतिरिक्त अन्य व्यक्तीच्या मालकीची असल्यास, जमीन मालकाचे नाव आणि पोस्टल पत्ता) <span class="text-danger">*</span></label>
                                <input class="form-control" id="postal_address" name="postal_address" type="text" placeholder="Enter" >
                                <span class="text-danger is-invalid postal_address_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="consent_letters">Land owner consent to erect advertisement or how? If so please attach the original consent letter (जमीन मालकाचे संमतीपत्र)<span class="text-danger">*</span></label>
                                <input class="form-control" id="consent_letters" name="consent_letters" type="file" accept="image/*" style="margin-top: 20px">
                                <span class="text-danger is-invalid consent_letters_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="start_date">Advertisement Start Date (जाहिरात सुरू होण्याची तारीख)</label>
                                <input class="form-control" id="start_date" name="start_date" type="date"  style="margin-top: 60px">
                                <span class="text-danger is-invalid start_date_err"></span>
                            </div>

                            <div class="col-md-4">
                                <label class="col-form-label" for="end_date">Advertisement End Date (जाहिरात समाप्ती तारीख)</label>
                                <input class="form-control" id="end_date" name="end_date" type="date" >
                                <span class="text-danger is-invalid end_date_err"></span>
                            </div>

                        </div>
                        <div class="mb-4 row">
                            <div class="mb-4 row">
                                <div class="alert alert-warning fw-bold" role="alert">
                                    Documents Attachment List
                                </div>

                                <div class="alert alert-info fw-bold" role="alert">
                                    Note:(टीप) Upload Below Files only pdf, .jpg, .jpeg, .bmp Max upto 5MB. ( खाली फक्त pdf, .jpg, .jpeg, .bmp इत्यादी फाइल अपलोड करा. कमाल 5MB पर्यंत.)
                                </div>

                                <div class="col-md-6 mb-2">
                                    <label class="col-form-label" for="upload_prescribed_formats">No Objection from Home/Building/Place owner ( Bond Paper of Rs. 500/-) (घर / इमारत / जागा मालकाचे रु.500/- च्या मुद्रांक शुल्क वर नाहरकत)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="upload_prescribed_formats" name="upload_prescribed_formats" type="file"  style="margin-top:20px">
                                    <span class="text-danger is-invalid upload_prescribed_formats_err"></span>
                                </div>

                                <div class="col-md-6 mb-2">
                                    <label class="col-form-label" for="aadhar_pans">Building Permission/Completion Certificate/Standing Commitee (As per Subject no 107) Affadavit for relaxation (बांधकाम परवाना प्रमाणपत्र किंवा मा. स्थायी समिती क्र. 107 नुसार शिथीलताचे शपथपत्र)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="aadhar_pans" name="aadhar_pans" type="file" >
                                    <span class="text-danger is-invalid aadhar_pans_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="ownership">Existing Property Tax Paid Receipt (कर भरणा पावती)<span class="text-danger">*</span></label>
                                    <input class="form-control" id="ownership" name="ownership" type="file"  style="margin-top: 20px">
                                    <span class="text-danger is-invalid ownership_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="water_bills">Certificate from Structural Engineer (संरचना अभियंता चे प्रमाणपत्र) </label>
                                    <input class="form-control" id="water_bills" name="water_bills" type="file">
                                    <span class="text-danger is-invalid water_bills_err"></span>
                                </div>


                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="society">Certificate of Structural Engineer(संरचना अभियंताचे संकल्प चित्र)</label>
                                    <input class="form-control" id="society" name="society" type="file">
                                    <span class="text-danger is-invalid society_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="place">Sightseeing Map (पाहणी स्थळ नकाशा ) <span class="text-danger">*</span></label></label>
                                    <input class="form-control" id="place" name="place" type="file"  style="margin-top: 20px">
                                    <span class="text-danger is-invalid place_err"></span>
                                </div>

                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="property">Drawing Provided by Structural Engineer (संरचना अभियंता द्वारे प्रदान केलेले रेखाचित्र)<span class="text-danger">*</span></label></label>
                                    <input class="form-control" id="property" name="property" type="file" >
                                    <span class="text-danger is-invalid property_err"></span>
                                </div>


                                <div class="col-md-4 mb-2">
                                    <label class="col-form-label" for="tenancy">7/12 Or PR Card (7/12 किंवा पी.आर.कार्ड)*<span class="text-danger">*</span></label></label>
                                    <input class="form-control" id="tenancy" name="tenancy" type="file"  style="margin-top: 20px">
                                    <span class="text-danger is-invalid tenancy_err"></span>
                                </div> --}}


                            <label class="col-form-label" for="is_correct_info">Declaration / घोषणापत्र:</label>
                            <div class="col-md-12">
                                <div class="form-check d-flex align-items-start">
                                    <input type="checkbox" class="form-check-input mt-1" id="is_correct_info" name="is_correct_info" value="yes" required>
                                    <label class="form-check-label ms-2" for="is_correct_info">
                                        "All information provided above is correct and I shall be fully responsible for any discrepancy. <br> वरील पुरविलेली सर्व माहिती ही अचूक असून, त्यात कुठल्याही प्रकारची तफावत आढळल्यास त्यास मी पूर्णतः जबाबदार
                                        असेन."
                                    </label>
                                </div>
                                <span class="text-danger is-invalid is_correct_info_err"></span>
                            </div>

                        </div>
                    </div>
                    <div class="form-group" style="text-align: center;">
                        <button type="button" id="saveAndPrintBtn" class="btn btn-success">Save and Print</button>
                    </div>
                    <div class="card-footer" id="card-footer" style="display:none;">
                        <button type="submit" class="btn btn-primary" id="addSubmit">Submit / सादर करा</button>
                        <button type="reset" class="btn btn-warning">Reset / पुन्हा भरा</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</x-admin.layout>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="{{ asset('admin/js/save_print.js') }}"></script>


{{-- Add --}}

<script>
    function updateTotalArea() {
        let length = parseFloat(document.getElementById("plot_no").value) || 0;
        let width = parseFloat(document.getElementById("size_hoarding").value) || 0;

        let noOfBoard = parseFloat(document.getElementById("format_advertisement").value) || 0;

        let totalArea = length * width; // Simple Area

        const totalAreaInput = document.getElementById("bussiness_hoarding");
        if (totalAreaInput) {
             totalAreaInput.value = totalArea > 0 ? totalArea.toFixed(2) : '';
        }
    }

    // 2. Attach the event listeners after the document is loaded
    document.addEventListener("DOMContentLoaded", function() {
        const lengthInput = document.getElementById("plot_no");
        const widthInput = document.getElementById("size_hoarding");
        const boardCountInput = document.getElementById("format_advertisement");

        if (lengthInput) {
            lengthInput.addEventListener("input", updateTotalArea);
        }
        if (widthInput) {
            widthInput.addEventListener("input", updateTotalArea);
        }
        if (boardCountInput) {
            boardCountInput.addEventListener("input", updateTotalArea);
        }

        updateTotalArea();
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    attachGlobalValidation('#addForm', '#saveAndPrintBtn', {
        containerId: 'addContainer',
        printTitle: 'Hording-permission',
    });
});
</script>
<script>
function displayFileName(input) {
    const fileNameDisplay = document.getElementById(input.id.replace('_pics', '_file_name'));
    if (input.files.length > 0) {
        // .name property only provides the file name, not the path
        fileNameDisplay.textContent = 'Selected: ' + input.files[0].name;
        fileNameDisplay.style.color = 'green';
    } else {
        fileNameDisplay.textContent = 'No file selected';
        fileNameDisplay.style.color = 'gray';
    }
}
</script>

<script>
    $("#addForm").submit(function(e) {
        e.preventDefault();
        $("#addSubmit").prop('disabled', true);

        var formdata = new FormData(this);
        $.ajax({
            url: '{{ route('hoarding-permission.store') }}',
            type: 'POST',
            data: formdata,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#preloader').css('opacity', '0.5');
                $('#preloader').css('visibility', 'visible');
            },
            success: function(data) {
                $("#addSubmit").prop('disabled', false);
                if (!data.error)
                    swal("Successful!", data.success, "success")
                    .then((action) => {
                        window.location.href = '{{ route('my-application') }}';
                    });
                else
                    swal("Error!", data.error, "error");
            },
            statusCode: {
                422: function(responseObject, textStatus, jqXHR) {
                    $("#addSubmit").prop('disabled', false);
                    resetErrors();
                    printErrMsg(responseObject.responseJSON.errors);
                },
                500: function(responseObject, textStatus, errorThrown) {
                    $("#addSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                }
            },
            complete: function() {
                $('#preloader').css('opacity', '0');
                $('#preloader').css('visibility', 'hidden');
            },
        });

    });
</script>

