<?php
if (!function_exists('convertToMarathiNumber'))
{
    function convertToMarathiNumber($number)
    {
        $marathiDigits = ['०', '१', '२', '३', '४', '५', '६', '७', '८', '९'];
        $numberStr     = (string) $number;
        $marathiNumber = '';

        for ($i = 0; $i < mb_strlen($numberStr); $i++)
        {
            $digit = $numberStr[$i];
            if (is_numeric($digit))
            {
                $marathiNumber .= $marathiDigits[$digit];
            }
            else
            {
                $marathiNumber .= $digit;
            }
        }

        return $marathiNumber;
    }


}
?>


<!DOCTYPE html>
<html lang="mr">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>
    <style>
        body {
            font-family: 'Mangal', Devanagari, serif;
            padding: 30px;
        }

        .header,
        .footer {
            text-align: center;
        }

        .content {
            margin-top: 30px;
        }

        .line {
            border-bottom: 1px solid #000;
            display: inline-block;
            min-width: 100px;
        }

        .points {
            margin-top: 20px;
        }

        .points li {
            margin-bottom: 10px;
            margin-left: 5%;
        }

        p {
            font-size: 18px;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 8px 12px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .bordered-table th,
        .bordered-table td {
            border: 1px solid #000;
            /* Adding border to cells */
        }

        .sub-header {
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left;" height="150" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>शुभम आर्केड, पहिला माळा, डी-मार्ट परिसर</p>
            <p>M.I.R.A.हॉस्पिटलच्या पुढे, भाईंदर (प.) जि.ठाणे ४०११०१</p>
            <h3>जाहिरात विभाग</h3>
        </div>
    </div>
<hr>
    <hr style="1px solid #000; height:5px; background-color:#000;">
    <div class="sub-header">
        <div class="row d-flex">
            <p>जा.क्र. मनपा/जाहिरात/वि/{{ str_pad($data->id, 4, '0', STR_PAD_LEFT) }}/2025-26
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                दि. <span>{{ \Carbon\Carbon::parse($data->created_at)->format('d/m') }}</span> / <span>{{ \Carbon\Carbon::parse($data->created_at)->format('Y') }}</span></p>
        </div>
    </div>
    <br>
    <h2 style="text-align: center;">Demand Note</h2>
    <p>प्रति,<br>
       {{  $data->f_name}},<br>
       {{ $data->full_address}}<br>

    <br>


    <p style="margin-left:10%;"> विषय :- उभारण्यात आलेल्या जाहिरात होर्डिंग नुतनीकरणाबाबत. </p><br>
    <p style="margin-left:10%;"> संदर्भ :-<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;१) महाराष्ट्र महानगरपालिका (आकाशचिन्हे (स्काय-साईन) व जाहिरात प्रदर्शित करण्याचे
        नियमन आणि  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; नियंत्रण) नियम, २०२२ दि.०९/०५/२०२२<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;२) मा.उच्च न्यायालयाचे रिट याचिका क्र. ८८७१/२०२३ मधील दि. १९/०७/२०२४ रोजीचे
        आदेश<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;३) आपले दि.  {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/y') }} रोजीचे पत्र. अर्ज क्रमांक {{  $data->application_no}}.</p><br>
    <br>

    <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; वरील संदर्भिय विषयान्वये आपणांस कळविण्यात येते की.. मा. उच्च न्यायालयात दाखल WP No.
        ८८७१/२०२३ मध्ये दि.१९/०७/२०२४ मा.उच्च न्यायालयाने दिलेल्या निर्देशानुसार महाराष्ट्र महानगरपालिका (आकाशचिन्हे
        (स्काय-साईन) व जाहिरात प्रदर्शित करण्याचे नियमन आणि नियंत्रण) नियम, २०२२ नुसार भुमापन क्र.{{ $data->chowk  }} यंथोल {{ $data->detail_address }} यांच्या मालकी हक्काच्या खाजगी
        जागेत उभारण्यात आलेले होडींगचे आकारमान कमी करुन {{ convertToMarathiNumber($length)}} X {{ convertToMarathiNumber($width) }} = {{ convertToMarathiNumber($area) }} चौ. फुट आकारमानाचे  १ नग याप्रभाणे होडींग उभारण्यात आलेली असल्याबाबत आपण संदर्भ क्र.३ च्या पत्रान्वये
        कळविले आहे. तसेच आपण सदर होर्डिंगसाठी परवानगी अपेक्षिलेली आहे.
    <p>

    <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; तथापी महाराष्ट्र महानगरपालिका (आकाशचिन्हे (स्काय-साईन) व जाहिरात प्रदर्शित करण्याचे नियमन
        आणि नियंत्रण) नियम, २०२२ अधिनियमातील कलम २३ मधील तरतुदी नुसार जाहिरातीच्या परवान्याचे नुतनीकरण
        करणेकरिता अर्जाबरोबर पुढील दस्ताऐवज जोडण्यात यावेत.</p>
    <p style="margin-left:10%;">१) मिळकतीच्या/जमिनीच्या मालकाचे ना- हरकत प्रमाणपत्र,</p>
    <p style="margin-left:10%;">२) कोणत्याही लायसन प्राप्त संरचना अभियंत्याचे संरचना मजबुतीचे (स्थिरतेचे) प्रमाणपत्र</p>
    <p style="margin-left:10%;">३) जाहिरात फलकाच्या छायाचित्राच्या दोन प्रती</p><br>

    <br>
    <br>
    <br>
    <br>
    <br>
    <br>
    <br>
    <br>
    <br> <br>
    <br> <br>


    <div class="header">
        @php
            $logoData1 = file_get_contents(public_path('admin/images/favicon.png'));
            $base641Logo = base64_encode($logoData1);
        @endphp
        <img src="data:image/png;base64,{{ $base641Logo }}" alt="Logo" style="float:left;" height="150" width="150">
        <div class="rox">
            <h2>मिरा भाईंदर महानगरपालिका</h2>
            <p>शुभम आर्केड, पहिला माळा, डी-मार्ट परिसर</p>
            <p>M.I.R.A.हॉस्पिटलच्या पुढे, भाईंदर (प.) जि.ठाणे ४०११०१</p>
            <h3>जाहिरात विभाग</h3>
        </div>
    </div>

    <hr style="1px solid #000; height:5px; background-color:#000;">
    <h2 style="text-align: center;">Demand Note</h2><br>
    <p>मा. प्रशासकिय ठगव क्र.२८२ दि.०२/०३/२०७३ मधील नमुद मंजूर दरानुसार {{ $length}} X {{ $width }} = {{ $area }} चौ. फुट
        आकारमानाचे १ नग याप्रमाणे एकूण आकारमान {{ $bannerrate }} होणाऱ्या जाहिरात की चा आगाऊ स्वरुपात भरणा करणे बंधनकारक आहे.</p>
    <br>
    <table>
        <thead>
            <tr>
                <th>अनुक्रमांक</th>
                <th>कालावधी</th>
                <th>जाहिरात फी रक्कम ₹</th>
            </tr>
        </thead>
        <tbody>
            <tr>

               <!-- @endphp-->
                <td>१</td>
                {{-- <td>प्रथम अर्धवार्षिक रक्कम<br>दि.{{ \Carbon\Carbon::parse($data->created_at)->addDay()->format('d/m/Y') }} ते दि.{{ \Carbon\Carbon::parse($data->created_at)->addDay()->endOfMonth()->format('d/m/Y') }} --}}
                    <td>प्रथम अर्धवार्षिक रक्कम<br>
                <td>{{  $sumrate }}</td>
            </tr>
            

             <tr>

               <!-- @endphp-->
                <td>2</td>
                {{-- <td>प्रथम अर्धवार्षिक रक्कम<br>दि.{{ \Carbon\Carbon::parse($data->created_at)->addDay()->format('d/m/Y') }} ते दि.{{ \Carbon\Carbon::parse($data->created_at)->addDay()->endOfMonth()->format('d/m/Y') }} --}}
                    <td>अनामत रक्कम<br>
                <td>{{$anamat}}</td>
            </tr>

            {{-- <tr>
                <td>3</td>
                <td>द्वितीय अर्धवार्षिक रक्कम<br>दि.{{ \Carbon\Carbon::parse($data->created_at)->addMonths(2)->startOfMonth()->format('d/m/Y') }} ते दि.{{ \Carbon\Carbon::parse($data->created_at)->addMonths(5)->endOfMonth()->format('d/m/Y') }}</td>
                <td>{{ $halfsum }}</td>
            </tr> --}}
            <tr>
                <td colspan="2"><strong>एकूण</strong></td>
                <td><strong>{{  $totalrate }}</strong></td>
            </tr>
        </tbody>
    </table>
</br>
    <p> 
 <?php
// मराठी मध्ये नंबर कन्व्हर्ट करण्याचा फंक्शन
function convert_number_to_words_in_marathi($amount)
{
    $number = (int) floor($amount);
    $paise  = (int) round(($amount - $number) * 100);

    $words = [
        0=>"शून्य",1=>"एक",2=>"दोन",3=>"तीन",4=>"चार",5=>"पाच",6=>"सहा",7=>"सात",8=>"आठ",9=>"नऊ",
        10=>"दहा",11=>"अकरा",12=>"बारा",13=>"तेरा",14=>"चौदा",15=>"पंधरा",16=>"सोळा",17=>"सतरा",
        18=>"अठरा",19=>"एकोणीस",20=>"वीस",21=>"एकवीस",22=>"बावीस",23=>"तेवीस",24=>"चोवीस",
        25=>"पंचवीस",26=>"सव्वीस",27=>"सत्तावीस",28=>"अठ्ठावीस",29=>"एकोणतीस",30=>"तीस",
        31=>"एकतीस",32=>"बत्तीस",33=>"तेहतीस",34=>"चौतीस",35=>"पस्तीस",36=>"छत्तीस",
        37=>"सत्ततीस",38=>"अडतीस",39=>"एकोणचाळीस",40=>"चाळीस",41=>"एक्केचाळीस",42=>"बेचाळीस",
        43=>"त्रेचाळीस",44=>"चव्वेचाळीस",45=>"पंचेचाळीस",46=>"सेहेचाळीस",47=>"सत्तेचाळीस",
        48=>"अठ्ठेचाळीस",49=>"एकोणपन्नास",50=>"पन्नास",51=>"एक्कावन्न",52=>"बावन्न",
        53=>"त्रेपन्न",54=>"चोपन्न",55=>"पंचावन्न",56=>"छप्पन",57=>"सत्तावन्न",58=>"अठ्ठावन्न",
        59=>"एकोणसाठ",60=>"साठ",61=>"एकसष्ट",62=>"बासष्ट",63=>"त्रेसष्ट",64=>"चौसष्ट",
        65=>"पासष्ट",66=>"सहासष्ट",67=>"सडसष्ट",68=>"अडुसष्ट",69=>"एकोणसत्तर",70=>"सत्तर",
        71=>"एक्काहत्तर",72=>"बाहत्तर",73=>"त्र्याहत्तर",74=>"चौर्‍याहत्तर",75=>"पंच्याहत्तर",
        76=>"शहात्तर",77=>"सत्त्याहत्तर",78=>"अठ्ठ्याहत्तर",79=>"एकोणऐंशी",80=>"ऐंशी",
        81=>"एक्क्याऐंशी",82=>"ब्याऐंशी",83=>"त्र्याऐंशी",84=>"चौर्‍याऐंशी",85=>"पंच्याऐंशी",
        86=>"शहाऐंशी",87=>"सत्त्याऐंशी",88=>"अठ्ठ्याऐंशी",89=>"एकोणनव्वद",90=>"नव्वद",
        91=>"एक्क्याण्णव",92=>"ब्याण्णव",93=>"त्र्याण्णव",94=>"चौर्‍याण्णव",95=>"पंच्याण्णव",
        96=>"शहाण्णव",97=>"सत्त्याण्णव",98=>"अठ्ठ्याण्णव",99=>"नव्याण्णव"
    ];

    $scales = ["", "हजार", "लाख", "कोटी"];

    if ($number == 0) {
        $result = "शून्य रुपये";
    } else {
        $result = "";
        $chunks = [];

        // पहिला गट: 3 अंकी
        $chunks[] = $number % 1000;
        $number = intdiv($number, 1000);

        // नंतरच्या गटांसाठी 2-आंकी
        while ($number > 0) {
            $chunks[] = $number % 100;
            $number = intdiv($number, 100);
        }

        for ($i = count($chunks) - 1; $i >= 0; $i--) {
            if ($chunks[$i] > 0) {
                $part = convert_three_digits_marathi($chunks[$i], $words);
                if ($part !== "") {
                    $result .= $part . ($scales[$i] ? " " . $scales[$i] : "") . " ";
                }
            }
        }

        $result = trim($result) . " रुपये";
    }

    if ($paise > 0) {
        $result .= " आणि " . convert_two_digits_marathi($paise, $words) . " पैसे";
    }

    return $result . " फक्त";
}

function convert_three_digits_marathi($n, $words)
{
    $out = "";

    if ($n >= 100) {
        $h = intdiv($n, 100);
        $out .= $h == 1 ? "शंभर" : $words[$h] . "शे";
        $n = $n % 100;
        if ($n) $out .= " ";
    }

    if ($n > 0) {
        $out .= convert_two_digits_marathi($n, $words);
    }

    return trim($out);
}

function convert_two_digits_marathi($n, $words)
{
    return $words[$n] ?? "";
}

// === डायनॅमिक $totalrate ===
// हे डेटाबेस किंवा फॉर्ममधून येईल
// उदाहरण म्हणून फक्त assign केले आहे
// $totalrate = $db_row['totalrate'] ?? 0;      

$amount_in_words = convert_number_to_words_in_marathi($totalrate);

// === HTML आउटपुट ===
echo '<strong>वरील तक्त्यात नमूद प्रमाणे होणारी जाहिरात रक्कम ' 
     . number_format($totalrate, 2) . ' रु. ' 
     . $amount_in_words 
     . ' चा धनादेश/धनाकर्ष/रोख रक्कम महानगरपालिकस आगाऊ स्वरुपात जमा करावी.</strong>';
?>







</p>

    <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;तरी सदर उभारण्यात आलेल्या जाहिरात फलक लायसन नुतनीकरण परवानगी करिता वरील प्रमाणे आवश्यक
        असणारी कागदपत्रे तसेच वरील तक्त्यात नमुद प्रमाणे होणारी जाहिरात की धनादेश / धनाकर्ष रोख रक्कम
        महानगरपालिकेस सादर करावी. जेणेकरून आपण उभारण्यात आलेल्या जाहिरात फलक करिता परवानगी देण्याची कार्यवाही करता
        येईल.</p>

</body>
</html>
